/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import java.util.ArrayList;
import java.util.TreeSet;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.Condition;
import org.h2.index.IndexCondition;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public final class ConditionInConstantSet
extends Condition {
    private Expression left;
    private final boolean not;
    private final boolean whenOperand;
    private final ArrayList<Expression> valueList;
    private final TreeSet<Value> valueSet;
    private boolean hasNull;
    private final TypeInfo type;

    ConditionInConstantSet(SessionLocal session, Expression left, boolean not, boolean whenOperand, ArrayList<Expression> valueList) {
        this.left = left;
        this.not = not;
        this.whenOperand = whenOperand;
        this.valueList = valueList;
        this.valueSet = new TreeSet<Value>(session.getDatabase().getCompareMode());
        TypeInfo type = left.getType();
        for (Expression expression : valueList) {
            type = TypeInfo.getHigherType(type, expression.getType());
        }
        this.type = type;
        for (Expression expression : valueList) {
            this.add(expression.getValue(session), session);
        }
    }

    private void add(Value v, SessionLocal session) {
        if ((v = v.convertTo(this.type, (CastDataProvider)session)).containsNull()) {
            this.hasNull = true;
        } else {
            this.valueSet.add(v);
        }
    }

    @Override
    public Value getValue(SessionLocal session) {
        return this.getValue(this.left.getValue(session), session);
    }

    @Override
    public boolean getWhenValue(SessionLocal session, Value left) {
        if (!this.whenOperand) {
            return super.getWhenValue(session, left);
        }
        return this.getValue(left, session).isTrue();
    }

    private Value getValue(Value left, SessionLocal session) {
        if ((left = left.convertTo(this.type, (CastDataProvider)session)).containsNull()) {
            return ValueNull.INSTANCE;
        }
        boolean result = this.valueSet.contains(left);
        if (!result && this.hasNull) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(this.not ^ result);
    }

    @Override
    public boolean isWhenConditionOperand() {
        return this.whenOperand;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        return this;
    }

    @Override
    public Expression getNotIfPossible(SessionLocal session) {
        if (this.whenOperand) {
            return null;
        }
        return new ConditionInConstantSet(session, this.left, !this.not, false, this.valueList);
    }

    @Override
    public void createIndexConditions(SessionLocal session, TableFilter filter) {
        TypeInfo colType;
        if (this.not || this.whenOperand || !(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn l = (ExpressionColumn)this.left;
        if (filter != l.getTableFilter()) {
            return;
        }
        if (session.getDatabase().getSettings().optimizeInList && TypeInfo.haveSameOrdering(colType = l.getType(), TypeInfo.getHigherType(colType, this.type))) {
            filter.addIndexCondition(IndexCondition.getInList(l, this.valueList));
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
    }

    @Override
    public boolean needParentheses() {
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return this.getWhenSQL(this.left.getSQL(builder, sqlFlags, 0), sqlFlags);
    }

    @Override
    public StringBuilder getWhenSQL(StringBuilder builder, int sqlFlags) {
        if (this.not) {
            builder.append(" NOT");
        }
        return ConditionInConstantSet.writeExpressions(builder.append(" IN("), this.valueList, sqlFlags).append(')');
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        this.left.updateAggregate(session, stage);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost();
    }

    Expression getAdditional(SessionLocal session, Comparison other) {
        Expression add;
        if (!this.not && !this.whenOperand && this.left.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) && (add = other.getIfEquals(this.left)) != null && add.isConstant()) {
            ArrayList<Expression> list = new ArrayList<Expression>(this.valueList.size() + 1);
            list.addAll(this.valueList);
            list.add(add);
            return new ConditionInConstantSet(session, this.left, false, false, list);
        }
        return null;
    }

    @Override
    public int getSubexpressionCount() {
        return 1 + this.valueList.size();
    }

    @Override
    public Expression getSubexpression(int index) {
        if (index == 0) {
            return this.left;
        }
        if (index > 0 && index <= this.valueList.size()) {
            return this.valueList.get(index - 1);
        }
        throw new IndexOutOfBoundsException();
    }
}

