/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.Condition;
import org.h2.expression.condition.ConditionAndOrN;
import org.h2.expression.condition.ConditionIn;
import org.h2.expression.condition.ConditionInConstantSet;
import org.h2.expression.condition.ConditionNot;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionAndOr
extends Condition {
    public static final int AND = 0;
    public static final int OR = 1;
    private final int andOrType;
    private Expression left;
    private Expression right;
    private Expression added;

    public ConditionAndOr(int andOrType, Expression left, Expression right) {
        if (left == null || right == null) {
            throw DbException.getInternalError(left + " " + right);
        }
        this.andOrType = andOrType;
        this.left = left;
        this.right = right;
    }

    int getAndOrType() {
        return this.andOrType;
    }

    @Override
    public boolean needParentheses() {
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        this.left.getSQL(builder, sqlFlags, 0);
        switch (this.andOrType) {
            case 0: {
                builder.append("\n    AND ");
                break;
            }
            case 1: {
                builder.append("\n    OR ");
                break;
            }
            default: {
                throw DbException.getInternalError("andOrType=" + this.andOrType);
            }
        }
        return this.right.getSQL(builder, sqlFlags, 0);
    }

    @Override
    public void createIndexConditions(SessionLocal session, TableFilter filter) {
        if (this.andOrType == 0) {
            this.left.createIndexConditions(session, filter);
            this.right.createIndexConditions(session, filter);
            if (this.added != null) {
                this.added.createIndexConditions(session, filter);
            }
        }
    }

    @Override
    public Expression getNotIfPossible(SessionLocal session) {
        Expression r;
        Expression l = this.left.getNotIfPossible(session);
        if (l == null) {
            l = new ConditionNot(this.left);
        }
        if ((r = this.right.getNotIfPossible(session)) == null) {
            r = new ConditionNot(this.right);
        }
        int reversed = this.andOrType == 0 ? 1 : 0;
        return new ConditionAndOr(reversed, l, r);
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value l = this.left.getValue(session);
        switch (this.andOrType) {
            case 0: {
                Value r;
                if (l.isFalse() || (r = this.right.getValue(session)).isFalse()) {
                    return ValueBoolean.FALSE;
                }
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return ValueBoolean.TRUE;
            }
            case 1: {
                Value r;
                if (l.isTrue() || (r = this.right.getValue(session)).isTrue()) {
                    return ValueBoolean.TRUE;
                }
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return ValueBoolean.FALSE;
            }
        }
        throw DbException.getInternalError("type=" + this.andOrType);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        int lc = this.left.getCost();
        int rc = this.right.getCost();
        if (rc < lc) {
            Expression t = this.left;
            this.left = this.right;
            this.right = t;
        }
        switch (this.andOrType) {
            case 0: {
                Expression added;
                if (!session.getDatabase().getSettings().optimizeTwoEquals || !(this.left instanceof Comparison) || !(this.right instanceof Comparison) || (added = ((Comparison)this.left).getAdditionalAnd(session, (Comparison)this.right)) == null) break;
                this.added = added.optimize(session);
                break;
            }
            case 1: {
                Expression reduced;
                if (!session.getDatabase().getSettings().optimizeOr) break;
                if (this.left instanceof Comparison && this.right instanceof Comparison) {
                    reduced = ((Comparison)this.left).optimizeOr(session, (Comparison)this.right);
                } else if (this.left instanceof ConditionIn && this.right instanceof Comparison) {
                    reduced = ((ConditionIn)this.left).getAdditional((Comparison)this.right);
                } else if (this.right instanceof ConditionIn && this.left instanceof Comparison) {
                    reduced = ((ConditionIn)this.right).getAdditional((Comparison)this.left);
                } else if (this.left instanceof ConditionInConstantSet && this.right instanceof Comparison) {
                    reduced = ((ConditionInConstantSet)this.left).getAdditional(session, (Comparison)this.right);
                } else if (this.right instanceof ConditionInConstantSet && this.left instanceof Comparison) {
                    reduced = ((ConditionInConstantSet)this.right).getAdditional(session, (Comparison)this.left);
                } else {
                    if (!(this.left instanceof ConditionAndOr) || !(this.right instanceof ConditionAndOr)) break;
                    reduced = ConditionAndOr.optimizeConditionAndOr((ConditionAndOr)this.left, (ConditionAndOr)this.right);
                }
                if (reduced == null) break;
                return reduced.optimize(session);
            }
        }
        Expression e = ConditionAndOr.optimizeIfConstant(session, this.andOrType, this.left, this.right);
        if (e == null) {
            return ConditionAndOr.optimizeN(this);
        }
        if (e instanceof ConditionAndOr) {
            return ConditionAndOr.optimizeN((ConditionAndOr)e);
        }
        return e;
    }

    private static Expression optimizeN(ConditionAndOr condition) {
        Condition rightCondition;
        if (condition.right instanceof ConditionAndOr) {
            rightCondition = (ConditionAndOr)condition.right;
            if (((ConditionAndOr)rightCondition).andOrType == condition.andOrType) {
                return new ConditionAndOrN(condition.andOrType, condition.left, ((ConditionAndOr)rightCondition).left, ((ConditionAndOr)rightCondition).right);
            }
        }
        if (condition.right instanceof ConditionAndOrN && ((ConditionAndOrN)(rightCondition = (ConditionAndOrN)condition.right)).getAndOrType() == condition.andOrType) {
            ((ConditionAndOrN)rightCondition).addFirst(condition.left);
            return rightCondition;
        }
        return condition;
    }

    static Expression optimizeIfConstant(SessionLocal session, int andOrType, Expression left, Expression right) {
        if (!left.isConstant()) {
            if (!right.isConstant()) {
                return null;
            }
            return ConditionAndOr.optimizeConstant(session, andOrType, right.getValue(session), left);
        }
        Value l = left.getValue(session);
        if (!right.isConstant()) {
            return ConditionAndOr.optimizeConstant(session, andOrType, l, right);
        }
        Value r = right.getValue(session);
        switch (andOrType) {
            case 0: {
                if (l.isFalse() || r.isFalse()) {
                    return ValueExpression.FALSE;
                }
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return TypedValueExpression.UNKNOWN;
                }
                return ValueExpression.TRUE;
            }
            case 1: {
                if (l.isTrue() || r.isTrue()) {
                    return ValueExpression.TRUE;
                }
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return TypedValueExpression.UNKNOWN;
                }
                return ValueExpression.FALSE;
            }
        }
        throw DbException.getInternalError("type=" + andOrType);
    }

    private static Expression optimizeConstant(SessionLocal session, int andOrType, Value l, Expression right) {
        if (l != ValueNull.INSTANCE) {
            switch (andOrType) {
                case 0: {
                    return l.getBoolean() ? ConditionAndOr.castToBoolean(session, right) : ValueExpression.FALSE;
                }
                case 1: {
                    return l.getBoolean() ? ValueExpression.TRUE : ConditionAndOr.castToBoolean(session, right);
                }
            }
            throw DbException.getInternalError("type=" + andOrType);
        }
        return null;
    }

    @Override
    public void addFilterConditions(TableFilter filter) {
        if (this.andOrType == 0) {
            this.left.addFilterConditions(filter);
            this.right.addFilterConditions(filter);
        } else {
            super.addFilterConditions(filter);
        }
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
        this.right.mapColumns(resolver, level, state);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        this.right.setEvaluatable(tableFilter, b);
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        this.left.updateAggregate(session, stage);
        this.right.updateAggregate(session, stage);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.right.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.right.getCost();
    }

    @Override
    public int getSubexpressionCount() {
        return 2;
    }

    @Override
    public Expression getSubexpression(int index) {
        switch (index) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    static Expression optimizeConditionAndOr(ConditionAndOr left, ConditionAndOr right) {
        if (left.andOrType != 0 || right.andOrType != 0) {
            return null;
        }
        Expression leftLeft = left.getSubexpression(0);
        Expression leftRight = left.getSubexpression(1);
        Expression rightLeft = right.getSubexpression(0);
        Expression rightRight = right.getSubexpression(1);
        String rightLeftSQL = rightLeft.getSQL(0);
        String rightRightSQL = rightRight.getSQL(0);
        if (leftLeft.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR)) {
            String leftLeftSQL = leftLeft.getSQL(0);
            if (leftLeftSQL.equals(rightLeftSQL)) {
                return new ConditionAndOr(0, leftLeft, new ConditionAndOr(1, leftRight, rightRight));
            }
            if (leftLeftSQL.equals(rightRightSQL)) {
                return new ConditionAndOr(0, leftLeft, new ConditionAndOr(1, leftRight, rightLeft));
            }
        }
        if (leftRight.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR)) {
            String leftRightSQL = leftRight.getSQL(0);
            if (leftRightSQL.equals(rightLeftSQL)) {
                return new ConditionAndOr(0, leftRight, new ConditionAndOr(1, leftLeft, rightRight));
            }
            if (leftRightSQL.equals(rightRightSQL)) {
                return new ConditionAndOr(0, leftRight, new ConditionAndOr(1, leftLeft, rightLeft));
            }
        }
        return null;
    }
}

