/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import org.h2.command.query.QueryOrderBy;
import org.h2.command.query.Select;
import org.h2.command.query.SelectGroups;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.analysis.PartitionData;
import org.h2.expression.analysis.Window;
import org.h2.expression.analysis.WindowFrame;
import org.h2.expression.analysis.WindowFrameBound;
import org.h2.expression.analysis.WindowFrameUnits;
import org.h2.message.DbException;
import org.h2.result.SortOrder;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueInteger;

public abstract class DataAnalysisOperation
extends Expression {
    public static final int STAGE_RESET = 0;
    public static final int STAGE_GROUP = 1;
    public static final int STAGE_WINDOW = 2;
    protected final Select select;
    protected Window over;
    protected SortOrder overOrderBySort;
    private int numFrameExpressions;
    private int lastGroupRowId;

    protected static SortOrder createOrder(SessionLocal session, ArrayList<QueryOrderBy> orderBy, int offset) {
        int size = orderBy.size();
        int[] index = new int[size];
        int[] sortType = new int[size];
        for (int i = 0; i < size; ++i) {
            QueryOrderBy o = orderBy.get(i);
            index[i] = i + offset;
            sortType[i] = o.sortType;
        }
        return new SortOrder(session, index, sortType, null);
    }

    protected DataAnalysisOperation(Select select) {
        this.select = select;
    }

    public Window getOverCondition() {
        return this.over;
    }

    public void setOverCondition(Window over) {
        this.over = over;
    }

    public abstract boolean isAggregate();

    protected SortOrder getOverOrderBySort() {
        return this.overOrderBySort;
    }

    @Override
    public final void mapColumns(ColumnResolver resolver, int level, int state) {
        if (this.over != null) {
            if (state != 0) {
                throw DbException.get(90054, this.getTraceSQL());
            }
            state = 1;
        } else {
            if (state == 2) {
                throw DbException.get(90054, this.getTraceSQL());
            }
            state = 2;
        }
        this.mapColumnsAnalysis(resolver, level, state);
    }

    protected void mapColumnsAnalysis(ColumnResolver resolver, int level, int innerState) {
        if (this.over != null) {
            this.over.mapColumns(resolver, level);
        }
    }

    @Override
    public Expression optimize(SessionLocal session) {
        if (this.over != null) {
            this.over.optimize(session);
            ArrayList<QueryOrderBy> orderBy = this.over.getOrderBy();
            if (orderBy != null) {
                this.overOrderBySort = DataAnalysisOperation.createOrder(session, orderBy, this.getNumExpressions());
            } else if (!this.isAggregate()) {
                this.overOrderBySort = new SortOrder(session, new int[this.getNumExpressions()]);
            }
            WindowFrame frame = this.over.getWindowFrame();
            if (frame != null) {
                int index = this.getNumExpressions();
                int orderBySize = 0;
                if (orderBy != null) {
                    orderBySize = orderBy.size();
                    index += orderBySize;
                }
                int n = 0;
                WindowFrameBound bound = frame.getStarting();
                if (bound.isParameterized()) {
                    this.checkOrderBy(frame.getUnits(), orderBySize);
                    if (bound.isVariable()) {
                        bound.setExpressionIndex(index);
                        ++n;
                    }
                }
                if ((bound = frame.getFollowing()) != null && bound.isParameterized()) {
                    this.checkOrderBy(frame.getUnits(), orderBySize);
                    if (bound.isVariable()) {
                        bound.setExpressionIndex(index + n);
                        ++n;
                    }
                }
                this.numFrameExpressions = n;
            }
        }
        return this;
    }

    private void checkOrderBy(WindowFrameUnits units, int orderBySize) {
        switch (units) {
            case RANGE: {
                if (orderBySize == 1) break;
                String sql = this.getTraceSQL();
                throw DbException.getSyntaxError(sql, sql.length() - 1, "exactly one sort key is required for RANGE units");
            }
            case GROUPS: {
                if (orderBySize >= 1) break;
                String sql = this.getTraceSQL();
                throw DbException.getSyntaxError(sql, sql.length() - 1, "a sort key is required for GROUPS units");
            }
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        if (this.over != null) {
            this.over.setEvaluatable(tableFilter, b);
        }
    }

    @Override
    public final void updateAggregate(SessionLocal session, int stage) {
        if (stage == 0) {
            this.updateGroupAggregates(session, 0);
            this.lastGroupRowId = 0;
            return;
        }
        boolean window = stage == 2;
        if (window != (this.over != null)) {
            if (!window && this.select.isWindowQuery()) {
                this.updateGroupAggregates(session, stage);
            }
            return;
        }
        SelectGroups groupData = this.select.getGroupDataIfCurrent(window);
        if (groupData == null) {
            return;
        }
        int groupRowId = groupData.getCurrentGroupRowId();
        if (this.lastGroupRowId == groupRowId) {
            return;
        }
        this.lastGroupRowId = groupRowId;
        if (this.over != null && !this.select.isGroupQuery()) {
            this.over.updateAggregate(session, stage);
        }
        this.updateAggregate(session, groupData, groupRowId);
    }

    protected abstract void updateAggregate(SessionLocal var1, SelectGroups var2, int var3);

    protected void updateGroupAggregates(SessionLocal session, int stage) {
        if (this.over != null) {
            this.over.updateAggregate(session, stage);
        }
    }

    protected abstract int getNumExpressions();

    private int getNumFrameExpressions() {
        return this.numFrameExpressions;
    }

    protected abstract void rememberExpressions(SessionLocal var1, Value[] var2);

    protected Object getWindowData(SessionLocal session, SelectGroups groupData, boolean forOrderBy) {
        Object data;
        Value key = this.over.getCurrentKey(session);
        PartitionData partition = groupData.getWindowExprData(this, key);
        if (partition == null) {
            data = forOrderBy ? new ArrayList() : this.createAggregateData();
            groupData.setWindowExprData(this, key, new PartitionData(data));
        } else {
            data = partition.getData();
        }
        return data;
    }

    protected Object getGroupData(SelectGroups groupData, boolean ifExists) {
        Object data = groupData.getCurrentGroupExprData(this);
        if (data == null) {
            if (ifExists) {
                return null;
            }
            data = this.createAggregateData();
            groupData.setCurrentGroupExprData(this, data);
        }
        return data;
    }

    protected abstract Object createAggregateData();

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        if (this.over == null) {
            return true;
        }
        switch (visitor.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 8: 
            case 11: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Value getValue(SessionLocal session) {
        SelectGroups groupData = this.select.getGroupDataIfCurrent(this.over != null);
        if (groupData == null) {
            throw DbException.get(90054, this.getTraceSQL());
        }
        return this.over == null ? this.getAggregatedValue(session, this.getGroupData(groupData, true)) : this.getWindowResult(session, groupData);
    }

    private Value getWindowResult(SessionLocal session, SelectGroups groupData) {
        Object data;
        boolean isOrdered = this.over.isOrdered();
        Value key = this.over.getCurrentKey(session);
        PartitionData partition = groupData.getWindowExprData(this, key);
        if (partition == null) {
            data = isOrdered ? new ArrayList() : this.createAggregateData();
            partition = new PartitionData(data);
            groupData.setWindowExprData(this, key, partition);
        } else {
            data = partition.getData();
        }
        if (isOrdered || !this.isAggregate()) {
            Value result = this.getOrderedResult(session, groupData, partition, data);
            if (result == null) {
                return this.getAggregatedValue(session, null);
            }
            return result;
        }
        Value result = partition.getResult();
        if (result == null) {
            result = this.getAggregatedValue(session, data);
            partition.setResult(result);
        }
        return result;
    }

    protected abstract Value getAggregatedValue(SessionLocal var1, Object var2);

    protected void updateOrderedAggregate(SessionLocal session, SelectGroups groupData, int groupRowId, ArrayList<QueryOrderBy> orderBy) {
        int ne = this.getNumExpressions();
        int size = orderBy != null ? orderBy.size() : 0;
        int frameSize = this.getNumFrameExpressions();
        Value[] array = new Value[ne + size + frameSize + 1];
        this.rememberExpressions(session, array);
        for (int i = 0; i < size; ++i) {
            QueryOrderBy o = orderBy.get(i);
            array[ne++] = o.expression.getValue(session);
        }
        if (frameSize > 0) {
            WindowFrame frame = this.over.getWindowFrame();
            WindowFrameBound bound = frame.getStarting();
            if (bound.isVariable()) {
                array[ne++] = bound.getValue().getValue(session);
            }
            if ((bound = frame.getFollowing()) != null && bound.isVariable()) {
                array[ne++] = bound.getValue().getValue(session);
            }
        }
        array[ne] = ValueInteger.get(groupRowId);
        ArrayList data = (ArrayList)this.getWindowData(session, groupData, true);
        data.add(array);
    }

    private Value getOrderedResult(SessionLocal session, SelectGroups groupData, PartitionData partition, Object data) {
        HashMap<Integer, Value> result = partition.getOrderedResult();
        if (result == null) {
            result = new HashMap();
            ArrayList orderedData = (ArrayList)data;
            int rowIdColumn = this.getNumExpressions();
            ArrayList<QueryOrderBy> orderBy = this.over.getOrderBy();
            if (orderBy != null) {
                rowIdColumn += orderBy.size();
                orderedData.sort(this.overOrderBySort);
            }
            this.getOrderedResultLoop(session, result, orderedData, rowIdColumn += this.getNumFrameExpressions());
            partition.setOrderedResult(result);
        }
        return result.get(groupData.getCurrentGroupRowId());
    }

    protected abstract void getOrderedResultLoop(SessionLocal var1, HashMap<Integer, Value> var2, ArrayList<Value[]> var3, int var4);

    protected StringBuilder appendTailConditions(StringBuilder builder, int sqlFlags, boolean forceOrderBy) {
        if (this.over != null) {
            builder.append(' ');
            this.over.getSQL(builder, sqlFlags, forceOrderBy);
        }
        return builder;
    }
}

