/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.Operation1;
import org.h2.expression.ValueExpression;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class UnaryOperation
extends Operation1 {
    public UnaryOperation(Expression arg) {
        super(arg);
    }

    @Override
    public boolean needParentheses() {
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return this.arg.getSQL(builder.append("- "), sqlFlags, 0);
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value a = this.arg.getValue(session).convertTo(this.type, (CastDataProvider)session);
        return a == ValueNull.INSTANCE ? a : a.negate();
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.arg = this.arg.optimize(session);
        this.type = this.arg.getType();
        if (this.type.getValueType() == -1) {
            this.type = TypeInfo.TYPE_NUMERIC_FLOATING_POINT;
        } else if (this.type.getValueType() == 36) {
            this.type = TypeInfo.TYPE_INTEGER;
        }
        if (this.arg.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }
}

