/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.Objects;
import org.h2.expression.ValueExpression;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class TypedValueExpression
extends ValueExpression {
    public static final TypedValueExpression UNKNOWN = new TypedValueExpression(ValueNull.INSTANCE, TypeInfo.TYPE_BOOLEAN);
    private final TypeInfo type;

    public static ValueExpression get(Value value, TypeInfo type) {
        return TypedValueExpression.getImpl(value, type, true);
    }

    public static ValueExpression getTypedIfNull(Value value, TypeInfo type) {
        return TypedValueExpression.getImpl(value, type, false);
    }

    private static ValueExpression getImpl(Value value, TypeInfo type, boolean preserveStrictType) {
        if (value == ValueNull.INSTANCE) {
            switch (type.getValueType()) {
                case 0: {
                    return ValueExpression.NULL;
                }
                case 8: {
                    return UNKNOWN;
                }
            }
            return new TypedValueExpression(value, type);
        }
        if (preserveStrictType) {
            DataType dt = DataType.getDataType(type.getValueType());
            TypeInfo vt = value.getType();
            if (dt.supportsPrecision && type.getPrecision() != vt.getPrecision() || dt.supportsScale && type.getScale() != vt.getScale() || !Objects.equals(type.getExtTypeInfo(), vt.getExtTypeInfo())) {
                return new TypedValueExpression(value, type);
            }
        }
        return ValueExpression.get(value);
    }

    private TypedValueExpression(Value value, TypeInfo type) {
        super(value);
        this.type = type;
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        if (this == UNKNOWN) {
            builder.append("UNKNOWN");
        } else {
            this.value.getSQL(builder.append("CAST("), sqlFlags | 4).append(" AS ");
            this.type.getSQL(builder, sqlFlags).append(')');
        }
        return builder;
    }

    @Override
    public boolean isNullConstant() {
        return this.value == ValueNull.INSTANCE;
    }
}

