/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.h2.command.query.Query;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionList;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.TypeInfo;
import org.h2.value.Typed;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueRow;

public final class Subquery
extends Expression {
    private final Query query;
    private Expression expression;
    private Value nullValue;
    private HashSet<ColumnResolver> outerResolvers = new HashSet();

    public Subquery(Query query) {
        this.query = query;
    }

    @Override
    public Value getValue(SessionLocal session) {
        this.query.setSession(session);
        try (ResultInterface result = this.query.query(2L);){
            if (!result.next()) {
                Value value = this.nullValue;
                return value;
            }
            Value v = this.readRow(result);
            if (result.hasNext()) {
                throw DbException.get(90053);
            }
            Value value = v;
            return value;
        }
    }

    public ArrayList<Value> getAllRows(SessionLocal session) {
        ArrayList<Value> list = new ArrayList<Value>();
        this.query.setSession(session);
        try (ResultInterface result = this.query.query(Integer.MAX_VALUE);){
            while (result.next()) {
                list.add(this.readRow(result));
            }
        }
        return list;
    }

    private Value readRow(ResultInterface result) {
        Value[] values = result.currentRow();
        int visible = result.getVisibleColumnCount();
        return visible == 1 ? values[0] : ValueRow.get(this.getType(), visible == values.length ? values : Arrays.copyOf(values, visible));
    }

    @Override
    public TypeInfo getType() {
        return this.expression.getType();
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.outerResolvers.add(resolver);
        this.query.mapColumns(resolver, level + 1);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        Expression e;
        this.query.prepare();
        if (this.query.isConstantQuery()) {
            this.setType();
            return ValueExpression.get(this.getValue(session));
        }
        if (this.outerResolvers != null && session.getDatabase().getSettings().optimizeSimpleSingleRowSubqueries && (e = this.query.getIfSingleRow()) != null && e.isEverything(ExpressionVisitor.getDecrementQueryLevelVisitor(this.outerResolvers, 0))) {
            e.isEverything(ExpressionVisitor.getDecrementQueryLevelVisitor(this.outerResolvers, 1));
            return e.optimize(session);
        }
        this.outerResolvers = null;
        this.setType();
        return this;
    }

    private void setType() {
        ArrayList<Expression> expressions = this.query.getExpressions();
        int columnCount = this.query.getColumnCount();
        if (columnCount == 1) {
            this.expression = expressions.get(0);
            this.nullValue = ValueNull.INSTANCE;
        } else {
            Typed[] list = new Expression[columnCount];
            Value[] nulls = new Value[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                list[i] = expressions.get(i);
                nulls[i] = ValueNull.INSTANCE;
            }
            ExpressionList expressionList = new ExpressionList((Expression[])list, false);
            expressionList.initializeType();
            this.expression = expressionList;
            this.nullValue = ValueRow.get(new ExtTypeInfoRow(list), nulls);
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.query.setEvaluatable(tableFilter, b);
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return builder.append('(').append(this.query.getPlanSQL(sqlFlags)).append(')');
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        this.query.updateAggregate(session, stage);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.query.isEverything(visitor);
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public int getCost() {
        return this.query.getCostAsExpression();
    }

    @Override
    public boolean isConstant() {
        return this.query.isConstantQuery();
    }
}

