/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public final class SimpleCase
extends Expression {
    private Expression operand;
    private SimpleWhen when;
    private Expression elseResult;
    private TypeInfo type;

    public SimpleCase(Expression operand, SimpleWhen when, Expression elseResult) {
        this.operand = operand;
        this.when = when;
        this.elseResult = elseResult;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value v = this.operand.getValue(session);
        SimpleWhen when = this.when;
        while (when != null) {
            for (Expression e : when.operands) {
                if (!e.getWhenValue(session, v)) continue;
                return when.result.getValue(session).convertTo(this.type, (CastDataProvider)session);
            }
            when = when.next;
        }
        if (this.elseResult != null) {
            return this.elseResult.getValue(session).convertTo(this.type, (CastDataProvider)session);
        }
        return ValueNull.INSTANCE;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        TypeInfo typeInfo = TypeInfo.TYPE_UNKNOWN;
        this.operand = this.operand.optimize(session);
        boolean allConst = this.operand.isConstant();
        Value v = null;
        if (allConst) {
            v = this.operand.getValue(session);
        }
        TypeInfo operandType = this.operand.getType();
        SimpleWhen when = this.when;
        while (when != null) {
            Expression[] operands = when.operands;
            for (int i = 0; i < operands.length; ++i) {
                Expression e = operands[i].optimize(session);
                if (!e.isWhenConditionOperand()) {
                    TypeInfo.checkComparable(operandType, e.getType());
                }
                if (allConst) {
                    if (e.isConstant()) {
                        if (e.getWhenValue(session, v)) {
                            return when.result.optimize(session);
                        }
                    } else {
                        allConst = false;
                    }
                }
                operands[i] = e;
            }
            when.result = when.result.optimize(session);
            typeInfo = SimpleCase.combineTypes(typeInfo, when.result);
            when = when.next;
        }
        if (this.elseResult != null) {
            this.elseResult = this.elseResult.optimize(session);
            if (allConst) {
                return this.elseResult;
            }
            typeInfo = SimpleCase.combineTypes(typeInfo, this.elseResult);
        } else if (allConst) {
            return ValueExpression.NULL;
        }
        if (typeInfo.getValueType() == -1) {
            typeInfo = TypeInfo.TYPE_VARCHAR;
        }
        this.type = typeInfo;
        return this;
    }

    static TypeInfo combineTypes(TypeInfo typeInfo, Expression e) {
        TypeInfo type;
        int valueType;
        if (!e.isNullConstant() && (valueType = (type = e.getType()).getValueType()) != -1 && valueType != 0) {
            typeInfo = TypeInfo.getHigherType(typeInfo, type);
        }
        return typeInfo;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        this.operand.getUnenclosedSQL(builder.append("CASE "), sqlFlags);
        SimpleWhen when = this.when;
        while (when != null) {
            builder.append(" WHEN");
            Expression[] operands = when.operands;
            int len = operands.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    builder.append(',');
                }
                operands[i].getWhenSQL(builder, sqlFlags);
            }
            when.result.getUnenclosedSQL(builder.append(" THEN "), sqlFlags);
            when = when.next;
        }
        if (this.elseResult != null) {
            this.elseResult.getUnenclosedSQL(builder.append(" ELSE "), sqlFlags);
        }
        return builder.append(" END");
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.operand.mapColumns(resolver, level, state);
        SimpleWhen when = this.when;
        while (when != null) {
            for (Expression e : when.operands) {
                e.mapColumns(resolver, level, state);
            }
            when.result.mapColumns(resolver, level, state);
            when = when.next;
        }
        if (this.elseResult != null) {
            this.elseResult.mapColumns(resolver, level, state);
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean value) {
        this.operand.setEvaluatable(tableFilter, value);
        SimpleWhen when = this.when;
        while (when != null) {
            for (Expression e : when.operands) {
                e.setEvaluatable(tableFilter, value);
            }
            when.result.setEvaluatable(tableFilter, value);
            when = when.next;
        }
        if (this.elseResult != null) {
            this.elseResult.setEvaluatable(tableFilter, value);
        }
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        this.operand.updateAggregate(session, stage);
        SimpleWhen when = this.when;
        while (when != null) {
            for (Expression e : when.operands) {
                e.updateAggregate(session, stage);
            }
            when.result.updateAggregate(session, stage);
            when = when.next;
        }
        if (this.elseResult != null) {
            this.elseResult.updateAggregate(session, stage);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        if (!this.operand.isEverything(visitor)) {
            return false;
        }
        SimpleWhen when = this.when;
        while (when != null) {
            for (Expression e : when.operands) {
                if (e.isEverything(visitor)) continue;
                return false;
            }
            if (!when.result.isEverything(visitor)) {
                return false;
            }
            when = when.next;
        }
        return this.elseResult == null || this.elseResult.isEverything(visitor);
    }

    @Override
    public int getCost() {
        int cost = 1;
        int resultCost = 0;
        cost += this.operand.getCost();
        SimpleWhen when = this.when;
        while (when != null) {
            for (Expression e : when.operands) {
                cost += e.getCost();
            }
            resultCost = Math.max(resultCost, when.result.getCost());
            when = when.next;
        }
        if (this.elseResult != null) {
            resultCost = Math.max(resultCost, this.elseResult.getCost());
        }
        return cost + resultCost;
    }

    @Override
    public int getSubexpressionCount() {
        int count = 1;
        SimpleWhen when = this.when;
        while (when != null) {
            count += when.operands.length + 1;
            when = when.next;
        }
        if (this.elseResult != null) {
            ++count;
        }
        return count;
    }

    @Override
    public Expression getSubexpression(int index) {
        if (index >= 0) {
            if (index == 0) {
                return this.operand;
            }
            int ptr = 1;
            SimpleWhen when = this.when;
            while (when != null) {
                int offset = index - ptr;
                Expression[] operands = when.operands;
                int count = operands.length;
                if (offset < count) {
                    return operands[offset];
                }
                ptr += count;
                if (index == ptr++) {
                    return when.result;
                }
                when = when.next;
            }
            if (this.elseResult != null && index == ptr) {
                return this.elseResult;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public static final class SimpleWhen {
        Expression[] operands;
        Expression result;
        SimpleWhen next;

        public SimpleWhen(Expression operand, Expression result) {
            this(new Expression[]{operand}, result);
        }

        public SimpleWhen(Expression[] operands, Expression result) {
            this.operands = operands;
            this.result = result;
        }

        public void setWhen(SimpleWhen next) {
            this.next = next;
        }
    }
}

