/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.Arrays;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ExpressionWithVariableParameters;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;

public abstract class OperationN
extends Expression
implements ExpressionWithVariableParameters {
    protected Expression[] args;
    protected int argsCount;
    protected TypeInfo type;

    protected OperationN(Expression[] args) {
        this.args = args;
    }

    @Override
    public void addParameter(Expression param) {
        int capacity = this.args.length;
        if (this.argsCount >= capacity) {
            this.args = Arrays.copyOf(this.args, capacity * 2);
        }
        this.args[this.argsCount++] = param;
    }

    @Override
    public void doneWithParameters() throws DbException {
        if (this.args.length != this.argsCount) {
            this.args = Arrays.copyOf(this.args, this.argsCount);
        }
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        for (Expression e : this.args) {
            e.mapColumns(resolver, level, state);
        }
    }

    protected boolean optimizeArguments(SessionLocal session, boolean allConst) {
        int l = this.args.length;
        for (int i = 0; i < l; ++i) {
            Expression e;
            this.args[i] = e = this.args[i].optimize(session);
            if (!allConst || e.isConstant()) continue;
            allConst = false;
        }
        return allConst;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean value) {
        for (Expression e : this.args) {
            e.setEvaluatable(tableFilter, value);
        }
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        for (Expression e : this.args) {
            e.updateAggregate(session, stage);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        for (Expression e : this.args) {
            if (e.isEverything(visitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        int cost = this.args.length + 1;
        for (Expression e : this.args) {
            cost += e.getCost();
        }
        return cost;
    }

    @Override
    public int getSubexpressionCount() {
        return this.args.length;
    }

    @Override
    public Expression getSubexpression(int index) {
        return this.args[index];
    }
}

