/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.List;
import org.h2.engine.SessionLocal;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.expression.function.NamedExpression;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.HasSQL;
import org.h2.util.StringUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Typed;
import org.h2.value.Value;

public abstract class Expression
implements HasSQL,
Typed {
    public static final int MAP_INITIAL = 0;
    public static final int MAP_IN_WINDOW = 1;
    public static final int MAP_IN_AGGREGATE = 2;
    public static final int AUTO_PARENTHESES = 0;
    public static final int WITH_PARENTHESES = 1;
    public static final int WITHOUT_PARENTHESES = 2;
    private boolean addedToFilter;

    public static StringBuilder writeExpressions(StringBuilder builder, List<? extends Expression> expressions, int sqlFlags) {
        int length = expressions.size();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            expressions.get(i).getUnenclosedSQL(builder, sqlFlags);
        }
        return builder;
    }

    public static StringBuilder writeExpressions(StringBuilder builder, Expression[] expressions, int sqlFlags) {
        int length = expressions.length;
        for (int i = 0; i < length; ++i) {
            Expression e;
            if (i > 0) {
                builder.append(", ");
            }
            if ((e = expressions[i]) == null) {
                builder.append("DEFAULT");
                continue;
            }
            e.getUnenclosedSQL(builder, sqlFlags);
        }
        return builder;
    }

    public abstract Value getValue(SessionLocal var1);

    @Override
    public abstract TypeInfo getType();

    public abstract void mapColumns(ColumnResolver var1, int var2, int var3);

    public abstract Expression optimize(SessionLocal var1);

    public final Expression optimizeCondition(SessionLocal session) {
        Expression e = this.optimize(session);
        if (e.isConstant()) {
            return e.getBooleanValue(session) ? null : ValueExpression.FALSE;
        }
        return e;
    }

    public abstract void setEvaluatable(TableFilter var1, boolean var2);

    @Override
    public final String getSQL(int sqlFlags) {
        return this.getSQL(new StringBuilder(), sqlFlags, 0).toString();
    }

    @Override
    public final StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return this.getSQL(builder, sqlFlags, 0);
    }

    public final String getSQL(int sqlFlags, int parentheses) {
        return this.getSQL(new StringBuilder(), sqlFlags, parentheses).toString();
    }

    public final StringBuilder getSQL(StringBuilder builder, int sqlFlags, int parentheses) {
        return parentheses == 1 || parentheses != 2 && this.needParentheses() ? this.getUnenclosedSQL(builder.append('('), sqlFlags).append(')') : this.getUnenclosedSQL(builder, sqlFlags);
    }

    public boolean needParentheses() {
        return false;
    }

    public final StringBuilder getEnclosedSQL(StringBuilder builder, int sqlFlags) {
        return this.getUnenclosedSQL(builder.append('('), sqlFlags).append(')');
    }

    public abstract StringBuilder getUnenclosedSQL(StringBuilder var1, int var2);

    public abstract void updateAggregate(SessionLocal var1, int var2);

    public abstract boolean isEverything(ExpressionVisitor var1);

    public abstract int getCost();

    public Expression getNotIfPossible(SessionLocal session) {
        return null;
    }

    public boolean isConstant() {
        return false;
    }

    public boolean isNullConstant() {
        return false;
    }

    public boolean isValueSet() {
        return false;
    }

    public boolean isIdentity() {
        return false;
    }

    public boolean getBooleanValue(SessionLocal session) {
        return this.getValue(session).isTrue();
    }

    public void createIndexConditions(SessionLocal session, TableFilter filter) {
    }

    public String getColumnName(SessionLocal session, int columnIndex) {
        return this.getAlias(session, columnIndex);
    }

    public String getSchemaName() {
        return null;
    }

    public String getTableName() {
        return null;
    }

    public int getNullable() {
        return 2;
    }

    public String getTableAlias() {
        return null;
    }

    public String getAlias(SessionLocal session, int columnIndex) {
        switch (session.getMode().expressionNames) {
            default: {
                String sql = this.getSQL(5, 2);
                if (sql.length() <= 256) {
                    return sql;
                }
            }
            case C_NUMBER: {
                return "C" + (columnIndex + 1);
            }
            case EMPTY: {
                return "";
            }
            case NUMBER: {
                return Integer.toString(columnIndex + 1);
            }
            case POSTGRESQL_STYLE: 
        }
        if (this instanceof NamedExpression) {
            return StringUtils.toLowerEnglish(((NamedExpression)((Object)this)).getName());
        }
        return "?column?";
    }

    public String getColumnNameForView(SessionLocal session, int columnIndex) {
        switch (session.getMode().viewExpressionNames) {
            default: {
                return this.getAlias(session, columnIndex);
            }
            case EXCEPTION: {
                throw DbException.get(90156, this.getTraceSQL());
            }
            case MYSQL_STYLE: 
        }
        String name = this.getSQL(5, 2);
        if (name.length() > 64) {
            name = "Name_exp_" + (columnIndex + 1);
        }
        return name;
    }

    public Expression getNonAliasExpression() {
        return this;
    }

    public void addFilterConditions(TableFilter filter) {
        if (!this.addedToFilter && this.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
            filter.addFilterCondition(this, false);
            this.addedToFilter = true;
        }
    }

    public String toString() {
        return this.getTraceSQL();
    }

    public int getSubexpressionCount() {
        return 0;
    }

    public Expression getSubexpression(int index) {
        throw new IndexOutOfBoundsException();
    }

    public boolean getWhenValue(SessionLocal session, Value left) {
        return session.compareWithNull(left, this.getValue(session), true) == 0;
    }

    public StringBuilder getWhenSQL(StringBuilder builder, int sqlFlags) {
        return this.getUnenclosedSQL(builder.append(' '), sqlFlags);
    }

    public boolean isWhenConditionOperand() {
        return false;
    }
}

