/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.CompatibilityDatePlusTimeOperation;
import org.h2.expression.ConcatenationOperation;
import org.h2.expression.Expression;
import org.h2.expression.IntervalOperation;
import org.h2.expression.Operation2;
import org.h2.expression.UnaryOperation;
import org.h2.expression.ValueExpression;
import org.h2.expression.function.DateTimeFunction;
import org.h2.message.DbException;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;

public class BinaryOperation
extends Operation2 {
    private OpType opType;
    private TypeInfo forcedType;
    private boolean convertRight = true;

    public BinaryOperation(OpType opType, Expression left, Expression right) {
        super(left, right);
        this.opType = opType;
    }

    public void setForcedType(TypeInfo forcedType) {
        if (this.opType != OpType.MINUS) {
            throw this.getUnexpectedForcedTypeException();
        }
        this.forcedType = forcedType;
    }

    @Override
    public boolean needParentheses() {
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        this.left.getSQL(builder, sqlFlags, 0).append(' ').append(this.getOperationToken()).append(' ');
        return this.right.getSQL(builder, sqlFlags, 0);
    }

    private String getOperationToken() {
        switch (this.opType) {
            case PLUS: {
                return "+";
            }
            case MINUS: {
                return "-";
            }
            case MULTIPLY: {
                return "*";
            }
            case DIVIDE: {
                return "/";
            }
        }
        throw DbException.getInternalError("opType=" + (Object)((Object)this.opType));
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value l = this.left.getValue(session).convertTo(this.type, (CastDataProvider)session);
        Value r = this.right.getValue(session);
        if (this.convertRight) {
            r = r.convertTo(this.type, (CastDataProvider)session);
        }
        switch (this.opType) {
            case PLUS: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return l.add(r);
            }
            case MINUS: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return l.subtract(r);
            }
            case MULTIPLY: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return l.multiply(r);
            }
            case DIVIDE: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return l.divide(r, this.type);
            }
        }
        throw DbException.getInternalError("type=" + (Object)((Object)this.opType));
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        TypeInfo leftType = this.left.getType();
        TypeInfo rightType = this.right.getType();
        int l = leftType.getValueType();
        int r = rightType.getValueType();
        if (l == 0 && r == 0 || l == -1 && r == -1) {
            if (this.opType == OpType.PLUS && session.getDatabase().getMode().allowPlusForStringConcat) {
                return new ConcatenationOperation(this.left, this.right).optimize(session);
            }
            this.type = TypeInfo.TYPE_NUMERIC_FLOATING_POINT;
        } else {
            if (DataType.isIntervalType(l) || DataType.isIntervalType(r)) {
                if (this.forcedType != null) {
                    throw this.getUnexpectedForcedTypeException();
                }
                return this.optimizeInterval(l, r);
            }
            if (DataType.isDateTimeType(l) || DataType.isDateTimeType(r)) {
                return this.optimizeDateTime(session, l, r);
            }
            if (this.forcedType != null) {
                throw this.getUnexpectedForcedTypeException();
            }
            int dataType = Value.getHigherOrder(l, r);
            if (dataType == 13) {
                this.optimizeNumeric(leftType, rightType);
            } else if (dataType == 16) {
                this.optimizeDecfloat(leftType, rightType);
            } else if (dataType == 36) {
                this.type = TypeInfo.TYPE_INTEGER;
            } else {
                if (DataType.isCharacterStringType(dataType) && this.opType == OpType.PLUS && session.getDatabase().getMode().allowPlusForStringConcat) {
                    return new ConcatenationOperation(this.left, this.right).optimize(session);
                }
                this.type = TypeInfo.getTypeInfo(dataType);
            }
        }
        if (this.left.isConstant() && this.right.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    private void optimizeNumeric(TypeInfo leftType, TypeInfo rightType) {
        long precision;
        int scale;
        leftType = leftType.toNumericType();
        rightType = rightType.toNumericType();
        long leftPrecision = leftType.getPrecision();
        long rightPrecision = rightType.getPrecision();
        int leftScale = leftType.getScale();
        int rightScale = rightType.getScale();
        switch (this.opType) {
            case PLUS: 
            case MINUS: {
                if (leftScale < rightScale) {
                    leftPrecision += (long)(rightScale - leftScale);
                    scale = rightScale;
                } else {
                    rightPrecision += (long)(leftScale - rightScale);
                    scale = leftScale;
                }
                precision = Math.max(leftPrecision, rightPrecision) + 1L;
                break;
            }
            case MULTIPLY: {
                precision = leftPrecision + rightPrecision;
                scale = leftScale + rightScale;
                break;
            }
            case DIVIDE: {
                long scaleAsLong = (long)(leftScale - rightScale) + rightPrecision * 2L;
                scale = scaleAsLong >= 100000L ? 100000 : (scaleAsLong <= 0L ? 0 : (int)scaleAsLong);
                precision = leftPrecision + (long)rightScale - (long)leftScale + (long)scale;
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + (Object)((Object)this.opType));
            }
        }
        this.type = TypeInfo.getTypeInfo(13, precision, scale, null);
    }

    private void optimizeDecfloat(TypeInfo leftType, TypeInfo rightType) {
        long precision;
        leftType = leftType.toDecfloatType();
        rightType = rightType.toDecfloatType();
        long leftPrecision = leftType.getPrecision();
        long rightPrecision = rightType.getPrecision();
        switch (this.opType) {
            case PLUS: 
            case MINUS: 
            case DIVIDE: {
                precision = Math.max(leftPrecision, rightPrecision) + 1L;
                break;
            }
            case MULTIPLY: {
                precision = leftPrecision + rightPrecision;
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + (Object)((Object)this.opType));
            }
        }
        this.type = TypeInfo.getTypeInfo(16, precision, 0, null);
    }

    private Expression optimizeInterval(int l, int r) {
        boolean lInterval = false;
        boolean lNumeric = false;
        boolean lDateTime = false;
        if (DataType.isIntervalType(l)) {
            lInterval = true;
        } else if (DataType.isNumericType(l)) {
            lNumeric = true;
        } else if (DataType.isDateTimeType(l)) {
            lDateTime = true;
        } else {
            throw this.getUnsupported(l, r);
        }
        boolean rInterval = false;
        boolean rNumeric = false;
        boolean rDateTime = false;
        if (DataType.isIntervalType(r)) {
            rInterval = true;
        } else if (DataType.isNumericType(r)) {
            rNumeric = true;
        } else if (DataType.isDateTimeType(r)) {
            rDateTime = true;
        } else {
            throw this.getUnsupported(l, r);
        }
        switch (this.opType) {
            case PLUS: {
                if (lInterval && rInterval) {
                    if (DataType.isYearMonthIntervalType(l) != DataType.isYearMonthIntervalType(r)) break;
                    return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_PLUS_INTERVAL, this.left, this.right);
                }
                if (lInterval && rDateTime) {
                    if (r == 18 && DataType.isYearMonthIntervalType(l)) break;
                    return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_PLUS_INTERVAL, this.right, this.left);
                }
                if (!lDateTime || !rInterval || l == 18 && DataType.isYearMonthIntervalType(r)) break;
                return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_PLUS_INTERVAL, this.left, this.right);
            }
            case MINUS: {
                if (lInterval && rInterval) {
                    if (DataType.isYearMonthIntervalType(l) != DataType.isYearMonthIntervalType(r)) break;
                    return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_MINUS_INTERVAL, this.left, this.right);
                }
                if (!lDateTime || !rInterval || l == 18 && DataType.isYearMonthIntervalType(r)) break;
                return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_MINUS_INTERVAL, this.left, this.right);
            }
            case MULTIPLY: {
                if (lInterval && rNumeric) {
                    return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_MULTIPLY_NUMERIC, this.left, this.right);
                }
                if (!lNumeric || !rInterval) break;
                return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_MULTIPLY_NUMERIC, this.right, this.left);
            }
            case DIVIDE: {
                if (!lInterval) break;
                if (rNumeric) {
                    return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_DIVIDE_NUMERIC, this.left, this.right);
                }
                if (!rInterval || DataType.isYearMonthIntervalType(l) != DataType.isYearMonthIntervalType(r)) break;
                return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_DIVIDE_INTERVAL, this.left, this.right);
            }
        }
        throw this.getUnsupported(l, r);
    }

    private Expression optimizeDateTime(SessionLocal session, int l, int r) {
        switch (this.opType) {
            case PLUS: {
                if (DataType.isDateTimeType(l)) {
                    if (DataType.isDateTimeType(r)) {
                        if (l > r) {
                            this.swap();
                            int t = l;
                            l = r;
                            r = t;
                        }
                        return new CompatibilityDatePlusTimeOperation(this.right, this.left).optimize(session);
                    }
                    this.swap();
                    int t = l;
                    l = r;
                    r = t;
                }
                switch (l) {
                    case 11: {
                        return new DateTimeFunction(2, 2, this.left, this.right).optimize(session);
                    }
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        return new DateTimeFunction(2, 5, new BinaryOperation(OpType.MULTIPLY, ValueExpression.get(ValueInteger.get(86400)), this.left), this.right).optimize(session);
                    }
                }
                break;
            }
            case MINUS: {
                switch (l) {
                    case 17: 
                    case 20: 
                    case 21: {
                        switch (r) {
                            case 11: {
                                if (this.forcedType != null) {
                                    throw this.getUnexpectedForcedTypeException();
                                }
                                return new DateTimeFunction(2, 2, new UnaryOperation(this.right), this.left).optimize(session);
                            }
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: {
                                if (this.forcedType != null) {
                                    throw this.getUnexpectedForcedTypeException();
                                }
                                return new DateTimeFunction(2, 5, new BinaryOperation(OpType.MULTIPLY, ValueExpression.get(ValueInteger.get(-86400)), this.right), this.left).optimize(session);
                            }
                            case 17: 
                            case 18: 
                            case 19: 
                            case 20: 
                            case 21: {
                                return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_MINUS_DATETIME, this.left, this.right, this.forcedType);
                            }
                        }
                        break;
                    }
                    case 18: 
                    case 19: {
                        if (!DataType.isDateTimeType(r)) break;
                        return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_MINUS_DATETIME, this.left, this.right, this.forcedType);
                    }
                }
                break;
            }
            case MULTIPLY: {
                if (l == 18) {
                    this.type = TypeInfo.TYPE_TIME;
                    this.convertRight = false;
                    return this;
                }
                if (r != 18) break;
                this.swap();
                this.type = TypeInfo.TYPE_TIME;
                this.convertRight = false;
                return this;
            }
            case DIVIDE: {
                if (l != 18) break;
                this.type = TypeInfo.TYPE_TIME;
                this.convertRight = false;
                return this;
            }
        }
        throw this.getUnsupported(l, r);
    }

    private DbException getUnsupported(int l, int r) {
        return DbException.getUnsupportedException(Value.getTypeName(l) + ' ' + this.getOperationToken() + ' ' + Value.getTypeName(r));
    }

    private DbException getUnexpectedForcedTypeException() {
        StringBuilder builder = this.getUnenclosedSQL(new StringBuilder(), 3);
        int index = builder.length();
        return DbException.getSyntaxError(IntervalOperation.getForcedTypeSQL(builder.append(' '), this.forcedType).toString(), index, "");
    }

    private void swap() {
        Expression temp = this.left;
        this.left = this.right;
        this.right = temp;
    }

    public OpType getOperationType() {
        return this.opType;
    }

    public static enum OpType {
        PLUS,
        MINUS,
        MULTIPLY,
        DIVIDE;

    }
}

