/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.ParserUtil;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public final class Alias
extends Expression {
    private final String alias;
    private Expression expr;
    private final boolean aliasColumnName;

    public Alias(Expression expression, String alias, boolean aliasColumnName) {
        this.expr = expression;
        this.alias = alias;
        this.aliasColumnName = aliasColumnName;
    }

    @Override
    public Expression getNonAliasExpression() {
        return this.expr;
    }

    @Override
    public Value getValue(SessionLocal session) {
        return this.expr.getValue(session);
    }

    @Override
    public TypeInfo getType() {
        return this.expr.getType();
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.expr.mapColumns(resolver, level, state);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.expr = this.expr.optimize(session);
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.expr.setEvaluatable(tableFilter, b);
    }

    @Override
    public boolean isIdentity() {
        return this.expr.isIdentity();
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        this.expr.getUnenclosedSQL(builder, sqlFlags).append(" AS ");
        return ParserUtil.quoteIdentifier(builder, this.alias, sqlFlags);
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        this.expr.updateAggregate(session, stage);
    }

    @Override
    public String getAlias(SessionLocal session, int columnIndex) {
        return this.alias;
    }

    @Override
    public String getColumnNameForView(SessionLocal session, int columnIndex) {
        return this.alias;
    }

    @Override
    public int getNullable() {
        return this.expr.getNullable();
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.expr.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.expr.getCost();
    }

    @Override
    public String getSchemaName() {
        if (this.aliasColumnName) {
            return null;
        }
        return this.expr.getSchemaName();
    }

    @Override
    public String getTableName() {
        if (this.aliasColumnName) {
            return null;
        }
        return this.expr.getTableName();
    }

    @Override
    public String getColumnName(SessionLocal session, int columnIndex) {
        if (!(this.expr instanceof ExpressionColumn) || this.aliasColumnName) {
            return this.alias;
        }
        return this.expr.getColumnName(session, columnIndex);
    }
}

