/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;

public final class Setting
extends DbObject {
    private int intValue;
    private String stringValue;

    public Setting(Database database, int id, String settingName) {
        super(database, id, settingName, 10);
    }

    @Override
    public String getSQL(int sqlFlags) {
        return this.getName();
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return builder.append(this.getName());
    }

    public void setIntValue(int value) {
        this.intValue = value;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public void setStringValue(String value) {
        this.stringValue = value;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    @Override
    public String getCreateSQL() {
        StringBuilder buff = new StringBuilder("SET ");
        this.getSQL(buff, 0).append(' ');
        if (this.stringValue != null) {
            buff.append(this.stringValue);
        } else {
            buff.append(this.intValue);
        }
        return buff.toString();
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        this.database.removeMeta(session, this.getId());
        this.invalidate();
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("RENAME");
    }
}

