/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.io.IOException;
import java.net.Socket;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.api.DatabaseEventListener;
import org.h2.api.JavaObjectSerializer;
import org.h2.command.CommandInterface;
import org.h2.command.CommandRemote;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Engine;
import org.h2.engine.IsolationLevel;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcException;
import org.h2.jdbc.meta.DatabaseMeta;
import org.h2.jdbc.meta.DatabaseMetaLegacy;
import org.h2.jdbc.meta.DatabaseMetaRemote;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.result.ResultInterface;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.LobStorageFrontend;
import org.h2.store.fs.FileUtils;
import org.h2.util.DateTimeUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.NetworkConnectionInfo;
import org.h2.util.SmallLRUCache;
import org.h2.util.StringUtils;
import org.h2.util.TempFileDeleter;
import org.h2.util.TimeZoneProvider;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Transfer;
import org.h2.value.Value;
import org.h2.value.ValueInteger;
import org.h2.value.ValueLob;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueVarchar;

public final class SessionRemote
extends Session
implements DataHandler {
    public static final int SESSION_PREPARE = 0;
    public static final int SESSION_CLOSE = 1;
    public static final int COMMAND_EXECUTE_QUERY = 2;
    public static final int COMMAND_EXECUTE_UPDATE = 3;
    public static final int COMMAND_CLOSE = 4;
    public static final int RESULT_FETCH_ROWS = 5;
    public static final int RESULT_RESET = 6;
    public static final int RESULT_CLOSE = 7;
    public static final int COMMAND_COMMIT = 8;
    public static final int CHANGE_ID = 9;
    public static final int COMMAND_GET_META_DATA = 10;
    public static final int SESSION_SET_ID = 12;
    public static final int SESSION_CANCEL_STATEMENT = 13;
    public static final int SESSION_CHECK_KEY = 14;
    public static final int SESSION_SET_AUTOCOMMIT = 15;
    public static final int SESSION_HAS_PENDING_TRANSACTION = 16;
    public static final int LOB_READ = 17;
    public static final int SESSION_PREPARE_READ_PARAMS2 = 18;
    public static final int GET_JDBC_META = 19;
    public static final int STATUS_ERROR = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_CLOSED = 2;
    public static final int STATUS_OK_STATE_CHANGED = 3;
    private TraceSystem traceSystem;
    private Trace trace;
    private ArrayList<Transfer> transferList = Utils.newSmallArrayList();
    private int nextId;
    private boolean autoCommit = true;
    private ConnectionInfo connectionInfo;
    private String databaseName;
    private String cipher;
    private byte[] fileEncryptionKey;
    private final Object lobSyncObject = new Object();
    private String sessionId;
    private int clientVersion;
    private boolean autoReconnect;
    private int lastReconnect;
    private Session embedded;
    private DatabaseEventListener eventListener;
    private LobStorageFrontend lobStorage;
    private boolean cluster;
    private TempFileDeleter tempFileDeleter;
    private JavaObjectSerializer javaObjectSerializer;
    private final CompareMode compareMode = CompareMode.getInstance(null, 0);
    private final boolean oldInformationSchema;
    private String currentSchemaName;
    private volatile Session.DynamicSettings dynamicSettings;

    public SessionRemote(ConnectionInfo ci) {
        this.connectionInfo = ci;
        this.oldInformationSchema = ci.getProperty("OLD_INFORMATION_SCHEMA", false);
    }

    @Override
    public ArrayList<String> getClusterServers() {
        ArrayList<String> serverList = new ArrayList<String>();
        for (Transfer transfer : this.transferList) {
            serverList.add(transfer.getSocket().getInetAddress().getHostAddress() + ":" + transfer.getSocket().getPort());
        }
        return serverList;
    }

    private Transfer initTransfer(ConnectionInfo ci, String db, String server) throws IOException {
        Socket socket = NetUtils.createSocket(server, 9092, ci.isSSL(), ci.getProperty("NETWORK_TIMEOUT", 0));
        Transfer trans = new Transfer(this, socket);
        trans.setSSL(ci.isSSL());
        trans.init();
        trans.writeInt(17);
        trans.writeInt(20);
        trans.writeString(db);
        trans.writeString(ci.getOriginalURL());
        trans.writeString(ci.getUserName());
        trans.writeBytes(ci.getUserPasswordHash());
        trans.writeBytes(ci.getFilePasswordHash());
        String[] keys = ci.getKeys();
        trans.writeInt(keys.length);
        for (String key : keys) {
            trans.writeString(key).writeString(ci.getProperty(key));
        }
        try {
            this.done(trans);
            this.clientVersion = trans.readInt();
            trans.setVersion(this.clientVersion);
            if (ci.getFileEncryptionKey() != null) {
                trans.writeBytes(ci.getFileEncryptionKey());
            }
            trans.writeInt(12);
            trans.writeString(this.sessionId);
            if (this.clientVersion >= 20) {
                TimeZoneProvider timeZone = ci.getTimeZone();
                if (timeZone == null) {
                    timeZone = DateTimeUtils.getTimeZone();
                }
                trans.writeString(timeZone.getId());
            }
            this.done(trans);
            this.autoCommit = trans.readBoolean();
            return trans;
        }
        catch (DbException e) {
            trans.close();
            throw e;
        }
    }

    @Override
    public boolean hasPendingTransaction() {
        int count = 0;
        for (int i = 0; i < this.transferList.size(); ++i) {
            Transfer transfer = this.transferList.get(i);
            try {
                this.traceOperation("SESSION_HAS_PENDING_TRANSACTION", 0);
                transfer.writeInt(16);
                this.done(transfer);
                return transfer.readInt() != 0;
            }
            catch (IOException e) {
                this.removeServer(e, i--, ++count);
                continue;
            }
        }
        return true;
    }

    @Override
    public void cancel() {
    }

    public void cancelStatement(int id) {
        for (Transfer transfer : this.transferList) {
            try {
                Transfer trans = transfer.openNewConnection();
                trans.init();
                trans.writeInt(this.clientVersion);
                trans.writeInt(this.clientVersion);
                trans.writeString(null);
                trans.writeString(null);
                trans.writeString(this.sessionId);
                trans.writeInt(13);
                trans.writeInt(id);
                trans.close();
            }
            catch (IOException e) {
                this.trace.debug(e, "could not cancel statement");
            }
        }
    }

    private void checkClusterDisableAutoCommit(String serverList) {
        if (this.autoCommit && this.transferList.size() > 1) {
            this.setAutoCommitSend(false);
            CommandInterface c = this.prepareCommand("SET CLUSTER " + serverList, Integer.MAX_VALUE);
            c.executeUpdate(null);
            this.autoCommit = true;
            this.cluster = true;
        }
    }

    public int getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        if (!this.cluster) {
            this.setAutoCommitSend(autoCommit);
        }
        this.autoCommit = autoCommit;
    }

    public void setAutoCommitFromServer(boolean autoCommit) {
        if (this.cluster) {
            if (autoCommit) {
                this.setAutoCommitSend(false);
                this.autoCommit = true;
            }
        } else {
            this.autoCommit = autoCommit;
        }
    }

    private synchronized void setAutoCommitSend(boolean autoCommit) {
        int count = 0;
        for (int i = 0; i < this.transferList.size(); ++i) {
            Transfer transfer = this.transferList.get(i);
            try {
                this.traceOperation("SESSION_SET_AUTOCOMMIT", autoCommit ? 1 : 0);
                transfer.writeInt(15).writeBoolean(autoCommit);
                this.done(transfer);
                continue;
            }
            catch (IOException e) {
                this.removeServer(e, i--, ++count);
            }
        }
    }

    public void autoCommitIfCluster() {
        if (this.autoCommit && this.cluster) {
            int count = 0;
            for (int i = 0; i < this.transferList.size(); ++i) {
                Transfer transfer = this.transferList.get(i);
                try {
                    this.traceOperation("COMMAND_COMMIT", 0);
                    transfer.writeInt(8);
                    this.done(transfer);
                    continue;
                }
                catch (IOException e) {
                    this.removeServer(e, i--, ++count);
                }
            }
        }
    }

    private String getFilePrefix(String dir) {
        StringBuilder buff = new StringBuilder(dir);
        buff.append('/');
        for (int i = 0; i < this.databaseName.length(); ++i) {
            char ch = this.databaseName.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                buff.append(ch);
                continue;
            }
            buff.append('_');
        }
        return buff.toString();
    }

    public Session connectEmbeddedOrServer(boolean openNew) {
        ConnectionInfo ci = this.connectionInfo;
        if (ci.isRemote()) {
            this.connectServer(ci);
            return this;
        }
        boolean autoServerMode = ci.getProperty("AUTO_SERVER", false);
        ConnectionInfo backup = null;
        try {
            if (autoServerMode) {
                backup = ci.clone();
                this.connectionInfo = ci.clone();
            }
            if (openNew) {
                ci.setProperty("OPEN_NEW", "true");
            }
            return Engine.createSession(ci);
        }
        catch (Exception re) {
            String serverKey;
            DbException e = DbException.convert(re);
            if (e.getErrorCode() == 90020 && autoServerMode && (serverKey = ((JdbcException)((Object)e.getSQLException())).getSQL()) != null) {
                backup.setServerKey(serverKey);
                backup.removeProperty("OPEN_NEW", null);
                this.connectServer(backup);
                return this;
            }
            throw e;
        }
    }

    private void connectServer(ConnectionInfo ci) {
        String className;
        String traceLevelSystemOut;
        int idx;
        String name = ci.getName();
        if (name.startsWith("//")) {
            name = name.substring("//".length());
        }
        if ((idx = name.indexOf(47)) < 0) {
            throw ci.getFormatException();
        }
        this.databaseName = name.substring(idx + 1);
        String server = name.substring(0, idx);
        this.traceSystem = new TraceSystem(null);
        String traceLevelFile = ci.getProperty(9, null);
        if (traceLevelFile != null) {
            int level = Integer.parseInt(traceLevelFile);
            String prefix = this.getFilePrefix(SysProperties.CLIENT_TRACE_DIRECTORY);
            try {
                this.traceSystem.setLevelFile(level);
                if (level > 0 && level < 4) {
                    String file = FileUtils.createTempFile(prefix, ".trace.db", false);
                    this.traceSystem.setFileName(file);
                }
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, prefix);
            }
        }
        if ((traceLevelSystemOut = ci.getProperty(8, null)) != null) {
            int level = Integer.parseInt(traceLevelSystemOut);
            this.traceSystem.setLevelSystemOut(level);
        }
        this.trace = this.traceSystem.getTrace(6);
        String serverList = null;
        if (server.indexOf(44) >= 0) {
            serverList = StringUtils.quoteStringSQL(server);
            ci.setProperty("CLUSTER", "TRUE");
        }
        this.autoReconnect = ci.getProperty("AUTO_RECONNECT", false);
        boolean autoServer = ci.getProperty("AUTO_SERVER", false);
        if (autoServer && serverList != null) {
            throw DbException.getUnsupportedException("autoServer && serverList != null");
        }
        this.autoReconnect |= autoServer;
        if (this.autoReconnect && (className = ci.getProperty("DATABASE_EVENT_LISTENER")) != null) {
            className = StringUtils.trim(className, true, true, "'");
            try {
                this.eventListener = (DatabaseEventListener)JdbcUtils.loadUserClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                throw DbException.convert(e);
            }
        }
        this.cipher = ci.getProperty("CIPHER");
        if (this.cipher != null) {
            this.fileEncryptionKey = MathUtils.secureRandomBytes(32);
        }
        String[] servers = StringUtils.arraySplit(server, ',', true);
        int len = servers.length;
        this.transferList.clear();
        this.sessionId = StringUtils.convertBytesToHex(MathUtils.secureRandomBytes(32));
        boolean switchOffCluster = false;
        try {
            for (String s : servers) {
                try {
                    Transfer trans = this.initTransfer(ci, this.databaseName, s);
                    this.transferList.add(trans);
                }
                catch (IOException e) {
                    if (len == 1) {
                        throw DbException.get(90067, e, e + ": " + s);
                    }
                    switchOffCluster = true;
                }
            }
            this.checkClosed();
            if (switchOffCluster) {
                this.switchOffCluster();
            }
            this.checkClusterDisableAutoCommit(serverList);
        }
        catch (DbException e) {
            this.traceSystem.close();
            throw e;
        }
        this.getDynamicSettings();
    }

    private void switchOffCluster() {
        CommandInterface ci = this.prepareCommand("SET CLUSTER ''", Integer.MAX_VALUE);
        ci.executeUpdate(null);
    }

    public void removeServer(IOException e, int i, int count) {
        this.trace.debug(e, "removing server because of exception");
        this.transferList.remove(i);
        if (this.transferList.isEmpty() && this.autoReconnect(count)) {
            return;
        }
        this.checkClosed();
        this.switchOffCluster();
    }

    @Override
    public synchronized CommandInterface prepareCommand(String sql, int fetchSize) {
        this.checkClosed();
        return new CommandRemote(this, this.transferList, sql, fetchSize);
    }

    private boolean autoReconnect(int count) {
        if (!this.isClosed()) {
            return false;
        }
        if (!this.autoReconnect) {
            return false;
        }
        if (!this.cluster && !this.autoCommit) {
            return false;
        }
        if (count > SysProperties.MAX_RECONNECT) {
            return false;
        }
        ++this.lastReconnect;
        while (true) {
            try {
                this.embedded = this.connectEmbeddedOrServer(false);
            }
            catch (DbException e) {
                if (e.getErrorCode() != 90135) {
                    throw e;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
                continue;
            }
            break;
        }
        if (this.embedded == this) {
            this.embedded = null;
        } else {
            this.connectEmbeddedOrServer(true);
        }
        this.recreateSessionState();
        if (this.eventListener != null) {
            this.eventListener.setProgress(4, this.databaseName, count, SysProperties.MAX_RECONNECT);
        }
        return true;
    }

    public void checkClosed() {
        if (this.isClosed()) {
            throw DbException.get(90067, "session closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        RuntimeException closeError = null;
        if (this.transferList != null) {
            SessionRemote sessionRemote = this;
            synchronized (sessionRemote) {
                for (Transfer transfer : this.transferList) {
                    try {
                        this.traceOperation("SESSION_CLOSE", 0);
                        transfer.writeInt(1);
                        this.done(transfer);
                        transfer.close();
                    }
                    catch (RuntimeException e) {
                        this.trace.error(e, "close");
                        closeError = e;
                    }
                    catch (Exception e) {
                        this.trace.error(e, "close");
                    }
                }
            }
            this.transferList = null;
        }
        this.traceSystem.close();
        if (this.embedded != null) {
            this.embedded.close();
            this.embedded = null;
        }
        if (closeError != null) {
            throw closeError;
        }
    }

    @Override
    public Trace getTrace() {
        return this.traceSystem.getTrace(6);
    }

    public int getNextId() {
        return this.nextId++;
    }

    public int getCurrentId() {
        return this.nextId;
    }

    public void done(Transfer transfer) throws IOException {
        transfer.flush();
        int status = transfer.readInt();
        switch (status) {
            case 0: {
                throw SessionRemote.readException(transfer);
            }
            case 1: {
                break;
            }
            case 2: {
                this.transferList = null;
                break;
            }
            case 3: {
                this.sessionStateChanged = true;
                this.currentSchemaName = null;
                this.dynamicSettings = null;
                break;
            }
            default: {
                throw DbException.get(90067, "unexpected status " + status);
            }
        }
    }

    public static DbException readException(Transfer transfer) throws IOException {
        String sqlstate = transfer.readString();
        String message = transfer.readString();
        String sql = transfer.readString();
        int errorCode = transfer.readInt();
        String stackTrace = transfer.readString();
        SQLException s = DbException.getJdbcSQLException(message, sql, sqlstate, errorCode, null, stackTrace);
        if (errorCode == 90067) {
            throw new IOException(s.toString(), s);
        }
        return DbException.convert(s);
    }

    public boolean isClustered() {
        return this.cluster;
    }

    @Override
    public boolean isClosed() {
        return this.transferList == null || this.transferList.isEmpty();
    }

    public void traceOperation(String operation, int id) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} {1}", operation, id);
        }
    }

    @Override
    public void checkPowerOff() {
    }

    @Override
    public void checkWritingAllowed() {
    }

    @Override
    public String getDatabasePath() {
        return "";
    }

    @Override
    public int getMaxLengthInplaceLob() {
        return SysProperties.LOB_CLIENT_MAX_SIZE_MEMORY;
    }

    @Override
    public FileStore openFile(String name, String mode, boolean mustExist) {
        if (mustExist && !FileUtils.exists(name)) {
            throw DbException.get(90124, name);
        }
        FileStore store = this.cipher == null ? FileStore.open(this, name, mode) : FileStore.open(this, name, mode, this.cipher, this.fileEncryptionKey, 0);
        store.setCheckedWriting(false);
        try {
            store.init();
        }
        catch (DbException e) {
            store.closeSilently();
            throw e;
        }
        return store;
    }

    @Override
    public DataHandler getDataHandler() {
        return this;
    }

    @Override
    public Object getLobSyncObject() {
        return this.lobSyncObject;
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        return null;
    }

    public int getLastReconnect() {
        return this.lastReconnect;
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        if (this.tempFileDeleter == null) {
            this.tempFileDeleter = TempFileDeleter.getInstance();
        }
        return this.tempFileDeleter;
    }

    @Override
    public LobStorageFrontend getLobStorage() {
        if (this.lobStorage == null) {
            this.lobStorage = new LobStorageFrontend(this);
        }
        return this.lobStorage;
    }

    @Override
    public synchronized int readLob(long lobId, byte[] hmac, long offset, byte[] buff, int off, int length) {
        this.checkClosed();
        int count = 0;
        for (int i = 0; i < this.transferList.size(); ++i) {
            Transfer transfer = this.transferList.get(i);
            try {
                this.traceOperation("LOB_READ", (int)lobId);
                transfer.writeInt(17);
                transfer.writeLong(lobId);
                transfer.writeBytes(hmac);
                transfer.writeLong(offset);
                transfer.writeInt(length);
                this.done(transfer);
                length = transfer.readInt();
                if (length <= 0) {
                    return length;
                }
                transfer.readBytes(buff, off, length);
                return length;
            }
            catch (IOException e) {
                this.removeServer(e, i--, ++count);
                continue;
            }
        }
        return 1;
    }

    @Override
    public JavaObjectSerializer getJavaObjectSerializer() {
        if (this.dynamicSettings == null) {
            this.getDynamicSettings();
        }
        return this.javaObjectSerializer;
    }

    @Override
    public ValueLob addTemporaryLob(ValueLob v) {
        return v;
    }

    @Override
    public CompareMode getCompareMode() {
        return this.compareMode;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentSchemaName() {
        String schema = this.currentSchemaName;
        if (schema == null) {
            SessionRemote sessionRemote = this;
            synchronized (sessionRemote) {
                try (CommandInterface command = this.prepareCommand("CALL SCHEMA()", 1);
                     ResultInterface result = command.executeQuery(1L, false);){
                    result.next();
                    this.currentSchemaName = schema = result.currentRow()[0].getString();
                }
            }
        }
        return schema;
    }

    @Override
    public synchronized void setCurrentSchemaName(String schema) {
        this.currentSchemaName = null;
        try (CommandInterface command = this.prepareCommand(StringUtils.quoteIdentifier(new StringBuilder("SET SCHEMA "), schema).toString(), 0);){
            command.executeUpdate(null);
            this.currentSchemaName = schema;
        }
    }

    @Override
    public void setNetworkConnectionInfo(NetworkConnectionInfo networkConnectionInfo) {
    }

    /*
     * Exception decompiling
     */
    @Override
    public IsolationLevel getIsolationLevel() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setIsolationLevel(IsolationLevel isolationLevel) {
        if (this.clientVersion >= 19) {
            try (CommandInterface command = this.prepareCommand("SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + isolationLevel.getSQL(), 0);){
                command.executeUpdate(null);
            }
        }
        try (CommandInterface command = this.prepareCommand("SET LOCK_MODE ?", 0);){
            command.getParameters().get(0).setValue(ValueInteger.get(isolationLevel.getLockMode()), false);
            command.executeUpdate(null);
        }
    }

    @Override
    public Session.StaticSettings getStaticSettings() {
        Session.StaticSettings settings = this.staticSettings;
        if (settings == null) {
            boolean databaseToUpper = true;
            boolean databaseToLower = false;
            boolean caseInsensitiveIdentifiers = false;
            try (CommandInterface command = this.getSettingsCommand(" IN (?, ?, ?)");){
                ArrayList<? extends ParameterInterface> parameters = command.getParameters();
                parameters.get(0).setValue(ValueVarchar.get("DATABASE_TO_UPPER"), false);
                parameters.get(1).setValue(ValueVarchar.get("DATABASE_TO_LOWER"), false);
                parameters.get(2).setValue(ValueVarchar.get("CASE_INSENSITIVE_IDENTIFIERS"), false);
                try (ResultInterface result = command.executeQuery(0L, false);){
                    while (result.next()) {
                        Value[] row = result.currentRow();
                        String value = row[1].getString();
                        switch (row[0].getString()) {
                            case "DATABASE_TO_UPPER": {
                                databaseToUpper = Boolean.valueOf(value);
                                break;
                            }
                            case "DATABASE_TO_LOWER": {
                                databaseToLower = Boolean.valueOf(value);
                                break;
                            }
                            case "CASE_INSENSITIVE_IDENTIFIERS": {
                                caseInsensitiveIdentifiers = Boolean.valueOf(value);
                            }
                        }
                    }
                }
            }
            if (this.clientVersion < 18) {
                caseInsensitiveIdentifiers = !databaseToUpper;
            }
            this.staticSettings = settings = new Session.StaticSettings(databaseToUpper, databaseToLower, caseInsensitiveIdentifiers);
        }
        return settings;
    }

    @Override
    public Session.DynamicSettings getDynamicSettings() {
        Session.DynamicSettings settings = this.dynamicSettings;
        if (settings == null) {
            String modeName = Mode.ModeEnum.REGULAR.name();
            TimeZoneProvider timeZone = DateTimeUtils.getTimeZone();
            String javaObjectSerializerName = null;
            try (CommandInterface command = this.getSettingsCommand(" IN (?, ?, ?)");){
                ArrayList<? extends ParameterInterface> parameters = command.getParameters();
                parameters.get(0).setValue(ValueVarchar.get("MODE"), false);
                parameters.get(1).setValue(ValueVarchar.get("TIME ZONE"), false);
                parameters.get(2).setValue(ValueVarchar.get("JAVA_OBJECT_SERIALIZER"), false);
                try (ResultInterface result = command.executeQuery(0L, false);){
                    while (result.next()) {
                        Value[] row = result.currentRow();
                        String value = row[1].getString();
                        switch (row[0].getString()) {
                            case "MODE": {
                                modeName = value;
                                break;
                            }
                            case "TIME ZONE": {
                                timeZone = TimeZoneProvider.ofId(value);
                                break;
                            }
                            case "JAVA_OBJECT_SERIALIZER": {
                                javaObjectSerializerName = value;
                            }
                        }
                    }
                }
            }
            Mode mode = Mode.getInstance(modeName);
            if (mode == null) {
                mode = Mode.getRegular();
            }
            this.dynamicSettings = settings = new Session.DynamicSettings(mode, timeZone);
            if (javaObjectSerializerName != null && !(javaObjectSerializerName = javaObjectSerializerName.trim()).isEmpty() && !javaObjectSerializerName.equals("null")) {
                try {
                    this.javaObjectSerializer = (JavaObjectSerializer)JdbcUtils.loadUserClass(javaObjectSerializerName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw DbException.convert(e);
                }
            } else {
                this.javaObjectSerializer = null;
            }
        }
        return settings;
    }

    private CommandInterface getSettingsCommand(String args) {
        return this.prepareCommand((!this.isOldInformationSchema() ? "SELECT SETTING_NAME, SETTING_VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE SETTING_NAME" : "SELECT NAME, `VALUE` FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME") + args, Integer.MAX_VALUE);
    }

    @Override
    public ValueTimestampTimeZone currentTimestamp() {
        return DateTimeUtils.currentTimestamp(this.getDynamicSettings().timeZone);
    }

    @Override
    public TimeZoneProvider currentTimeZone() {
        return this.getDynamicSettings().timeZone;
    }

    @Override
    public Mode getMode() {
        return this.getDynamicSettings().mode;
    }

    @Override
    public DatabaseMeta getDatabaseMeta() {
        return this.clientVersion >= 20 ? new DatabaseMetaRemote(this, this.transferList) : new DatabaseMetaLegacy(this);
    }

    @Override
    public boolean isOldInformationSchema() {
        return this.oldInformationSchema || this.clientVersion < 20;
    }

    @Override
    public boolean zeroBasedEnums() {
        return false;
    }
}

