/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.h2.command.dml.SetTypes;
import org.h2.engine.DbSettings;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.security.SHA256;
import org.h2.store.fs.FileUtils;
import org.h2.store.fs.encrypt.FilePathEncrypt;
import org.h2.store.fs.rec.FilePathRec;
import org.h2.util.IOUtils;
import org.h2.util.NetworkConnectionInfo;
import org.h2.util.SortedProperties;
import org.h2.util.StringUtils;
import org.h2.util.TimeZoneProvider;
import org.h2.util.Utils;

public class ConnectionInfo
implements Cloneable {
    private static final HashSet<String> KNOWN_SETTINGS;
    private static final HashSet<String> IGNORED_BY_PARSER;
    private Properties prop = new Properties();
    private String originalURL;
    private String url;
    private String user;
    private byte[] filePasswordHash;
    private byte[] fileEncryptionKey;
    private byte[] userPasswordHash;
    private TimeZoneProvider timeZone;
    private String name;
    private String nameNormalized;
    private boolean remote;
    private boolean ssl;
    private boolean persistent;
    private boolean unnamed;
    private NetworkConnectionInfo networkConnectionInfo;

    public ConnectionInfo(String name) {
        this.name = name;
        this.url = "jdbc:h2:" + name;
        this.parseName();
    }

    public ConnectionInfo(String u, Properties info, String user, Object password) {
        this.originalURL = this.url = (u = ConnectionInfo.remapURL(u));
        if (!u.startsWith("jdbc:h2:")) {
            throw this.getFormatException();
        }
        if (info != null) {
            this.readProperties(info);
        }
        if (user != null) {
            this.prop.put("USER", user);
        }
        if (password != null) {
            this.prop.put("PASSWORD", password);
        }
        this.readSettingsFromURL();
        Object timeZoneName = this.prop.remove("TIME ZONE");
        if (timeZoneName != null) {
            this.timeZone = TimeZoneProvider.ofId(timeZoneName.toString());
        }
        this.setUserName(this.removeProperty("USER", ""));
        this.name = this.url.substring("jdbc:h2:".length());
        this.parseName();
        this.convertPasswords();
        String recoverTest = this.removeProperty("RECOVER_TEST", null);
        if (recoverTest != null) {
            FilePathRec.register();
            try {
                Utils.callStaticMethod("org.h2.store.RecoverTester.init", recoverTest);
            }
            catch (Exception e) {
                throw DbException.convert(e);
            }
            this.name = "rec:" + this.name;
        }
    }

    private static boolean isKnownSetting(String s) {
        return KNOWN_SETTINGS.contains(s);
    }

    public static boolean isIgnoredByParser(String name) {
        return IGNORED_BY_PARSER.contains(name);
    }

    public ConnectionInfo clone() throws CloneNotSupportedException {
        ConnectionInfo clone = (ConnectionInfo)super.clone();
        clone.prop = (Properties)this.prop.clone();
        clone.filePasswordHash = Utils.cloneByteArray(this.filePasswordHash);
        clone.fileEncryptionKey = Utils.cloneByteArray(this.fileEncryptionKey);
        clone.userPasswordHash = Utils.cloneByteArray(this.userPasswordHash);
        return clone;
    }

    private void parseName() {
        if (".".equals(this.name)) {
            this.name = "mem:";
        }
        if (this.name.startsWith("tcp:")) {
            this.remote = true;
            this.name = this.name.substring("tcp:".length());
        } else if (this.name.startsWith("ssl:")) {
            this.remote = true;
            this.ssl = true;
            this.name = this.name.substring("ssl:".length());
        } else if (this.name.startsWith("mem:")) {
            this.persistent = false;
            if ("mem:".equals(this.name)) {
                this.unnamed = true;
            }
        } else if (this.name.startsWith("file:")) {
            this.name = this.name.substring("file:".length());
            this.persistent = true;
        } else {
            this.persistent = true;
        }
        if (this.persistent && !this.remote) {
            this.name = IOUtils.nameSeparatorsToNative(this.name);
        }
    }

    public void setBaseDir(String dir) {
        if (this.persistent) {
            String n;
            String absDir = FileUtils.unwrap(FileUtils.toRealPath(dir));
            boolean absolute = FileUtils.isAbsolute(this.name);
            String prefix = null;
            if (dir.endsWith(File.separator)) {
                dir = dir.substring(0, dir.length() - 1);
            }
            if (absolute) {
                n = this.name;
            } else {
                n = FileUtils.unwrap(this.name);
                prefix = this.name.substring(0, this.name.length() - n.length());
                n = dir + File.separatorChar + n;
            }
            String normalizedName = FileUtils.unwrap(FileUtils.toRealPath(n));
            if (normalizedName.equals(absDir) || !normalizedName.startsWith(absDir)) {
                throw DbException.get(90028, normalizedName + " outside " + absDir);
            }
            if (!absDir.endsWith("/") && !absDir.endsWith("\\") && normalizedName.charAt(absDir.length()) != '/') {
                throw DbException.get(90028, normalizedName + " outside " + absDir);
            }
            if (!absolute) {
                this.name = prefix + dir + File.separatorChar + FileUtils.unwrap(this.name);
            }
        }
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    boolean isUnnamedInMemory() {
        return this.unnamed;
    }

    private void readProperties(Properties info) {
        Object[] list = info.keySet().toArray();
        DbSettings s = null;
        for (Object k : list) {
            String key = StringUtils.toUpperEnglish(k.toString());
            if (this.prop.containsKey(key)) {
                throw DbException.get(90066, key);
            }
            Object value = info.get(k);
            if (ConnectionInfo.isKnownSetting(key)) {
                this.prop.put(key, value);
                continue;
            }
            if (s == null) {
                s = this.getDbSettings();
            }
            if (!s.containsKey(key)) continue;
            this.prop.put(key, value);
        }
    }

    private void readSettingsFromURL() {
        DbSettings defaultSettings = DbSettings.DEFAULT;
        int idx = this.url.indexOf(59);
        if (idx >= 0) {
            String[] list;
            String settings = this.url.substring(idx + 1);
            this.url = this.url.substring(0, idx);
            String unknownSetting = null;
            for (String setting : list = StringUtils.arraySplit(settings, ';', false)) {
                if (setting.isEmpty()) continue;
                int equal = setting.indexOf(61);
                if (equal < 0) {
                    throw this.getFormatException();
                }
                String value = setting.substring(equal + 1);
                String key = setting.substring(0, equal);
                if (ConnectionInfo.isKnownSetting(key = StringUtils.toUpperEnglish(key)) || defaultSettings.containsKey(key)) {
                    String old = this.prop.getProperty(key);
                    if (old != null && !old.equals(value)) {
                        throw DbException.get(90066, key);
                    }
                    this.prop.setProperty(key, value);
                    continue;
                }
                unknownSetting = key;
            }
            if (unknownSetting != null && !Utils.parseBoolean(this.prop.getProperty("IGNORE_UNKNOWN_SETTINGS"), false, false)) {
                throw DbException.get(90113, unknownSetting);
            }
        }
    }

    private void preservePasswordForAuthentication(Object password) {
        if ((!this.isRemote() || this.isSSL()) && this.prop.containsKey("AUTHREALM") && password != null) {
            this.prop.put("AUTHZPWD", password instanceof char[] ? new String((char[])password) : password);
        }
    }

    private char[] removePassword() {
        Object p = this.prop.remove("PASSWORD");
        this.preservePasswordForAuthentication(p);
        if (p == null) {
            return new char[0];
        }
        if (p instanceof char[]) {
            return (char[])p;
        }
        return p.toString().toCharArray();
    }

    private void convertPasswords() {
        char[] password = this.removePassword();
        boolean passwordHash = this.removeProperty("PASSWORD_HASH", false);
        if (this.getProperty("CIPHER", null) != null) {
            int space = -1;
            int len = password.length;
            for (int i = 0; i < len; ++i) {
                if (password[i] != ' ') continue;
                space = i;
                break;
            }
            if (space < 0) {
                throw DbException.get(90050);
            }
            char[] np = Arrays.copyOfRange(password, space + 1, password.length);
            char[] filePassword = Arrays.copyOf(password, space);
            Arrays.fill(password, '\u0000');
            password = np;
            this.fileEncryptionKey = FilePathEncrypt.getPasswordBytes(filePassword);
            this.filePasswordHash = ConnectionInfo.hashPassword(passwordHash, "file", filePassword);
        }
        this.userPasswordHash = ConnectionInfo.hashPassword(passwordHash, this.user, password);
    }

    private static byte[] hashPassword(boolean passwordHash, String userName, char[] password) {
        if (passwordHash) {
            return StringUtils.convertHexToBytes(new String(password));
        }
        if (userName.isEmpty() && password.length == 0) {
            return new byte[0];
        }
        return SHA256.getKeyPasswordHash(userName, password);
    }

    public boolean getProperty(String key, boolean defaultValue) {
        return Utils.parseBoolean(this.getProperty(key, null), defaultValue, false);
    }

    public boolean removeProperty(String key, boolean defaultValue) {
        return Utils.parseBoolean(this.removeProperty(key, null), defaultValue, false);
    }

    String removeProperty(String key, String defaultValue) {
        if (SysProperties.CHECK && !ConnectionInfo.isKnownSetting(key)) {
            throw DbException.getInternalError(key);
        }
        Object x = this.prop.remove(key);
        return x == null ? defaultValue : x.toString();
    }

    public String getName() {
        if (!this.persistent) {
            return this.name;
        }
        if (this.nameNormalized == null) {
            if (!(FileUtils.isAbsolute(this.name) || this.name.contains("./") || this.name.contains(".\\") || this.name.contains(":/") || this.name.contains(":\\"))) {
                throw DbException.get(90011, this.originalURL);
            }
            String suffix = ".mv.db";
            String n = FileUtils.toRealPath(this.name + suffix);
            String fileName = FileUtils.getName(n);
            if (fileName.length() < suffix.length() + 1) {
                throw DbException.get(90138, this.name);
            }
            this.nameNormalized = n.substring(0, n.length() - suffix.length());
        }
        return this.nameNormalized;
    }

    public byte[] getFilePasswordHash() {
        return this.filePasswordHash;
    }

    byte[] getFileEncryptionKey() {
        return this.fileEncryptionKey;
    }

    public String getUserName() {
        return this.user;
    }

    byte[] getUserPasswordHash() {
        return this.userPasswordHash;
    }

    String[] getKeys() {
        return this.prop.keySet().toArray(new String[this.prop.size()]);
    }

    String getProperty(String key) {
        Object value = this.prop.get(key);
        if (!(value instanceof String)) {
            return null;
        }
        return value.toString();
    }

    int getProperty(String key, int defaultValue) {
        if (SysProperties.CHECK && !ConnectionInfo.isKnownSetting(key)) {
            throw DbException.getInternalError(key);
        }
        String s = this.getProperty(key);
        return s == null ? defaultValue : Integer.parseInt(s);
    }

    public String getProperty(String key, String defaultValue) {
        if (SysProperties.CHECK && !ConnectionInfo.isKnownSetting(key)) {
            throw DbException.getInternalError(key);
        }
        String s = this.getProperty(key);
        return s == null ? defaultValue : s;
    }

    String getProperty(int setting, String defaultValue) {
        String key = SetTypes.getTypeName(setting);
        String s = this.getProperty(key);
        return s == null ? defaultValue : s;
    }

    int getIntProperty(int setting, int defaultValue) {
        String key = SetTypes.getTypeName(setting);
        String s = this.getProperty(key, null);
        try {
            return s == null ? defaultValue : Integer.decode(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    boolean isSSL() {
        return this.ssl;
    }

    public void setUserName(String name) {
        this.user = StringUtils.toUpperEnglish(name);
    }

    public void setUserPasswordHash(byte[] hash) {
        this.userPasswordHash = hash;
    }

    public void setFilePasswordHash(byte[] hash) {
        this.filePasswordHash = hash;
    }

    public void setFileEncryptionKey(byte[] key) {
        this.fileEncryptionKey = key;
    }

    public void setProperty(String key, String value) {
        if (value != null) {
            this.prop.setProperty(key, value);
        }
    }

    public String getURL() {
        return this.url;
    }

    public String getOriginalURL() {
        return this.originalURL;
    }

    public void setOriginalURL(String url) {
        this.originalURL = url;
    }

    public TimeZoneProvider getTimeZone() {
        return this.timeZone;
    }

    DbException getFormatException() {
        return DbException.get(90046, "jdbc:h2:{ {.|mem:}[name] | [file:]fileName | {tcp|ssl}:[//]server[:port][,server2[:port]]/name }[;key=value...]", this.url);
    }

    public void setServerKey(String serverKey) {
        this.remote = true;
        this.persistent = false;
        this.name = serverKey;
    }

    public NetworkConnectionInfo getNetworkConnectionInfo() {
        return this.networkConnectionInfo;
    }

    public void setNetworkConnectionInfo(NetworkConnectionInfo networkConnectionInfo) {
        this.networkConnectionInfo = networkConnectionInfo;
    }

    public DbSettings getDbSettings() {
        DbSettings defaultSettings = DbSettings.DEFAULT;
        HashMap<String, String> s = new HashMap<String, String>(64);
        for (Object k : this.prop.keySet()) {
            String key = k.toString();
            if (ConnectionInfo.isKnownSetting(key) || !defaultSettings.containsKey(key)) continue;
            s.put(key, this.prop.getProperty(key));
        }
        return DbSettings.getInstance(s);
    }

    private static String remapURL(String url) {
        String urlMap = SysProperties.URL_MAP;
        if (urlMap != null && !urlMap.isEmpty()) {
            try {
                SortedProperties prop = SortedProperties.loadProperties(urlMap);
                String url2 = prop.getProperty(url);
                if (url2 == null) {
                    prop.put(url, "");
                    prop.store(urlMap);
                } else if (!(url2 = url2.trim()).isEmpty()) {
                    return url2;
                }
            }
            catch (IOException e) {
                throw DbException.convert(e);
            }
        }
        return url;
    }

    public void cleanAuthenticationInfo() {
        this.removeProperty("AUTHREALM", false);
        this.removeProperty("AUTHZPWD", false);
    }

    static {
        String[] commonSettings = new String[]{"ACCESS_MODE_DATA", "AUTO_RECONNECT", "AUTO_SERVER", "AUTO_SERVER_PORT", "CACHE_TYPE", "FILE_LOCK", "JMX", "NETWORK_TIMEOUT", "OLD_INFORMATION_SCHEMA", "OPEN_NEW", "PAGE_SIZE", "RECOVER"};
        String[] settings = new String[]{"AUTHREALM", "AUTHZPWD", "AUTOCOMMIT", "CIPHER", "CREATE", "FORBID_CREATION", "IGNORE_UNKNOWN_SETTINGS", "IFEXISTS", "INIT", "NO_UPGRADE", "PASSWORD", "PASSWORD_HASH", "RECOVER_TEST", "USER"};
        HashSet<String> set = new HashSet<String>(128);
        set.addAll(SetTypes.getTypes());
        for (String setting : commonSettings) {
            if (set.add(setting)) continue;
            throw DbException.getInternalError(setting);
        }
        for (String setting : settings) {
            if (set.add(setting)) continue;
            throw DbException.getInternalError(setting);
        }
        KNOWN_SETTINGS = set;
        settings = new String[]{"ASSERT", "BINARY_COLLATION", "DB_CLOSE_ON_EXIT", "PAGE_STORE", "UUID_COLLATION"};
        set = new HashSet(32);
        for (String setting : commonSettings) {
            set.add(setting);
        }
        for (String setting : settings) {
            set.add(setting);
        }
        IGNORED_BY_PARSER = set;
    }
}

