/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.util.StringUtils;

public final class Comment
extends DbObject {
    private final int objectType;
    private final String quotedObjectName;
    private String commentText;

    public Comment(Database database, int id, DbObject obj) {
        super(database, id, Comment.getKey(obj), 2);
        this.objectType = obj.getType();
        this.quotedObjectName = obj.getSQL(0);
    }

    private static String getTypeName(int type) {
        switch (type) {
            case 11: {
                return "CONSTANT";
            }
            case 5: {
                return "CONSTRAINT";
            }
            case 9: {
                return "ALIAS";
            }
            case 1: {
                return "INDEX";
            }
            case 7: {
                return "ROLE";
            }
            case 10: {
                return "SCHEMA";
            }
            case 3: {
                return "SEQUENCE";
            }
            case 0: {
                return "TABLE";
            }
            case 4: {
                return "TRIGGER";
            }
            case 2: {
                return "USER";
            }
            case 12: {
                return "DOMAIN";
            }
        }
        return "type" + type;
    }

    @Override
    public String getCreateSQL() {
        StringBuilder buff = new StringBuilder("COMMENT ON ");
        buff.append(Comment.getTypeName(this.objectType)).append(' ').append(this.quotedObjectName).append(" IS ");
        if (this.commentText == null) {
            buff.append("NULL");
        } else {
            StringUtils.quoteStringSQL(buff, this.commentText);
        }
        return buff.toString();
    }

    @Override
    public int getType() {
        return 13;
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        this.database.removeMeta(session, this.getId());
    }

    @Override
    public void checkRename() {
        throw DbException.getInternalError();
    }

    static String getKey(DbObject obj) {
        StringBuilder builder = new StringBuilder(Comment.getTypeName(obj.getType())).append(' ');
        obj.getSQL(builder, 0);
        return builder.toString();
    }

    public void setCommentText(String comment) {
        this.commentText = comment;
    }
}

