/*
 * Decompiled with CFR 0.152.
 */
package org.h2.constraint;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.constraint.Constraint;
import org.h2.engine.SessionLocal;
import org.h2.index.Index;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.StringUtils;

public class ConstraintUnique
extends Constraint {
    private Index index;
    private boolean indexOwner;
    private IndexColumn[] columns;
    private final boolean primaryKey;

    public ConstraintUnique(Schema schema, int id, String name, Table table, boolean primaryKey) {
        super(schema, id, name, table);
        this.primaryKey = primaryKey;
    }

    @Override
    public Constraint.Type getConstraintType() {
        return this.primaryKey ? Constraint.Type.PRIMARY_KEY : Constraint.Type.UNIQUE;
    }

    @Override
    public String getCreateSQLForCopy(Table forTable, String quotedName) {
        return this.getCreateSQLForCopy(forTable, quotedName, true);
    }

    private String getCreateSQLForCopy(Table forTable, String quotedName, boolean internalIndex) {
        StringBuilder builder = new StringBuilder("ALTER TABLE ");
        forTable.getSQL(builder, 0).append(" ADD CONSTRAINT ");
        if (forTable.isHidden()) {
            builder.append("IF NOT EXISTS ");
        }
        builder.append(quotedName);
        if (this.comment != null) {
            builder.append(" COMMENT ");
            StringUtils.quoteStringSQL(builder, this.comment);
        }
        builder.append(' ').append(this.getConstraintType().getSqlName()).append('(');
        IndexColumn.writeColumns(builder, this.columns, 0).append(')');
        if (internalIndex && this.indexOwner && forTable == this.table) {
            builder.append(" INDEX ");
            this.index.getSQL(builder, 0);
        }
        return builder.toString();
    }

    @Override
    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(0), false);
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(0));
    }

    public void setColumns(IndexColumn[] columns) {
        this.columns = columns;
    }

    public IndexColumn[] getColumns() {
        return this.columns;
    }

    public void setIndex(Index index, boolean isOwner) {
        this.index = index;
        this.indexOwner = isOwner;
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        ArrayList<Constraint> constraints = this.table.getConstraints();
        if (constraints != null) {
            constraints = new ArrayList<Constraint>(this.table.getConstraints());
            for (Constraint c : constraints) {
                if (c.getReferencedConstraint() != this) continue;
                this.database.removeSchemaObject(session, c);
            }
        }
        this.table.removeConstraint(this);
        if (this.indexOwner) {
            this.table.removeIndexOrTransferOwnership(session, this.index);
        }
        this.database.removeMeta(session, this.getId());
        this.index = null;
        this.columns = null;
        this.table = null;
        this.invalidate();
    }

    @Override
    public void checkRow(SessionLocal session, Table t, Row oldRow, Row newRow) {
    }

    @Override
    public boolean usesIndex(Index idx) {
        return idx == this.index;
    }

    @Override
    public void setIndexOwner(Index index) {
        this.indexOwner = true;
    }

    @Override
    public HashSet<Column> getReferencedColumns(Table table) {
        HashSet<Column> result = new HashSet<Column>();
        for (IndexColumn c : this.columns) {
            result.add(c.column);
        }
        return result;
    }

    @Override
    public boolean isBefore() {
        return true;
    }

    @Override
    public void checkExistingData(SessionLocal session) {
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    @Override
    public void rebuild() {
    }
}

