/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.h2.command.query.Query;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionList;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableValueConstructorTable;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public class TableValueConstructor
extends Query {
    private final ArrayList<ArrayList<Expression>> rows;
    TableValueConstructorTable table;
    private TableValueColumnResolver columnResolver;
    private double cost;

    public TableValueConstructor(SessionLocal session, ArrayList<ArrayList<Expression>> rows) {
        super(session);
        this.rows = rows;
        this.visibleColumnCount = rows.get(0).size();
        if (this.visibleColumnCount > 16384) {
            throw DbException.get(54011, "16384");
        }
        for (ArrayList<Expression> row : rows) {
            for (Expression column : row) {
                if (column.isConstant()) continue;
                return;
            }
        }
        this.createTable();
    }

    public static void getVisibleResult(SessionLocal session, ResultTarget result, Column[] columns, ArrayList<ArrayList<Expression>> rows) {
        int count = columns.length;
        for (ArrayList<Expression> row : rows) {
            Value[] values = new Value[count];
            for (int i = 0; i < count; ++i) {
                values[i] = row.get(i).getValue(session).convertTo(columns[i].getType(), (CastDataProvider)session);
            }
            result.addRow(values);
        }
    }

    public static void getValuesSQL(StringBuilder builder, int sqlFlags, ArrayList<ArrayList<Expression>> rows) {
        builder.append("VALUES ");
        int rowCount = rows.size();
        for (int i = 0; i < rowCount; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            Expression.writeExpressions(builder.append('('), (List<? extends Expression>)rows.get(i), sqlFlags).append(')');
        }
    }

    @Override
    public boolean isUnion() {
        return false;
    }

    @Override
    protected ResultInterface queryWithoutCache(long limit, ResultTarget target) {
        Query.OffsetFetch offsetFetch = this.getOffsetFetch(limit);
        long offset = offsetFetch.offset;
        long fetch = offsetFetch.fetch;
        boolean fetchPercent = offsetFetch.fetchPercent;
        int visibleColumnCount = this.visibleColumnCount;
        int resultColumnCount = this.resultColumnCount;
        LocalResult result = new LocalResult(this.session, this.expressionArray, visibleColumnCount, resultColumnCount);
        if (this.sort != null) {
            result.setSortOrder(this.sort);
        }
        if (this.distinct) {
            result.setDistinct();
        }
        Column[] columns = this.table.getColumns();
        if (visibleColumnCount == resultColumnCount) {
            TableValueConstructor.getVisibleResult(this.session, result, columns, this.rows);
        } else {
            for (ArrayList<Expression> row : this.rows) {
                int i;
                Value[] values = new Value[resultColumnCount];
                for (i = 0; i < visibleColumnCount; ++i) {
                    values[i] = row.get(i).getValue(this.session).convertTo(columns[i].getType(), (CastDataProvider)this.session);
                }
                this.columnResolver.currentRow = values;
                for (i = visibleColumnCount; i < resultColumnCount; ++i) {
                    values[i] = this.expressionArray[i].getValue(this.session);
                }
                result.addRow(values);
            }
            this.columnResolver.currentRow = null;
        }
        return this.finishResult(result, offset, fetch, fetchPercent, target);
    }

    @Override
    public void init() {
        if (this.checkInit) {
            throw DbException.getInternalError();
        }
        this.checkInit = true;
        if (this.withTies && !this.hasOrder()) {
            throw DbException.get(90122);
        }
    }

    @Override
    public void prepareExpressions() {
        int i;
        if (this.columnResolver == null) {
            this.createTable();
        }
        if (this.orderList != null) {
            ArrayList<String> expressionsSQL = new ArrayList<String>();
            for (Expression e : this.expressions) {
                expressionsSQL.add(e.getSQL(0, 2));
            }
            if (this.initOrder(expressionsSQL, false, null)) {
                this.prepareOrder(this.orderList, this.expressions.size());
            }
        }
        this.resultColumnCount = this.expressions.size();
        for (i = 0; i < this.resultColumnCount; ++i) {
            ((Expression)this.expressions.get(i)).mapColumns(this.columnResolver, 0, 0);
        }
        for (i = this.visibleColumnCount; i < this.resultColumnCount; ++i) {
            this.expressions.set(i, ((Expression)this.expressions.get(i)).optimize(this.session));
        }
        if (this.sort != null) {
            this.cleanupOrder();
        }
        this.expressionArray = this.expressions.toArray(new Expression[0]);
    }

    @Override
    public void preparePlan() {
        double cost = 0.0;
        int columnCount = this.visibleColumnCount;
        for (ArrayList<Expression> r : this.rows) {
            for (int i = 0; i < columnCount; ++i) {
                cost += (double)r.get(i).getCost();
            }
        }
        this.cost = cost + (double)this.rows.size();
        this.isPrepared = true;
    }

    private void createTable() {
        TypeInfo type;
        int rowCount = this.rows.size();
        ArrayList<Expression> row = this.rows.get(0);
        int columnCount = row.size();
        TypeInfo[] types = new TypeInfo[columnCount];
        for (int c = 0; c < columnCount; ++c) {
            Expression e = row.get(c).optimize(this.session);
            row.set(c, e);
            type = e.getType();
            if (type.getValueType() == -1) {
                type = TypeInfo.TYPE_VARCHAR;
            }
            types[c] = type;
        }
        for (int r = 1; r < rowCount; ++r) {
            row = this.rows.get(r);
            for (int c = 0; c < columnCount; ++c) {
                Expression e = row.get(c).optimize(this.session);
                row.set(c, e);
                types[c] = TypeInfo.getHigherType(types[c], e.getType());
            }
        }
        Column[] columns = new Column[columnCount];
        int c = 0;
        while (c < columnCount) {
            type = types[c];
            columns[c++] = new Column("C" + c, type);
        }
        Database database = this.session.getDatabase();
        ArrayList<ExpressionColumn> expressions = new ArrayList<ExpressionColumn>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            expressions.add(new ExpressionColumn(database, null, null, columns[i].getName()));
        }
        this.expressions = expressions;
        this.table = new TableValueConstructorTable(this.session.getDatabase().getMainSchema(), this.session, columns, this.rows);
        this.columnResolver = new TableValueColumnResolver();
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> tables = new HashSet<Table>(1, 1.0f);
        tables.add(this.table);
        return tables;
    }

    @Override
    public void setForUpdate(boolean forUpdate) {
        throw DbException.get(90140);
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
        int columnCount = this.visibleColumnCount;
        for (ArrayList<Expression> row : this.rows) {
            for (int i = 0; i < columnCount; ++i) {
                row.get(i).mapColumns(resolver, level, 0);
            }
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        int columnCount = this.visibleColumnCount;
        for (ArrayList<Expression> row : this.rows) {
            for (int i = 0; i < columnCount; ++i) {
                row.get(i).setEvaluatable(tableFilter, b);
            }
        }
    }

    @Override
    public void addGlobalCondition(Parameter param, int columnId, int comparisonType) {
    }

    @Override
    public boolean allowGlobalConditions() {
        return false;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        ExpressionVisitor v2 = visitor.incrementQueryLevel(1);
        for (Expression e : this.expressionArray) {
            if (e.isEverything(v2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void updateAggregate(SessionLocal s, int stage) {
        int columnCount = this.visibleColumnCount;
        for (ArrayList<Expression> row : this.rows) {
            for (int i = 0; i < columnCount; ++i) {
                row.get(i).updateAggregate(s, stage);
            }
        }
    }

    @Override
    public void fireBeforeSelectTriggers() {
    }

    @Override
    public String getPlanSQL(int sqlFlags) {
        StringBuilder builder = new StringBuilder();
        TableValueConstructor.getValuesSQL(builder, sqlFlags, this.rows);
        this.appendEndOfQueryToSQL(builder, sqlFlags, this.expressionArray);
        return builder.toString();
    }

    @Override
    public Table toTable(String alias, Column[] columnTemplates, ArrayList<Parameter> parameters, boolean forCreateView, Query topQuery) {
        if (!this.hasOrder() && this.offsetExpr == null && this.fetchExpr == null && this.table != null) {
            return this.table;
        }
        return super.toTable(alias, columnTemplates, parameters, forCreateView, topQuery);
    }

    @Override
    public boolean isConstantQuery() {
        if (!super.isConstantQuery()) {
            return false;
        }
        for (ArrayList<Expression> row : this.rows) {
            for (int i = 0; i < this.visibleColumnCount; ++i) {
                if (row.get(i).isConstant()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Expression getIfSingleRow() {
        if (this.offsetExpr != null || this.fetchExpr != null || this.rows.size() != 1) {
            return null;
        }
        ArrayList<Expression> row = this.rows.get(0);
        if (this.visibleColumnCount == 1) {
            return row.get(0);
        }
        Expression[] array = new Expression[this.visibleColumnCount];
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            array[i] = row.get(i);
        }
        return new ExpressionList(array, false);
    }

    private final class TableValueColumnResolver
    implements ColumnResolver {
        Value[] currentRow;

        TableValueColumnResolver() {
        }

        @Override
        public Column[] getColumns() {
            return TableValueConstructor.this.table.getColumns();
        }

        @Override
        public Column findColumn(String name) {
            return TableValueConstructor.this.table.findColumn(name);
        }

        @Override
        public Value getValue(Column column) {
            return this.currentRow[column.getColumnId()];
        }

        @Override
        public Expression optimize(ExpressionColumn expressionColumn, Column column) {
            return (Expression)TableValueConstructor.this.expressions.get(column.getColumnId());
        }
    }
}

