/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.query;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.command.query.Query;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.message.DbException;
import org.h2.result.LazyResult;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public class SelectUnion
extends Query {
    private final UnionType unionType;
    final Query left;
    final Query right;
    private boolean isForUpdate;

    public SelectUnion(SessionLocal session, UnionType unionType, Query query, Query right) {
        super(session);
        this.unionType = unionType;
        this.left = query;
        this.right = right;
    }

    @Override
    public boolean isUnion() {
        return true;
    }

    public UnionType getUnionType() {
        return this.unionType;
    }

    public Query getLeft() {
        return this.left;
    }

    public Query getRight() {
        return this.right;
    }

    private Value[] convert(Value[] values, int columnCount) {
        Value[] newValues = columnCount == values.length ? values : new Value[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            Expression e = (Expression)this.expressions.get(i);
            newValues[i] = values[i].convertTo(e.getType(), (CastDataProvider)this.session);
        }
        return newValues;
    }

    public LocalResult getEmptyResult() {
        int columnCount = this.left.getColumnCount();
        return this.createLocalResult(columnCount);
    }

    @Override
    protected ResultInterface queryWithoutCache(long maxRows, ResultTarget target) {
        Query.OffsetFetch offsetFetch = this.getOffsetFetch(maxRows);
        long offset = offsetFetch.offset;
        long fetch = offsetFetch.fetch;
        boolean fetchPercent = offsetFetch.fetchPercent;
        Database db = this.session.getDatabase();
        if (db.getSettings().optimizeInsertFromSelect && this.unionType == UnionType.UNION_ALL && target != null && this.sort == null && !this.distinct && fetch < 0L && offset == 0L) {
            this.left.query(0L, target);
            this.right.query(0L, target);
            return null;
        }
        int columnCount = this.left.getColumnCount();
        if (!(!this.session.isLazyQueryExecution() || this.unionType != UnionType.UNION_ALL || this.distinct || this.sort != null || this.randomAccessResult || this.isForUpdate || offset != 0L || fetchPercent || this.withTies || !this.isReadOnly() || fetch == 0L)) {
            LazyResultUnion lazyResult = new LazyResultUnion(this.expressionArray, columnCount);
            if (fetch > 0L) {
                lazyResult.setLimit(fetch);
            }
            return lazyResult;
        }
        LocalResult result = this.createLocalResult(columnCount);
        if (this.sort != null) {
            result.setSortOrder(this.sort);
        }
        if (this.distinct) {
            this.left.setDistinctIfPossible();
            this.right.setDistinctIfPossible();
            result.setDistinct();
        }
        switch (this.unionType) {
            case UNION: 
            case EXCEPT: {
                this.left.setDistinctIfPossible();
                this.right.setDistinctIfPossible();
                result.setDistinct();
                break;
            }
            case UNION_ALL: {
                break;
            }
            case INTERSECT: {
                this.left.setDistinctIfPossible();
                this.right.setDistinctIfPossible();
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
        ResultInterface l = this.left.query(0L);
        ResultInterface r = this.right.query(0L);
        l.reset();
        r.reset();
        switch (this.unionType) {
            case UNION: 
            case UNION_ALL: {
                while (l.next()) {
                    result.addRow(this.convert(l.currentRow(), columnCount));
                }
                while (r.next()) {
                    result.addRow(this.convert(r.currentRow(), columnCount));
                }
                break;
            }
            case EXCEPT: {
                while (l.next()) {
                    result.addRow(this.convert(l.currentRow(), columnCount));
                }
                while (r.next()) {
                    result.removeDistinct(this.convert(r.currentRow(), columnCount));
                }
                break;
            }
            case INTERSECT: {
                LocalResult temp = this.createLocalResult(columnCount);
                temp.setDistinct();
                while (l.next()) {
                    temp.addRow(this.convert(l.currentRow(), columnCount));
                }
                while (r.next()) {
                    Value[] values = this.convert(r.currentRow(), columnCount);
                    if (!temp.containsDistinct(values)) continue;
                    result.addRow(values);
                }
                temp.close();
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
        l.close();
        r.close();
        return this.finishResult(result, offset, fetch, fetchPercent, target);
    }

    private LocalResult createLocalResult(int columnCount) {
        return new LocalResult(this.session, this.expressionArray, columnCount, columnCount);
    }

    @Override
    public void init() {
        if (this.checkInit) {
            throw DbException.getInternalError();
        }
        this.checkInit = true;
        this.left.init();
        this.right.init();
        int len = this.left.getColumnCount();
        if (len != this.right.getColumnCount()) {
            throw DbException.get(21002);
        }
        ArrayList<Expression> le = this.left.getExpressions();
        this.expressions = new ArrayList(len);
        for (int i = 0; i < len; ++i) {
            Expression l = le.get(i);
            this.expressions.add(l);
        }
        this.visibleColumnCount = len;
        if (this.withTies && !this.hasOrder()) {
            throw DbException.get(90122);
        }
    }

    @Override
    public void prepareExpressions() {
        this.left.prepareExpressions();
        this.right.prepareExpressions();
        int len = this.left.getColumnCount();
        this.expressions = new ArrayList(len);
        ArrayList<Expression> le = this.left.getExpressions();
        ArrayList<Expression> re = this.right.getExpressions();
        for (int i = 0; i < len; ++i) {
            Expression l = le.get(i);
            Expression r = re.get(i);
            Column col = new Column(l.getAlias(this.session, i), TypeInfo.getHigherType(l.getType(), r.getType()));
            ExpressionColumn e = new ExpressionColumn(this.session.getDatabase(), col);
            this.expressions.add(e);
        }
        if (this.orderList != null && this.initOrder(null, true, null)) {
            this.prepareOrder(this.orderList, this.expressions.size());
            this.cleanupOrder();
        }
        this.resultColumnCount = this.expressions.size();
        this.expressionArray = this.expressions.toArray(new Expression[0]);
    }

    @Override
    public void preparePlan() {
        this.left.preparePlan();
        this.right.preparePlan();
        this.isPrepared = true;
    }

    @Override
    public double getCost() {
        return this.left.getCost() + this.right.getCost();
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> set = this.left.getTables();
        set.addAll(this.right.getTables());
        return set;
    }

    @Override
    public void setForUpdate(boolean forUpdate) {
        this.left.setForUpdate(forUpdate);
        this.right.setForUpdate(forUpdate);
        this.isForUpdate = forUpdate;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
        this.left.mapColumns(resolver, level);
        this.right.mapColumns(resolver, level);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        this.right.setEvaluatable(tableFilter, b);
    }

    @Override
    public void addGlobalCondition(Parameter param, int columnId, int comparisonType) {
        this.addParameter(param);
        switch (this.unionType) {
            case UNION: 
            case UNION_ALL: 
            case INTERSECT: {
                this.left.addGlobalCondition(param, columnId, comparisonType);
                this.right.addGlobalCondition(param, columnId, comparisonType);
                break;
            }
            case EXCEPT: {
                this.left.addGlobalCondition(param, columnId, comparisonType);
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
    }

    @Override
    public String getPlanSQL(int sqlFlags) {
        StringBuilder buff = new StringBuilder();
        buff.append('(').append(this.left.getPlanSQL(sqlFlags)).append(')');
        switch (this.unionType) {
            case UNION_ALL: {
                buff.append("\nUNION ALL\n");
                break;
            }
            case UNION: {
                buff.append("\nUNION\n");
                break;
            }
            case INTERSECT: {
                buff.append("\nINTERSECT\n");
                break;
            }
            case EXCEPT: {
                buff.append("\nEXCEPT\n");
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
        buff.append('(').append(this.right.getPlanSQL(sqlFlags)).append(')');
        this.appendEndOfQueryToSQL(buff, sqlFlags, this.expressions.toArray(new Expression[0]));
        if (this.isForUpdate) {
            buff.append("\nFOR UPDATE");
        }
        return buff.toString();
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.right.isEverything(visitor);
    }

    @Override
    public void updateAggregate(SessionLocal s, int stage) {
        this.left.updateAggregate(s, stage);
        this.right.updateAggregate(s, stage);
    }

    @Override
    public void fireBeforeSelectTriggers() {
        this.left.fireBeforeSelectTriggers();
        this.right.fireBeforeSelectTriggers();
    }

    @Override
    public boolean allowGlobalConditions() {
        return this.left.allowGlobalConditions() && this.right.allowGlobalConditions();
    }

    @Override
    public boolean isConstantQuery() {
        return super.isConstantQuery() && this.left.isConstantQuery() && this.right.isConstantQuery();
    }

    private final class LazyResultUnion
    extends LazyResult {
        int columnCount;
        ResultInterface l;
        ResultInterface r;
        boolean leftDone;
        boolean rightDone;

        LazyResultUnion(Expression[] expressions, int columnCount) {
            super(SelectUnion.this.getSession(), expressions);
            this.columnCount = columnCount;
        }

        @Override
        public int getVisibleColumnCount() {
            return this.columnCount;
        }

        @Override
        protected Value[] fetchNextRow() {
            if (this.rightDone) {
                return null;
            }
            if (!this.leftDone) {
                if (this.l == null) {
                    this.l = SelectUnion.this.left.query(0L);
                    this.l.reset();
                }
                if (this.l.next()) {
                    return this.l.currentRow();
                }
                this.leftDone = true;
            }
            if (this.r == null) {
                this.r = SelectUnion.this.right.query(0L);
                this.r.reset();
            }
            if (this.r.next()) {
                return this.r.currentRow();
            }
            this.rightDone = true;
            return null;
        }

        @Override
        public void close() {
            super.close();
            if (this.l != null) {
                this.l.close();
            }
            if (this.r != null) {
                this.r.close();
            }
        }

        @Override
        public void reset() {
            super.reset();
            if (this.l != null) {
                this.l.reset();
            }
            if (this.r != null) {
                this.r.reset();
            }
            this.leftDone = false;
            this.rightDone = false;
        }
    }

    public static enum UnionType {
        UNION,
        UNION_ALL,
        EXCEPT,
        INTERSECT;

    }
}

