/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionList;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.DataChangeDeltaTable;
import org.h2.table.Table;
import org.h2.util.HasSQL;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public final class SetClauseList
implements HasSQL {
    private final Table table;
    private final UpdateAction[] actions;
    private boolean onUpdate;

    public SetClauseList(Table table) {
        this.table = table;
        this.actions = new UpdateAction[table.getColumns().length];
    }

    public void addSingle(Column column, Expression expression) {
        int id = column.getColumnId();
        if (this.actions[id] != null) {
            throw DbException.get(42121, column.getName());
        }
        if (expression != ValueExpression.DEFAULT) {
            this.actions[id] = new SetSimple(expression);
            if (expression instanceof Parameter) {
                ((Parameter)expression).setColumn(column);
            }
        } else {
            this.actions[id] = UpdateAction.SET_DEFAULT;
        }
    }

    public void addMultiple(ArrayList<Column> columns, Expression expression) {
        ExpressionList expressions;
        int columnCount = columns.size();
        if (expression instanceof ExpressionList && !(expressions = (ExpressionList)expression).isArray()) {
            if (columnCount != expressions.getSubexpressionCount()) {
                throw DbException.get(21002);
            }
            for (int i = 0; i < columnCount; ++i) {
                this.addSingle(columns.get(i), expressions.getSubexpression(i));
            }
            return;
        }
        if (columnCount == 1) {
            this.addSingle(columns.get(0), expression);
        } else {
            int i;
            int[] cols = new int[columnCount];
            RowExpression row = new RowExpression(expression, cols);
            int minId = this.table.getColumns().length - 1;
            int maxId = 0;
            for (i = 0; i < columnCount; ++i) {
                int id = columns.get(i).getColumnId();
                if (id < minId) {
                    minId = id;
                }
                if (id <= maxId) continue;
                maxId = id;
            }
            for (i = 0; i < columnCount; ++i) {
                int id;
                Column column = columns.get(i);
                cols[i] = id = column.getColumnId();
                if (this.actions[id] != null) {
                    throw DbException.get(42121, column.getName());
                }
                this.actions[id] = new SetMultiple(row, i, id == minId, id == maxId);
            }
        }
    }

    boolean prepareUpdate(Table table, SessionLocal session, ResultTarget deltaChangeCollector, DataChangeDeltaTable.ResultOption deltaChangeCollectionMode, LocalResult rows, Row oldRow, boolean updateToCurrentValuesReturnsZero) {
        Column[] columns = table.getColumns();
        int columnCount = columns.length;
        Row newRow = table.getTemplateRow();
        for (int i = 0; i < columnCount; ++i) {
            Value newValue;
            UpdateAction action = this.actions[i];
            Column column = columns[i];
            if (action == null || action == UpdateAction.ON_UPDATE) {
                newValue = column.isGenerated() ? null : oldRow.getValue(i);
            } else if (action == UpdateAction.SET_DEFAULT) {
                newValue = !column.isIdentity() ? null : oldRow.getValue(i);
            } else {
                newValue = action.update(session);
                if (newValue == ValueNull.INSTANCE && column.isDefaultOnNull()) {
                    newValue = !column.isIdentity() ? null : oldRow.getValue(i);
                } else if (column.isGeneratedAlways()) {
                    throw DbException.get(90154, column.getSQLWithTable(new StringBuilder(), 3).toString());
                }
            }
            newRow.setValue(i, newValue);
        }
        newRow.setKey(oldRow.getKey());
        table.convertUpdateRow(session, newRow, false);
        boolean result = true;
        if (this.onUpdate) {
            if (!oldRow.hasSameValues(newRow)) {
                for (int i = 0; i < columnCount; ++i) {
                    if (this.actions[i] == UpdateAction.ON_UPDATE) {
                        newRow.setValue(i, columns[i].getEffectiveOnUpdateExpression().getValue(session));
                        continue;
                    }
                    if (!columns[i].isGenerated()) continue;
                    newRow.setValue(i, null);
                }
                table.convertUpdateRow(session, newRow, false);
            } else if (updateToCurrentValuesReturnsZero) {
                result = false;
            }
        } else if (updateToCurrentValuesReturnsZero && oldRow.hasSameValues(newRow)) {
            result = false;
        }
        if (deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.OLD) {
            deltaChangeCollector.addRow(oldRow.getValueList());
        } else if (deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.NEW) {
            deltaChangeCollector.addRow((Value[])newRow.getValueList().clone());
        }
        if (!table.fireRow() || !table.fireBeforeRow(session, oldRow, newRow)) {
            rows.addRowForTable(oldRow);
            rows.addRowForTable(newRow);
        }
        if (deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.FINAL) {
            deltaChangeCollector.addRow(newRow.getValueList());
        }
        return result;
    }

    boolean isEverything(ExpressionVisitor visitor) {
        for (UpdateAction action : this.actions) {
            if (action == null || action.isEverything(visitor)) continue;
            return false;
        }
        return true;
    }

    void mapAndOptimize(SessionLocal session, ColumnResolver resolver1, ColumnResolver resolver2) {
        Column[] columns = this.table.getColumns();
        boolean onUpdate = false;
        for (int i = 0; i < this.actions.length; ++i) {
            UpdateAction action = this.actions[i];
            if (action != null) {
                action.mapAndOptimize(session, resolver1, resolver2);
                continue;
            }
            Column column = columns[i];
            if (column.getEffectiveOnUpdateExpression() == null) continue;
            this.actions[i] = UpdateAction.ON_UPDATE;
            onUpdate = true;
        }
        this.onUpdate = onUpdate;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        Column[] columns = this.table.getColumns();
        builder.append("\nSET\n    ");
        boolean f = false;
        for (int i = 0; i < this.actions.length; ++i) {
            UpdateAction action = this.actions[i];
            if (action == null || action == UpdateAction.ON_UPDATE) continue;
            if (action.getClass() == SetMultiple.class) {
                SetMultiple multiple = (SetMultiple)action;
                if (!multiple.first) continue;
                if (f) {
                    builder.append(",\n    ");
                }
                f = true;
                RowExpression r = multiple.row;
                builder.append('(');
                int[] cols = r.columns;
                int l = cols.length;
                for (int j = 0; j < l; ++j) {
                    if (j > 0) {
                        builder.append(", ");
                    }
                    columns[cols[j]].getSQL(builder, sqlFlags);
                }
                r.expression.getUnenclosedSQL(builder.append(") = "), sqlFlags);
                continue;
            }
            if (f) {
                builder.append(",\n    ");
            }
            f = true;
            Column column = columns[i];
            if (action != UpdateAction.SET_DEFAULT) {
                action.getSQL(builder, sqlFlags, column);
                continue;
            }
            column.getSQL(builder, sqlFlags).append(" = DEFAULT");
        }
        return builder;
    }

    private static final class SetMultiple
    extends UpdateAction {
        final RowExpression row;
        private final int position;
        boolean first;
        private boolean last;

        SetMultiple(RowExpression row, int position, boolean first, boolean last) {
            this.row = row;
            this.position = position;
            this.first = first;
            this.last = last;
        }

        @Override
        Value update(SessionLocal session) {
            Value[] v;
            if (this.first) {
                Value value = this.row.expression.getValue(session);
                if (value == ValueNull.INSTANCE) {
                    throw DbException.get(22018, "NULL to assigned row value");
                }
                this.row.values = v = value.convertToAnyRow().getList();
                if (v.length != this.row.columns.length) {
                    throw DbException.get(21002);
                }
            } else {
                v = this.row.values;
                if (this.last) {
                    this.row.values = null;
                }
            }
            return v[this.position];
        }

        @Override
        boolean isEverything(ExpressionVisitor visitor) {
            return !this.first || this.row.isEverything(visitor);
        }

        @Override
        void mapAndOptimize(SessionLocal session, ColumnResolver resolver1, ColumnResolver resolver2) {
            if (this.first) {
                this.row.mapAndOptimize(session, resolver1, resolver2);
            }
        }
    }

    private static final class RowExpression {
        Expression expression;
        final int[] columns;
        Value[] values;

        RowExpression(Expression expression, int[] columns) {
            this.expression = expression;
            this.columns = columns;
        }

        boolean isEverything(ExpressionVisitor visitor) {
            return this.expression.isEverything(visitor);
        }

        void mapAndOptimize(SessionLocal session, ColumnResolver resolver1, ColumnResolver resolver2) {
            this.expression.mapColumns(resolver1, 0, 0);
            if (resolver2 != null) {
                this.expression.mapColumns(resolver2, 0, 0);
            }
            this.expression = this.expression.optimize(session);
        }
    }

    private static final class SetSimple
    extends UpdateAction {
        private Expression expression;

        SetSimple(Expression expression) {
            this.expression = expression;
        }

        @Override
        Value update(SessionLocal session) {
            return this.expression.getValue(session);
        }

        @Override
        boolean isEverything(ExpressionVisitor visitor) {
            return this.expression.isEverything(visitor);
        }

        @Override
        void mapAndOptimize(SessionLocal session, ColumnResolver resolver1, ColumnResolver resolver2) {
            this.expression.mapColumns(resolver1, 0, 0);
            if (resolver2 != null) {
                this.expression.mapColumns(resolver2, 0, 0);
            }
            this.expression = this.expression.optimize(session);
        }

        @Override
        void getSQL(StringBuilder builder, int sqlFlags, Column column) {
            this.expression.getUnenclosedSQL(column.getSQL(builder, sqlFlags).append(" = "), sqlFlags);
        }
    }

    private static class UpdateAction {
        static UpdateAction ON_UPDATE = new UpdateAction();
        static UpdateAction SET_DEFAULT = new UpdateAction();

        UpdateAction() {
        }

        Value update(SessionLocal session) {
            throw DbException.getInternalError();
        }

        boolean isEverything(ExpressionVisitor visitor) {
            return true;
        }

        void mapAndOptimize(SessionLocal session, ColumnResolver resolver1, ColumnResolver resolver2) {
        }

        void getSQL(StringBuilder builder, int sqlFlags, Column column) {
            throw DbException.getInternalError();
        }
    }
}

