/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.h2.command.dml.ScriptBase;
import org.h2.command.dml.SetTypes;
import org.h2.constraint.Constraint;
import org.h2.engine.Comment;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.SessionLocal;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.schema.Constant;
import org.h2.schema.Domain;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.schema.UserDefinedFunction;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueVarchar;

public class ScriptCommand
extends ScriptBase {
    private static final Comparator<? super DbObject> BY_NAME_COMPARATOR = (o1, o2) -> {
        int cmp;
        if (o1 instanceof SchemaObject && o2 instanceof SchemaObject && (cmp = ((SchemaObject)o1).getSchema().getName().compareTo(((SchemaObject)o2).getSchema().getName())) != 0) {
            return cmp;
        }
        return o1.getName().compareTo(o2.getName());
    };
    private Charset charset = StandardCharsets.UTF_8;
    private Set<String> schemaNames;
    private Collection<Table> tables;
    private boolean passwords;
    private boolean data;
    private boolean settings;
    private boolean drop;
    private boolean simple;
    private boolean withColumns;
    private boolean version = true;
    private LocalResult result;
    private String lineSeparatorString;
    private byte[] lineSeparator;
    private byte[] buffer;
    private boolean tempLobTableCreated;
    private int nextLobId;
    private int lobBlockSize = 4096;

    public ScriptCommand(SessionLocal session) {
        super(session);
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    public void setSchemaNames(Set<String> schemaNames) {
        this.schemaNames = schemaNames;
    }

    public void setTables(Collection<Table> tables) {
        this.tables = tables;
    }

    public void setData(boolean data) {
        this.data = data;
    }

    public void setPasswords(boolean passwords) {
        this.passwords = passwords;
    }

    public void setSettings(boolean settings) {
        this.settings = settings;
    }

    public void setLobBlockSize(long blockSize) {
        this.lobBlockSize = MathUtils.convertLongToInt(blockSize);
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    @Override
    public ResultInterface queryMeta() {
        LocalResult r = this.createResult();
        r.done();
        return r;
    }

    private LocalResult createResult() {
        return new LocalResult(this.session, new Expression[]{new ExpressionColumn(this.session.getDatabase(), new Column("SCRIPT", TypeInfo.TYPE_VARCHAR))}, 1, 1);
    }

    @Override
    public ResultInterface query(long maxrows) {
        this.session.getUser().checkAdmin();
        this.reset();
        Database db = this.session.getDatabase();
        if (this.schemaNames != null) {
            for (String string : this.schemaNames) {
                Schema schema = db.findSchema(string);
                if (schema != null) continue;
                throw DbException.get(90079, string);
            }
        }
        try {
            this.result = this.createResult();
            this.deleteStore();
            this.openOutput();
            if (this.out != null) {
                this.buffer = new byte[4096];
            }
            if (this.version) {
                this.add("-- H2 " + Constants.VERSION, true);
            }
            if (this.settings) {
                for (Setting setting : db.getAllSettings()) {
                    if (setting.getName().equals(SetTypes.getTypeName(28))) continue;
                    this.add(setting.getCreateSQL(), false);
                }
            }
            if (this.out != null) {
                this.add("", true);
            }
            RightOwner[] rightOwners = db.getAllUsersAndRoles().toArray(new RightOwner[0]);
            Arrays.sort(rightOwners, (o1, o2) -> {
                boolean b = o1 instanceof User;
                if (b != o2 instanceof User) {
                    return b ? -1 : 1;
                }
                if (b && (b = ((User)o1).isAdmin()) != ((User)o2).isAdmin()) {
                    return b ? -1 : 1;
                }
                return o1.getName().compareTo(o2.getName());
            });
            for (RightOwner rightOwner : rightOwners) {
                if (rightOwner instanceof User) {
                    this.add(((User)rightOwner).getCreateSQL(this.passwords), false);
                    continue;
                }
                this.add(((Role)rightOwner).getCreateSQL(true), false);
            }
            ArrayList<Schema> arrayList = new ArrayList<Schema>();
            for (Schema schema : db.getAllSchemas()) {
                if (this.excludeSchema(schema)) continue;
                arrayList.add(schema);
                this.add(schema.getCreateSQL(), false);
            }
            this.dumpDomains(arrayList);
            for (Schema schema : arrayList) {
                for (Constant constant : (Constant[])ScriptCommand.sorted(schema.getAllConstants(), Constant.class)) {
                    this.add(constant.getCreateSQL(), false);
                }
            }
            ArrayList<Table> tables = db.getAllTablesAndViews();
            tables.sort(Comparator.comparingInt(DbObject::getId));
            for (Table table : tables) {
                if (this.excludeSchema(table.getSchema()) || this.excludeTable(table) || table.isHidden()) continue;
                table.lock(this.session, 0);
                String sql = table.getCreateSQL();
                if (sql == null || !this.drop) continue;
                this.add(table.getDropSQL(), false);
            }
            for (Schema schema : arrayList) {
                for (UserDefinedFunction userDefinedFunction : (UserDefinedFunction[])ScriptCommand.sorted(schema.getAllFunctionsAndAggregates(), UserDefinedFunction.class)) {
                    if (this.drop) {
                        this.add(userDefinedFunction.getDropSQL(), false);
                    }
                    this.add(userDefinedFunction.getCreateSQL(), false);
                }
            }
            for (Schema schema : arrayList) {
                for (Sequence sequence : (Sequence[])ScriptCommand.sorted(schema.getAllSequences(), Sequence.class)) {
                    if (sequence.getBelongsToTable()) continue;
                    if (this.drop) {
                        this.add(sequence.getDropSQL(), false);
                    }
                    this.add(sequence.getCreateSQL(), false);
                }
            }
            int count = 0;
            for (Table table : tables) {
                if (this.excludeSchema(table.getSchema()) || this.excludeTable(table) || table.isHidden()) continue;
                table.lock(this.session, 0);
                String createTableSql = table.getCreateSQL();
                if (createTableSql == null) continue;
                TableType tableType = table.getTableType();
                this.add(createTableSql, false);
                ArrayList<Constraint> constraints = table.getConstraints();
                if (constraints != null) {
                    for (Constraint constraint : constraints) {
                        if (Constraint.Type.PRIMARY_KEY != constraint.getConstraintType()) continue;
                        this.add(constraint.getCreateSQLWithoutIndexes(), false);
                    }
                }
                if (TableType.TABLE == tableType) {
                    if (table.canGetRowCount(this.session)) {
                        StringBuilder builder = new StringBuilder("-- ").append(table.getRowCountApproximation(this.session)).append(" +/- SELECT COUNT(*) FROM ");
                        table.getSQL(builder, 3);
                        this.add(builder.toString(), false);
                    }
                    if (this.data) {
                        count = this.generateInsertValues(count, table);
                    }
                }
                ArrayList<Index> indexes = table.getIndexes();
                for (int j = 0; indexes != null && j < indexes.size(); ++j) {
                    Index index = indexes.get(j);
                    if (index.getIndexType().getBelongsToConstraint()) continue;
                    this.add(index.getCreateSQL(), false);
                }
            }
            if (this.tempLobTableCreated) {
                this.add("DROP TABLE IF EXISTS SYSTEM_LOB_STREAM", true);
                this.add("DROP ALIAS IF EXISTS SYSTEM_COMBINE_CLOB", true);
                this.add("DROP ALIAS IF EXISTS SYSTEM_COMBINE_BLOB", true);
                this.tempLobTableCreated = false;
            }
            ArrayList<Constraint> arrayList2 = new ArrayList<Constraint>();
            for (Schema schema : arrayList) {
                for (Constraint constraint : schema.getAllConstraints()) {
                    Constraint.Type constraintType;
                    if (this.excludeTable(constraint.getTable()) || (constraintType = constraint.getConstraintType()) != Constraint.Type.DOMAIN && constraint.getTable().isHidden() || constraintType == Constraint.Type.PRIMARY_KEY) continue;
                    arrayList2.add(constraint);
                }
            }
            arrayList2.sort(null);
            for (Constraint constraint : arrayList2) {
                this.add(constraint.getCreateSQLWithoutIndexes(), false);
            }
            for (Schema schema : arrayList) {
                for (TriggerObject trigger : schema.getAllTriggers()) {
                    if (this.excludeTable(trigger.getTable())) continue;
                    this.add(trigger.getCreateSQL(), false);
                }
            }
            this.dumpRights(db);
            for (Comment comment : db.getAllComments()) {
                this.add(comment.getCreateSQL(), false);
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.getFileName());
        }
        finally {
            this.closeIO();
        }
        this.result.done();
        LocalResult r = this.result;
        this.reset();
        return r;
    }

    private void dumpDomains(ArrayList<Schema> schemas) throws IOException {
        TreeMap<DbObject, TreeSet<? super DbObject>> referencingDomains = new TreeMap<DbObject, TreeSet<? super DbObject>>(BY_NAME_COMPARATOR);
        TreeSet<? super DbObject> known = new TreeSet<DbObject>(BY_NAME_COMPARATOR);
        for (Schema schema : schemas) {
            for (Domain domain : (Domain[])ScriptCommand.sorted(schema.getAllDomains(), Domain.class)) {
                Domain parent = domain.getDomain();
                if (parent == null) {
                    this.addDomain(domain);
                    continue;
                }
                TreeSet<? super DbObject> set = (TreeSet<? super DbObject>)referencingDomains.get(parent);
                if (set == null) {
                    set = new TreeSet<DbObject>(BY_NAME_COMPARATOR);
                    referencingDomains.put(parent, set);
                }
                set.add(domain);
                if (parent.getDomain() != null && schemas.contains(parent.getSchema())) continue;
                known.add(parent);
            }
        }
        while (!referencingDomains.isEmpty()) {
            TreeSet<? super DbObject> known2 = new TreeSet<DbObject>(BY_NAME_COMPARATOR);
            for (Domain domain : known) {
                TreeSet set = (TreeSet)referencingDomains.remove(domain);
                if (set == null) continue;
                for (Domain d2 : set) {
                    this.addDomain(d2);
                    known2.add(d2);
                }
            }
            known = known2;
        }
    }

    private void dumpRights(Database db) throws IOException {
        Right[] rights = db.getAllRights().toArray(new Right[0]);
        Arrays.sort(rights, (o1, o2) -> {
            Role r2;
            Role r1 = o1.getGrantedRole();
            if (r1 == null != ((r2 = o2.getGrantedRole()) == null)) {
                return r1 == null ? -1 : 1;
            }
            if (r1 == null) {
                DbObject g2;
                DbObject g1 = o1.getGrantedObject();
                if (g1 == null != ((g2 = o2.getGrantedObject()) == null)) {
                    return g1 == null ? -1 : 1;
                }
                if (g1 != null) {
                    if (g1 instanceof Schema != g2 instanceof Schema) {
                        return g1 instanceof Schema ? -1 : 1;
                    }
                    int cmp = g1.getName().compareTo(g2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                }
            } else {
                int cmp = r1.getName().compareTo(r2.getName());
                if (cmp != 0) {
                    return cmp;
                }
            }
            return o1.getGrantee().getName().compareTo(o2.getGrantee().getName());
        });
        for (Right right : rights) {
            Table table;
            DbObject object = right.getGrantedObject();
            if (object != null && (object instanceof Schema ? this.excludeSchema((Schema)object) : object instanceof Table && (this.excludeSchema((table = (Table)object).getSchema()) || this.excludeTable(table)))) continue;
            this.add(right.getCreateSQL(), false);
        }
    }

    private void addDomain(Domain domain) throws IOException {
        if (this.drop) {
            this.add(domain.getDropSQL(), false);
        }
        this.add(domain.getCreateSQL(), false);
    }

    private static <T extends DbObject> T[] sorted(Collection<T> collection, Class<T> clazz) {
        DbObject[] array = collection.toArray((DbObject[])Array.newInstance(clazz, 0));
        Arrays.sort(array, BY_NAME_COMPARATOR);
        return array;
    }

    private int generateInsertValues(int count, Table table) throws IOException {
        PlanItem plan = table.getBestPlanItem(this.session, null, null, -1, null, null);
        Index index = plan.getIndex();
        Cursor cursor = index.find(this.session, null, null);
        Column[] columns = table.getColumns();
        boolean withGenerated = false;
        boolean withGeneratedAlwaysAsIdentity = false;
        for (Column c : columns) {
            if (!c.isGeneratedAlways()) continue;
            if (c.isIdentity()) {
                withGeneratedAlwaysAsIdentity = true;
                continue;
            }
            withGenerated = true;
        }
        StringBuilder builder = new StringBuilder("INSERT INTO ");
        table.getSQL(builder, 0);
        if (withGenerated || withGeneratedAlwaysAsIdentity || this.withColumns) {
            builder.append('(');
            boolean needComma = false;
            for (Column column : columns) {
                if (column.isGenerated()) continue;
                if (needComma) {
                    builder.append(", ");
                }
                needComma = true;
                column.getSQL(builder, 0);
            }
            builder.append(')');
            if (withGeneratedAlwaysAsIdentity) {
                builder.append(" OVERRIDING SYSTEM VALUE");
            }
        }
        builder.append(" VALUES");
        if (!this.simple) {
            builder.append('\n');
        }
        builder.append('(');
        String ins = builder.toString();
        builder = null;
        int columnCount = columns.length;
        while (cursor.next()) {
            Row row = cursor.get();
            if (builder == null) {
                builder = new StringBuilder(ins);
            } else {
                builder.append(",\n(");
            }
            boolean needComma = false;
            for (int i = 0; i < columnCount; ++i) {
                if (columns[i].isGenerated()) continue;
                if (needComma) {
                    builder.append(", ");
                }
                needComma = true;
                Value v = row.getValue(i);
                if (v.getType().getPrecision() > (long)this.lobBlockSize) {
                    int id;
                    if (v.getValueType() == 3) {
                        id = this.writeLobStream(v);
                        builder.append("SYSTEM_COMBINE_CLOB(").append(id).append(')');
                        continue;
                    }
                    if (v.getValueType() == 7) {
                        id = this.writeLobStream(v);
                        builder.append("SYSTEM_COMBINE_BLOB(").append(id).append(')');
                        continue;
                    }
                    v.getSQL(builder, 4);
                    continue;
                }
                v.getSQL(builder, 4);
            }
            builder.append(')');
            if ((++count & 0x7F) == 0) {
                this.checkCanceled();
            }
            if (!this.simple && builder.length() <= 4096) continue;
            this.add(builder.toString(), true);
            builder = null;
        }
        if (builder != null) {
            this.add(builder.toString(), true);
        }
        return count;
    }

    /*
     * Unable to fully structure code
     */
    private int writeLobStream(Value v) throws IOException {
        if (!this.tempLobTableCreated) {
            this.add("CREATE CACHED LOCAL TEMPORARY TABLE IF NOT EXISTS SYSTEM_LOB_STREAM(ID INT NOT NULL, PART INT NOT NULL, CDATA VARCHAR, BDATA VARBINARY)", true);
            this.add("ALTER TABLE SYSTEM_LOB_STREAM ADD CONSTRAINT SYSTEM_LOB_STREAM_PRIMARY_KEY PRIMARY KEY(ID, PART)", true);
            className = this.getClass().getName();
            this.add("CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_CLOB FOR '" + className + ".combineClob'", true);
            this.add("CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_BLOB FOR '" + className + ".combineBlob'", true);
            this.tempLobTableCreated = true;
        }
        id = this.nextLobId++;
        switch (v.getValueType()) {
            case 7: {
                bytes = new byte[this.lobBlockSize];
                input = v.getInputStream();
                var5_8 = null;
                i = 0;
                while (true) {
                    buff = new StringBuilder(this.lobBlockSize * 2);
                    buff.append("INSERT INTO SYSTEM_LOB_STREAM VALUES(").append(id).append(", ").append(i).append(", NULL, X'");
                    len = IOUtils.readFully(input, bytes, this.lobBlockSize);
                    if (len <= 0) break;
                    StringUtils.convertBytesToHex(buff, bytes, len).append("')");
                    sql = buff.toString();
                    this.add(sql, true);
                    ++i;
                }
                if (input == null) break;
                if (var5_8 == null) ** GOTO lbl36
                try {
                    input.close();
                }
                catch (Throwable i) {
                    var5_8.addSuppressed(i);
                }
                break;
lbl36:
                // 1 sources

                input.close();
                break;
                catch (Throwable i) {
                    try {
                        var5_8 = i;
                        throw i;
                    }
                    catch (Throwable var10_22) {
                        if (input != null) {
                            if (var5_8 != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable var11_23) {
                                    var5_8.addSuppressed(var11_23);
                                }
                            } else {
                                input.close();
                            }
                        }
                        throw var10_22;
                    }
                }
            }
            case 3: {
                chars = new char[this.lobBlockSize];
                reader = v.getReader();
                var5_9 = null;
                i = 0;
                while (true) {
                    buff = new StringBuilder(this.lobBlockSize * 2);
                    buff.append("INSERT INTO SYSTEM_LOB_STREAM VALUES(").append(id).append(", ").append(i).append(", ");
                    len = IOUtils.readFully(reader, chars, this.lobBlockSize);
                    if (len == 0) break;
                    StringUtils.quoteStringSQL(buff, new String(chars, 0, len)).append(", NULL)");
                    sql = buff.toString();
                    this.add(sql, true);
                    ++i;
                }
                if (reader == null) break;
                if (var5_9 == null) ** GOTO lbl79
                try {
                    reader.close();
                }
                catch (Throwable var6_14) {
                    var5_9.addSuppressed(var6_14);
                }
                break;
lbl79:
                // 1 sources

                reader.close();
                break;
                catch (Throwable var6_15) {
                    try {
                        var5_9 = var6_15;
                        throw var6_15;
                    }
                    catch (Throwable var12_24) {
                        if (reader != null) {
                            if (var5_9 != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable var13_25) {
                                    var5_9.addSuppressed(var13_25);
                                }
                            } else {
                                reader.close();
                            }
                        }
                        throw var12_24;
                    }
                }
            }
            default: {
                throw DbException.getInternalError("type:" + v.getValueType());
            }
        }
        return id;
    }

    public static InputStream combineBlob(Connection conn, int id) throws SQLException {
        if (id < 0) {
            return null;
        }
        final ResultSet rs = ScriptCommand.getLobStream(conn, "BDATA", id);
        return new InputStream(){
            private InputStream current;
            private boolean closed;

            @Override
            public int read() throws IOException {
                try {
                    while (true) {
                        int x;
                        if (this.current == null) {
                            if (this.closed) {
                                return -1;
                            }
                            if (!rs.next()) {
                                this.close();
                                return -1;
                            }
                            this.current = rs.getBinaryStream(1);
                            this.current = new BufferedInputStream(this.current);
                        }
                        if ((x = this.current.read()) >= 0) {
                            return x;
                        }
                        this.current = null;
                    }
                }
                catch (SQLException e) {
                    throw DataUtils.convertToIOException(e);
                }
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw DataUtils.convertToIOException(e);
                }
            }
        };
    }

    public static Reader combineClob(Connection conn, int id) throws SQLException {
        if (id < 0) {
            return null;
        }
        final ResultSet rs = ScriptCommand.getLobStream(conn, "CDATA", id);
        return new Reader(){
            private Reader current;
            private boolean closed;

            @Override
            public int read() throws IOException {
                try {
                    while (true) {
                        int x;
                        if (this.current == null) {
                            if (this.closed) {
                                return -1;
                            }
                            if (!rs.next()) {
                                this.close();
                                return -1;
                            }
                            this.current = rs.getCharacterStream(1);
                            this.current = new BufferedReader(this.current);
                        }
                        if ((x = this.current.read()) >= 0) {
                            return x;
                        }
                        this.current = null;
                    }
                }
                catch (SQLException e) {
                    throw DataUtils.convertToIOException(e);
                }
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw DataUtils.convertToIOException(e);
                }
            }

            @Override
            public int read(char[] buffer, int off, int len) throws IOException {
                int i;
                if (len == 0) {
                    return 0;
                }
                int c = this.read();
                if (c == -1) {
                    return -1;
                }
                buffer[off] = (char)c;
                for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                    buffer[off + i] = (char)c;
                }
                return i;
            }
        };
    }

    private static ResultSet getLobStream(Connection conn, String column, int id) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT " + column + " FROM SYSTEM_LOB_STREAM WHERE ID=? ORDER BY PART");
        prep.setInt(1, id);
        return prep.executeQuery();
    }

    private void reset() {
        this.result = null;
        this.buffer = null;
        this.lineSeparatorString = System.lineSeparator();
        this.lineSeparator = this.lineSeparatorString.getBytes(this.charset);
    }

    private boolean excludeSchema(Schema schema) {
        if (this.schemaNames != null && !this.schemaNames.contains(schema.getName())) {
            return true;
        }
        if (this.tables != null) {
            for (Table table : schema.getAllTablesAndViews(this.session)) {
                if (!this.tables.contains(table)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean excludeTable(Table table) {
        return this.tables != null && !this.tables.contains(table);
    }

    private void add(String s, boolean insert) throws IOException {
        if (s == null) {
            return;
        }
        if (this.lineSeparator.length > 1 || this.lineSeparator[0] != 10) {
            s = StringUtils.replaceAll(s, "\n", this.lineSeparatorString);
        }
        s = s + ";";
        if (this.out != null) {
            byte[] buff = s.getBytes(this.charset);
            int len = MathUtils.roundUpInt(buff.length + this.lineSeparator.length, 16);
            this.buffer = Utils.copy(buff, this.buffer);
            if (len > this.buffer.length) {
                this.buffer = new byte[len];
            }
            System.arraycopy(buff, 0, this.buffer, 0, buff.length);
            for (int i = buff.length; i < len - this.lineSeparator.length; ++i) {
                this.buffer[i] = 32;
            }
            int j = 0;
            int i = len - this.lineSeparator.length;
            while (i < len) {
                this.buffer[i] = this.lineSeparator[j];
                ++i;
                ++j;
            }
            this.out.write(this.buffer, 0, len);
            if (!insert) {
                this.result.addRow(ValueVarchar.get(s));
            }
        } else {
            this.result.addRow(ValueVarchar.get(s));
        }
    }

    public void setSimple(boolean simple) {
        this.simple = simple;
    }

    public void setWithColumns(boolean withColumns) {
        this.withColumns = withColumns;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public int getType() {
        return 65;
    }
}

