/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.h2.command.Prepared;
import org.h2.command.dml.DataChangeStatement;
import org.h2.command.dml.SetClauseList;
import org.h2.command.dml.Update;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.DataChangeDeltaTable;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.HasSQL;
import org.h2.util.Utils;
import org.h2.value.Value;

public final class MergeUsing
extends DataChangeStatement {
    TableFilter targetTableFilter;
    TableFilter sourceTableFilter;
    Expression onCondition;
    private ArrayList<When> when = Utils.newSmallArrayList();
    private final HashSet<Long> targetRowidsRemembered = new HashSet();

    public MergeUsing(SessionLocal session, TableFilter targetTableFilter) {
        super(session);
        this.targetTableFilter = targetTableFilter;
    }

    @Override
    public long update(ResultTarget deltaChangeCollector, DataChangeDeltaTable.ResultOption deltaChangeCollectionMode) {
        boolean hasRowId;
        long countUpdatedRows = 0L;
        this.targetRowidsRemembered.clear();
        this.checkRights();
        this.setCurrentRowNumber(0L);
        this.sourceTableFilter.startQuery(this.session);
        this.sourceTableFilter.reset();
        Table table = this.targetTableFilter.getTable();
        table.fire(this.session, this.evaluateTriggerMasks(), true);
        table.lock(this.session, 1);
        this.setCurrentRowNumber(0L);
        long count = 0L;
        Row previousSource = null;
        Row missedSource = null;
        boolean bl = hasRowId = table.getRowIdColumn() != null;
        while (this.sourceTableFilter.next()) {
            Row source = this.sourceTableFilter.get();
            if (missedSource != null) {
                if (source != missedSource) {
                    Row backupTarget = this.targetTableFilter.get();
                    this.sourceTableFilter.set(missedSource);
                    this.targetTableFilter.set(table.getNullRow());
                    countUpdatedRows += (long)this.merge(true, deltaChangeCollector, deltaChangeCollectionMode);
                    this.sourceTableFilter.set(source);
                    this.targetTableFilter.set(backupTarget);
                    ++count;
                }
                missedSource = null;
            }
            this.setCurrentRowNumber(count + 1L);
            boolean nullRow = this.targetTableFilter.isNullRow();
            if (!nullRow) {
                long targetRowId;
                Row targetRow = this.targetTableFilter.get();
                if (table.isRowLockable()) {
                    Row lockedRow = table.lockRow(this.session, targetRow);
                    if (lockedRow == null) {
                        if (previousSource == source) continue;
                        missedSource = source;
                        continue;
                    }
                    if (!targetRow.hasSharedData(lockedRow)) {
                        targetRow = lockedRow;
                        this.targetTableFilter.set(targetRow);
                        if (!this.onCondition.getBooleanValue(this.session)) {
                            if (previousSource == source) continue;
                            missedSource = source;
                            continue;
                        }
                    }
                }
                if (hasRowId && !this.targetRowidsRemembered.add(targetRowId = targetRow.getKey())) {
                    throw DbException.get(23505, "Merge using ON column expression, duplicate _ROWID_ target record already processed:_ROWID_=" + targetRowId + ":in:" + this.targetTableFilter.getTable());
                }
            }
            countUpdatedRows += (long)this.merge(nullRow, deltaChangeCollector, deltaChangeCollectionMode);
            ++count;
            previousSource = source;
        }
        if (missedSource != null) {
            this.sourceTableFilter.set(missedSource);
            this.targetTableFilter.set(table.getNullRow());
            countUpdatedRows += (long)this.merge(true, deltaChangeCollector, deltaChangeCollectionMode);
        }
        this.targetRowidsRemembered.clear();
        table.fire(this.session, this.evaluateTriggerMasks(), false);
        return countUpdatedRows;
    }

    private int merge(boolean nullRow, ResultTarget deltaChangeCollector, DataChangeDeltaTable.ResultOption deltaChangeCollectionMode) {
        for (When w : this.when) {
            Expression condition;
            if (w.getClass() == WhenNotMatched.class != nullRow || (condition = w.andCondition) != null && !condition.getBooleanValue(this.session)) continue;
            w.merge(this.session, deltaChangeCollector, deltaChangeCollectionMode);
            return 1;
        }
        return 0;
    }

    private int evaluateTriggerMasks() {
        int masks = 0;
        for (When w : this.when) {
            masks |= w.evaluateTriggerMasks();
        }
        return masks;
    }

    private void checkRights() {
        for (When w : this.when) {
            w.checkRights();
        }
        this.session.getUser().checkTableRight(this.targetTableFilter.getTable(), 1);
        this.session.getUser().checkTableRight(this.sourceTableFilter.getTable(), 1);
    }

    @Override
    public String getPlanSQL(int sqlFlags) {
        StringBuilder builder = new StringBuilder("MERGE INTO ");
        this.targetTableFilter.getPlanSQL(builder, false, sqlFlags);
        builder.append('\n').append("USING ");
        this.sourceTableFilter.getPlanSQL(builder, false, sqlFlags);
        for (When w : this.when) {
            w.getSQL(builder.append('\n'), sqlFlags);
        }
        return builder.toString();
    }

    @Override
    void doPrepare() {
        this.onCondition.addFilterConditions(this.sourceTableFilter);
        this.onCondition.addFilterConditions(this.targetTableFilter);
        this.onCondition.mapColumns(this.sourceTableFilter, 0, 0);
        this.onCondition.mapColumns(this.targetTableFilter, 0, 0);
        this.onCondition = this.onCondition.optimize(this.session);
        this.onCondition.createIndexConditions(this.session, this.targetTableFilter);
        TableFilter[] filters = new TableFilter[]{this.sourceTableFilter, this.targetTableFilter};
        this.sourceTableFilter.addJoin(this.targetTableFilter, true, this.onCondition);
        PlanItem item = this.sourceTableFilter.getBestPlanItem(this.session, filters, 0, new AllColumnsForPlan(filters));
        this.sourceTableFilter.setPlanItem(item);
        this.sourceTableFilter.prepare();
        boolean hasFinalNotMatched = false;
        boolean hasFinalMatched = false;
        Iterator<When> i = this.when.iterator();
        while (i.hasNext()) {
            When w = i.next();
            if (!w.prepare(this.session)) {
                i.remove();
                continue;
            }
            if (w.getClass() == WhenNotMatched.class) {
                if (hasFinalNotMatched) {
                    i.remove();
                    continue;
                }
                if (w.andCondition != null) continue;
                hasFinalNotMatched = true;
                continue;
            }
            if (hasFinalMatched) {
                i.remove();
                continue;
            }
            if (w.andCondition != null) continue;
            hasFinalMatched = true;
        }
    }

    public void setSourceTableFilter(TableFilter sourceTableFilter) {
        this.sourceTableFilter = sourceTableFilter;
    }

    public TableFilter getSourceTableFilter() {
        return this.sourceTableFilter;
    }

    public void setOnCondition(Expression condition) {
        this.onCondition = condition;
    }

    public Expression getOnCondition() {
        return this.onCondition;
    }

    public ArrayList<When> getWhen() {
        return this.when;
    }

    public void addWhen(When w) {
        this.when.add(w);
    }

    @Override
    public Table getTable() {
        return this.targetTableFilter.getTable();
    }

    public void setTargetTableFilter(TableFilter targetTableFilter) {
        this.targetTableFilter = targetTableFilter;
    }

    public TableFilter getTargetTableFilter() {
        return this.targetTableFilter;
    }

    @Override
    public int getType() {
        return 62;
    }

    @Override
    public String getStatementName() {
        return "MERGE";
    }

    @Override
    public void collectDependencies(HashSet<DbObject> dependencies) {
        dependencies.add(this.targetTableFilter.getTable());
        dependencies.add(this.sourceTableFilter.getTable());
        ExpressionVisitor visitor = ExpressionVisitor.getDependenciesVisitor(dependencies);
        for (When w : this.when) {
            w.collectDependencies(visitor);
        }
        this.onCondition.isEverything(visitor);
    }

    public final class WhenNotMatched
    extends When {
        private Column[] columns;
        private final Boolean overridingSystem;
        private final Expression[] values;

        public WhenNotMatched(Column[] columns, Boolean overridingSystem, Expression[] values) {
            this.columns = columns;
            this.overridingSystem = overridingSystem;
            this.values = values;
        }

        @Override
        void merge(SessionLocal session, ResultTarget deltaChangeCollector, DataChangeDeltaTable.ResultOption deltaChangeCollectionMode) {
            Table table = MergeUsing.this.targetTableFilter.getTable();
            Row newRow = table.getTemplateRow();
            Expression[] expr = this.values;
            int len = this.columns.length;
            for (int i = 0; i < len; ++i) {
                Column c = this.columns[i];
                int index = c.getColumnId();
                Expression e = expr[i];
                if (e == ValueExpression.DEFAULT) continue;
                try {
                    newRow.setValue(index, e.getValue(session));
                    continue;
                }
                catch (DbException ex) {
                    ex.addSQL("INSERT -- " + Prepared.getSimpleSQL(expr));
                    throw ex;
                }
            }
            table.convertInsertRow(session, newRow, this.overridingSystem);
            if (deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.NEW) {
                deltaChangeCollector.addRow((Value[])newRow.getValueList().clone());
            }
            if (!table.fireBeforeRow(session, null, newRow)) {
                table.addRow(session, newRow);
                DataChangeDeltaTable.collectInsertedFinalRow(session, table, deltaChangeCollector, deltaChangeCollectionMode, newRow);
                table.fireAfterRow(session, null, newRow, false);
            } else {
                DataChangeDeltaTable.collectInsertedFinalRow(session, table, deltaChangeCollector, deltaChangeCollectionMode, newRow);
            }
        }

        @Override
        boolean prepare(SessionLocal session) {
            boolean result = super.prepare(session);
            TableFilter targetTableFilter = MergeUsing.this.targetTableFilter;
            TableFilter sourceTableFilter = MergeUsing.this.sourceTableFilter;
            if (this.columns == null) {
                this.columns = targetTableFilter.getTable().getColumns();
            }
            if (this.values.length != this.columns.length) {
                throw DbException.get(21002);
            }
            int len = this.values.length;
            for (int i = 0; i < len; ++i) {
                Expression e = this.values[i];
                e.mapColumns(targetTableFilter, 0, 0);
                e.mapColumns(sourceTableFilter, 0, 0);
                e = e.optimize(session);
                if (e instanceof Parameter) {
                    ((Parameter)e).setColumn(this.columns[i]);
                }
                this.values[i] = e;
            }
            return result;
        }

        @Override
        int evaluateTriggerMasks() {
            return 1;
        }

        @Override
        void checkRights() {
            MergeUsing.this.getSession().getUser().checkTableRight(MergeUsing.this.targetTableFilter.getTable(), 4);
        }

        @Override
        void collectDependencies(ExpressionVisitor visitor) {
            super.collectDependencies(visitor);
            for (Expression e : this.values) {
                e.isEverything(visitor);
            }
        }

        @Override
        public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
            super.getSQL(builder, sqlFlags).append("INSERT (");
            Column.writeColumns(builder, this.columns, sqlFlags).append(")\nVALUES (");
            return Expression.writeExpressions(builder, this.values, sqlFlags).append(')');
        }
    }

    public final class WhenMatchedThenUpdate
    extends When {
        private SetClauseList setClauseList;

        public void setSetClauseList(SetClauseList setClauseList) {
            this.setClauseList = setClauseList;
        }

        @Override
        void merge(SessionLocal session, ResultTarget deltaChangeCollector, DataChangeDeltaTable.ResultOption deltaChangeCollectionMode) {
            TableFilter targetTableFilter = MergeUsing.this.targetTableFilter;
            Table table = targetTableFilter.getTable();
            try (LocalResult rows = LocalResult.forTable(session, table);){
                this.setClauseList.prepareUpdate(table, session, deltaChangeCollector, deltaChangeCollectionMode, rows, targetTableFilter.get(), false);
                Update.doUpdate(MergeUsing.this, session, table, rows);
            }
        }

        @Override
        boolean prepare(SessionLocal session) {
            boolean result = super.prepare(session);
            this.setClauseList.mapAndOptimize(session, MergeUsing.this.targetTableFilter, MergeUsing.this.sourceTableFilter);
            return result;
        }

        @Override
        int evaluateTriggerMasks() {
            return 2;
        }

        @Override
        void checkRights() {
            MergeUsing.this.getSession().getUser().checkTableRight(MergeUsing.this.targetTableFilter.getTable(), 8);
        }

        @Override
        void collectDependencies(ExpressionVisitor visitor) {
            super.collectDependencies(visitor);
            this.setClauseList.isEverything(visitor);
        }

        @Override
        public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
            return this.setClauseList.getSQL(super.getSQL(builder, sqlFlags).append("UPDATE"), sqlFlags);
        }
    }

    public final class WhenMatchedThenDelete
    extends When {
        @Override
        void merge(SessionLocal session, ResultTarget deltaChangeCollector, DataChangeDeltaTable.ResultOption deltaChangeCollectionMode) {
            TableFilter targetTableFilter = MergeUsing.this.targetTableFilter;
            Table table = targetTableFilter.getTable();
            Row row = targetTableFilter.get();
            if (deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.OLD) {
                deltaChangeCollector.addRow(row.getValueList());
            }
            if (!table.fireRow() || !table.fireBeforeRow(session, row, null)) {
                table.removeRow(session, row);
                table.fireAfterRow(session, row, null, false);
            }
        }

        @Override
        int evaluateTriggerMasks() {
            return 4;
        }

        @Override
        void checkRights() {
            MergeUsing.this.getSession().getUser().checkTableRight(MergeUsing.this.targetTableFilter.getTable(), 2);
        }

        @Override
        public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
            return super.getSQL(builder, sqlFlags).append("DELETE");
        }
    }

    public abstract class When
    implements HasSQL {
        Expression andCondition;

        When() {
        }

        public void setAndCondition(Expression andCondition) {
            this.andCondition = andCondition;
        }

        abstract void merge(SessionLocal var1, ResultTarget var2, DataChangeDeltaTable.ResultOption var3);

        boolean prepare(SessionLocal session) {
            if (this.andCondition != null) {
                this.andCondition.mapColumns(MergeUsing.this.targetTableFilter, 0, 0);
                this.andCondition.mapColumns(MergeUsing.this.sourceTableFilter, 0, 0);
                this.andCondition = this.andCondition.optimize(session);
                if (this.andCondition.isConstant()) {
                    if (this.andCondition.getBooleanValue(session)) {
                        this.andCondition = null;
                    } else {
                        return false;
                    }
                }
            }
            return true;
        }

        abstract int evaluateTriggerMasks();

        abstract void checkRights();

        void collectDependencies(ExpressionVisitor visitor) {
            if (this.andCondition != null) {
                this.andCondition.isEverything(visitor);
            }
        }

        @Override
        public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
            builder.append("WHEN ");
            if (this.getClass() == WhenNotMatched.class) {
                builder.append("NOT ");
            }
            builder.append("MATCHED");
            if (this.andCondition != null) {
                this.andCondition.getUnenclosedSQL(builder.append(" AND "), sqlFlags);
            }
            return builder.append(" THEN ");
        }
    }
}

