/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.command.Command;
import org.h2.command.dml.CommandWithValues;
import org.h2.command.dml.Update;
import org.h2.command.query.Query;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.mvstore.db.MVPrimaryIndex;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.DataChangeDeltaTable;
import org.h2.table.Table;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public final class Merge
extends CommandWithValues {
    private boolean isReplace;
    private Table table;
    private Column[] columns;
    private Column[] keys;
    private Query query;
    private Update update;

    public Merge(SessionLocal session, boolean isReplace) {
        super(session);
        this.isReplace = isReplace;
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columns) {
        this.columns = columns;
    }

    public void setKeys(Column[] keys) {
        this.keys = keys;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    @Override
    public long update(ResultTarget deltaChangeCollector, DataChangeDeltaTable.ResultOption deltaChangeCollectionMode) {
        long count = 0L;
        this.session.getUser().checkTableRight(this.table, 4);
        this.session.getUser().checkTableRight(this.table, 8);
        this.setCurrentRowNumber(0L);
        if (!this.valuesExpressionList.isEmpty()) {
            int size = this.valuesExpressionList.size();
            for (int x = 0; x < size; ++x) {
                this.setCurrentRowNumber(x + 1);
                Expression[] expr = (Expression[])this.valuesExpressionList.get(x);
                Row newRow = this.table.getTemplateRow();
                int len = this.columns.length;
                for (int i = 0; i < len; ++i) {
                    Column c = this.columns[i];
                    int index = c.getColumnId();
                    Expression e = expr[i];
                    if (e == ValueExpression.DEFAULT) continue;
                    try {
                        newRow.setValue(index, e.getValue(this.session));
                        continue;
                    }
                    catch (DbException ex) {
                        throw this.setRow(ex, count, Merge.getSimpleSQL(expr));
                    }
                }
                count += (long)this.merge(newRow, expr, deltaChangeCollector, deltaChangeCollectionMode);
            }
        } else {
            this.query.setNeverLazy(true);
            ResultInterface rows = this.query.query(0L);
            this.table.fire(this.session, 3, true);
            this.table.lock(this.session, 1);
            while (rows.next()) {
                Value[] r = rows.currentRow();
                Row newRow = this.table.getTemplateRow();
                this.setCurrentRowNumber(count);
                for (int j = 0; j < this.columns.length; ++j) {
                    newRow.setValue(this.columns[j].getColumnId(), r[j]);
                }
                count += (long)this.merge(newRow, null, deltaChangeCollector, deltaChangeCollectionMode);
            }
            rows.close();
            this.table.fire(this.session, 3, false);
        }
        return count;
    }

    private int merge(Row row, Expression[] expressions, ResultTarget deltaChangeCollector, DataChangeDeltaTable.ResultOption deltaChangeCollectionMode) {
        long count;
        if (this.update == null) {
            count = 0L;
        } else {
            ArrayList<Parameter> k = this.update.getParameters();
            int j = 0;
            int l = this.columns.length;
            for (int i = 0; i < l; ++i) {
                Column col = this.columns[i];
                if (col.isGeneratedAlways()) {
                    if (expressions != null && expressions[i] == ValueExpression.DEFAULT) continue;
                    throw DbException.get(90154, col.getSQLWithTable(new StringBuilder(), 3).toString());
                }
                Value v = row.getValue(col.getColumnId());
                if (v == null) {
                    Expression defaultExpression = col.getEffectiveDefaultExpression();
                    v = defaultExpression != null ? defaultExpression.getValue(this.session) : ValueNull.INSTANCE;
                }
                k.get(j++).setValue(v);
            }
            for (Column col : this.keys) {
                Value v = row.getValue(col.getColumnId());
                if (v == null) {
                    throw DbException.get(90081, col.getTraceSQL());
                }
                k.get(j++).setValue(v);
            }
            count = this.update.update(deltaChangeCollector, deltaChangeCollectionMode);
        }
        if (count == 0L) {
            try {
                this.table.convertInsertRow(this.session, row, null);
                if (deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.NEW) {
                    deltaChangeCollector.addRow((Value[])row.getValueList().clone());
                }
                if (!this.table.fireBeforeRow(this.session, null, row)) {
                    this.table.lock(this.session, 1);
                    this.table.addRow(this.session, row);
                    DataChangeDeltaTable.collectInsertedFinalRow(this.session, this.table, deltaChangeCollector, deltaChangeCollectionMode, row);
                    this.table.fireAfterRow(this.session, null, row, false);
                } else {
                    DataChangeDeltaTable.collectInsertedFinalRow(this.session, this.table, deltaChangeCollector, deltaChangeCollectionMode, row);
                }
                return 1;
            }
            catch (DbException e) {
                Index index;
                if (e.getErrorCode() == 23505 && (index = (Index)e.getSource()) != null) {
                    boolean indexMatchesKeys;
                    Column[] indexColumns;
                    if (index instanceof MVPrimaryIndex) {
                        MVPrimaryIndex foundMV = (MVPrimaryIndex)index;
                        indexColumns = new Column[]{foundMV.getIndexColumns()[foundMV.getMainIndexColumn()].column};
                    } else {
                        indexColumns = index.getColumns();
                    }
                    if (indexColumns.length <= this.keys.length) {
                        indexMatchesKeys = true;
                        for (int i = 0; i < indexColumns.length; ++i) {
                            if (indexColumns[i] == this.keys[i]) continue;
                            indexMatchesKeys = false;
                            break;
                        }
                    } else {
                        indexMatchesKeys = false;
                    }
                    if (indexMatchesKeys) {
                        throw DbException.get(90131, this.table.getName());
                    }
                }
                throw e;
            }
        }
        if (count == 1L) {
            return this.isReplace ? 2 : 1;
        }
        throw DbException.get(23505, this.table.getTraceSQL());
    }

    @Override
    public String getPlanSQL(int sqlFlags) {
        StringBuilder builder = new StringBuilder(this.isReplace ? "REPLACE INTO " : "MERGE INTO ");
        this.table.getSQL(builder, sqlFlags).append('(');
        Column.writeColumns(builder, this.columns, sqlFlags);
        builder.append(')');
        if (!this.isReplace && this.keys != null) {
            builder.append(" KEY(");
            Column.writeColumns(builder, this.keys, sqlFlags);
            builder.append(')');
        }
        builder.append('\n');
        if (!this.valuesExpressionList.isEmpty()) {
            builder.append("VALUES ");
            int row = 0;
            for (Expression[] expr : this.valuesExpressionList) {
                if (row++ > 0) {
                    builder.append(", ");
                }
                Expression.writeExpressions(builder.append('('), expr, sqlFlags).append(')');
            }
        } else {
            builder.append(this.query.getPlanSQL(sqlFlags));
        }
        return builder.toString();
    }

    @Override
    void doPrepare() {
        Column[] idx;
        int i;
        if (this.columns == null) {
            this.columns = !this.valuesExpressionList.isEmpty() && ((Expression[])this.valuesExpressionList.get(0)).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (!this.valuesExpressionList.isEmpty()) {
            for (Expression[] expr : this.valuesExpressionList) {
                if (expr.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                for (i = 0; i < expr.length; ++i) {
                    Expression e = expr[i];
                    if (e == null) continue;
                    expr[i] = e.optimize(this.session);
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
        if (this.keys == null) {
            idx = this.table.getPrimaryKey();
            if (idx == null) {
                throw DbException.get(90057, "PRIMARY KEY");
            }
            this.keys = idx.getColumns();
        }
        if (this.isReplace) {
            idx = this.keys;
            int expr = idx.length;
            for (i = 0; i < expr; ++i) {
                Column key = idx[i];
                boolean found = false;
                for (Column column : this.columns) {
                    if (column.getColumnId() != key.getColumnId()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return;
            }
        }
        StringBuilder builder = this.table.getSQL(new StringBuilder("UPDATE "), 0).append(" SET ");
        boolean hasColumn = false;
        for (Column column : this.columns) {
            if (column.isGeneratedAlways()) continue;
            if (hasColumn) {
                builder.append(", ");
            }
            hasColumn = true;
            column.getSQL(builder, 0).append("=?");
        }
        if (!hasColumn) {
            throw DbException.getSyntaxError(this.sqlStatement, this.sqlStatement.length(), "Valid MERGE INTO statement with at least one updatable column");
        }
        Column.writeColumns(builder.append(" WHERE "), this.keys, " AND ", "=?", 0);
        this.update = (Update)this.session.prepare(builder.toString());
    }

    @Override
    public int getType() {
        return this.isReplace ? 63 : 62;
    }

    @Override
    public String getStatementName() {
        return this.isReplace ? "REPLACE" : "MERGE";
    }

    @Override
    public void collectDependencies(HashSet<DbObject> dependencies) {
        if (this.query != null) {
            this.query.collectDependencies(dependencies);
        }
    }
}

