/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.DefineCommand;
import org.h2.constraint.ConstraintActionType;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;

public class DropSchema
extends DefineCommand {
    private String schemaName;
    private boolean ifExists;
    private ConstraintActionType dropAction;

    public DropSchema(SessionLocal session) {
        super(session);
        this.dropAction = session.getDatabase().getSettings().dropRestrict ? ConstraintActionType.RESTRICT : ConstraintActionType.CASCADE;
    }

    public void setSchemaName(String name) {
        this.schemaName = name;
    }

    @Override
    public long update() {
        Database db = this.session.getDatabase();
        Schema schema = db.findSchema(this.schemaName);
        if (schema == null) {
            if (!this.ifExists) {
                throw DbException.get(90079, this.schemaName);
            }
        } else {
            ArrayList<SchemaObject> all;
            int size;
            this.session.getUser().checkSchemaOwner(schema);
            if (!schema.canDrop()) {
                throw DbException.get(90090, this.schemaName);
            }
            if (this.dropAction == ConstraintActionType.RESTRICT && !schema.isEmpty() && (size = (all = schema.getAll(null)).size()) > 0) {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        builder.append(", ");
                    }
                    builder.append(all.get(i).getName());
                }
                throw DbException.get(90107, this.schemaName, builder.toString());
            }
            db.removeDatabaseObject(this.session, schema);
        }
        return 0L;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    public void setDropAction(ConstraintActionType dropAction) {
        this.dropAction = dropAction;
    }

    @Override
    public int getType() {
        return 42;
    }
}

