/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaOwnerCommand;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.UserAggregate;

public class DropAggregate
extends SchemaOwnerCommand {
    private String name;
    private boolean ifExists;

    public DropAggregate(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    @Override
    long update(Schema schema) {
        Database db = this.session.getDatabase();
        UserAggregate aggregate = schema.findAggregate(this.name);
        if (aggregate == null) {
            if (!this.ifExists) {
                throw DbException.get(90132, this.name);
            }
        } else {
            db.removeSchemaObject(this.session, aggregate);
        }
        return 0L;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    @Override
    public int getType() {
        return 36;
    }
}

