/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaOwnerCommand;
import org.h2.command.ddl.SequenceOptions;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;

public class CreateSequence
extends SchemaOwnerCommand {
    private String sequenceName;
    private boolean ifNotExists;
    private SequenceOptions options;
    private boolean belongsToTable;

    public CreateSequence(SessionLocal session, Schema schema) {
        super(session, schema);
        this.transactional = true;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setOptions(SequenceOptions options) {
        this.options = options;
    }

    @Override
    long update(Schema schema) {
        Database db = this.session.getDatabase();
        if (schema.findSequence(this.sequenceName) != null) {
            if (this.ifNotExists) {
                return 0L;
            }
            throw DbException.get(90035, this.sequenceName);
        }
        int id = this.getObjectId();
        Sequence sequence = new Sequence(this.session, schema, id, this.sequenceName, this.options, this.belongsToTable);
        db.addSchemaObject(this.session, sequence);
        return 0L;
    }

    public void setBelongsToTable(boolean belongsToTable) {
        this.belongsToTable = belongsToTable;
    }

    @Override
    public int getType() {
        return 29;
    }
}

