/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.AlterDomainAddConstraint;
import org.h2.command.ddl.SchemaOwnerCommand;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.schema.Domain;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public class CreateDomain
extends SchemaOwnerCommand {
    private String typeName;
    private boolean ifNotExists;
    private TypeInfo dataType;
    private Domain parentDomain;
    private Expression defaultExpression;
    private Expression onUpdateExpression;
    private String comment;
    private ArrayList<AlterDomainAddConstraint> constraintCommands;

    public CreateDomain(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    public void setTypeName(String name) {
        this.typeName = name;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setDataType(TypeInfo dataType) {
        this.dataType = dataType;
    }

    public void setParentDomain(Domain parentDomain) {
        this.parentDomain = parentDomain;
    }

    public void setDefaultExpression(Expression defaultExpression) {
        this.defaultExpression = defaultExpression;
    }

    public void setOnUpdateExpression(Expression onUpdateExpression) {
        this.onUpdateExpression = onUpdateExpression;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    long update(Schema schema) {
        DataType builtIn;
        if (schema.findDomain(this.typeName) != null) {
            if (this.ifNotExists) {
                return 0L;
            }
            throw DbException.get(90119, this.typeName);
        }
        if (this.typeName.indexOf(32) < 0 && (builtIn = DataType.getTypeByName(this.typeName, this.session.getDatabase().getMode())) != null) {
            if (this.session.getDatabase().equalsIdentifiers(this.typeName, Value.getTypeName(builtIn.type))) {
                throw DbException.get(90119, this.typeName);
            }
            Table table = this.session.getDatabase().getFirstUserTable();
            if (table != null) {
                StringBuilder builder = new StringBuilder(this.typeName).append(" (");
                table.getSQL(builder, 3).append(')');
                throw DbException.get(90119, builder.toString());
            }
        }
        int id = this.getObjectId();
        Domain domain = new Domain(schema, id, this.typeName);
        domain.setDataType(this.dataType != null ? this.dataType : this.parentDomain.getDataType());
        domain.setDomain(this.parentDomain);
        domain.setDefaultExpression(this.session, this.defaultExpression);
        domain.setOnUpdateExpression(this.session, this.onUpdateExpression);
        domain.setComment(this.comment);
        schema.getDatabase().addSchemaObject(this.session, domain);
        if (this.constraintCommands != null) {
            for (AlterDomainAddConstraint command : this.constraintCommands) {
                command.update();
            }
        }
        return 0L;
    }

    @Override
    public int getType() {
        return 33;
    }

    public void addConstraintCommand(AlterDomainAddConstraint command) {
        if (this.constraintCommands == null) {
            this.constraintCommands = Utils.newSmallArrayList();
        }
        this.constraintCommands.add(command);
    }
}

