/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaOwnerCommand;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.value.Value;

public class CreateConstant
extends SchemaOwnerCommand {
    private String constantName;
    private Expression expression;
    private boolean ifNotExists;

    public CreateConstant(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    @Override
    long update(Schema schema) {
        Database db = this.session.getDatabase();
        if (schema.findConstant(this.constantName) != null) {
            if (this.ifNotExists) {
                return 0L;
            }
            throw DbException.get(90114, this.constantName);
        }
        int id = this.getObjectId();
        Constant constant = new Constant(schema, id, this.constantName);
        this.expression = this.expression.optimize(this.session);
        Value value = this.expression.getValue(this.session);
        constant.setValue(value);
        db.addSchemaObject(this.session, constant);
        return 0L;
    }

    public void setConstantName(String constantName) {
        this.constantName = constantName;
    }

    public void setExpression(Expression expr) {
        this.expression = expr;
    }

    @Override
    public int getType() {
        return 23;
    }
}

