/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.UserAggregate;

public class CreateAggregate
extends SchemaCommand {
    private String name;
    private String javaClassMethod;
    private boolean ifNotExists;
    private boolean force;

    public CreateAggregate(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    @Override
    public long update() {
        this.session.getUser().checkAdmin();
        Database db = this.session.getDatabase();
        Schema schema = this.getSchema();
        if (schema.findFunctionOrAggregate(this.name) != null) {
            if (!this.ifNotExists) {
                throw DbException.get(90076, this.name);
            }
        } else {
            int id = this.getObjectId();
            UserAggregate aggregate = new UserAggregate(schema, id, this.name, this.javaClassMethod, this.force);
            db.addSchemaObject(this.session, aggregate);
        }
        return 0L;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setJavaClassMethod(String string) {
        this.javaClassMethod = string;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    @Override
    public int getType() {
        return 22;
    }
}

