/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.AlterTableAddConstraint;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.DefineCommand;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.IndexColumn;

public abstract class CommandWithColumns
extends SchemaCommand {
    private ArrayList<DefineCommand> constraintCommands;
    private AlterTableAddConstraint primaryKey;

    protected CommandWithColumns(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    public abstract void addColumn(Column var1);

    public void addConstraintCommand(DefineCommand command) {
        AlterTableAddConstraint con;
        if (!(command instanceof CreateIndex) && (con = (AlterTableAddConstraint)command).getType() == 6 && this.setPrimaryKey(con)) {
            return;
        }
        this.getConstraintCommands().add(command);
    }

    protected void changePrimaryKeysToNotNull(ArrayList<Column> columns) {
        if (this.primaryKey != null) {
            IndexColumn[] pkColumns = this.primaryKey.getIndexColumns();
            for (Column c : columns) {
                for (IndexColumn idxCol : pkColumns) {
                    if (!c.getName().equals(idxCol.columnName)) continue;
                    c.setNullable(false);
                }
            }
        }
    }

    protected void createConstraints() {
        if (this.constraintCommands != null) {
            for (DefineCommand command : this.constraintCommands) {
                command.setTransactional(this.transactional);
                command.update();
            }
        }
    }

    protected ArrayList<Sequence> generateSequences(ArrayList<Column> columns, boolean temporary) {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>(columns == null ? 0 : columns.size());
        if (columns != null) {
            for (Column c : columns) {
                Sequence seq;
                if (c.hasIdentityOptions()) {
                    int objId = this.session.getDatabase().allocateObjectId();
                    c.initializeSequence(this.session, this.getSchema(), objId, temporary);
                    if (!"''".equals(this.session.getDatabase().getCluster())) {
                        throw DbException.getUnsupportedException("CLUSTERING && identity columns");
                    }
                }
                if ((seq = c.getSequence()) == null) continue;
                sequences.add(seq);
            }
        }
        return sequences;
    }

    private ArrayList<DefineCommand> getConstraintCommands() {
        if (this.constraintCommands == null) {
            this.constraintCommands = new ArrayList();
        }
        return this.constraintCommands;
    }

    private boolean setPrimaryKey(AlterTableAddConstraint primaryKey) {
        if (this.primaryKey != null) {
            IndexColumn[] oldColumns = this.primaryKey.getIndexColumns();
            IndexColumn[] newColumns = primaryKey.getIndexColumns();
            int len = newColumns.length;
            if (len != oldColumns.length) {
                throw DbException.get(90017);
            }
            for (int i = 0; i < len; ++i) {
                if (newColumns[i].columnName.equals(oldColumns[i].columnName)) continue;
                throw DbException.get(90017);
            }
            if (this.primaryKey.getConstraintName() != null) {
                return true;
            }
            this.constraintCommands.remove(this.primaryKey);
        }
        this.primaryKey = primaryKey;
        return false;
    }

    public AlterTableAddConstraint getPrimaryKey() {
        return this.primaryKey;
    }
}

