/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.Arrays;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.index.Cursor;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.value.DataType;
import org.h2.value.Value;

public class Analyze
extends DefineCommand {
    private int sampleRows;
    private Table table;

    public Analyze(SessionLocal session) {
        super(session);
        this.sampleRows = session.getDatabase().getSettings().analyzeSample;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public long update() {
        this.session.getUser().checkAdmin();
        Database db = this.session.getDatabase();
        if (this.table != null) {
            Analyze.analyzeTable(this.session, this.table, this.sampleRows, true);
        } else {
            for (Schema schema : db.getAllSchemasNoMeta()) {
                for (Table table : schema.getAllTablesAndViews(null)) {
                    Analyze.analyzeTable(this.session, table, this.sampleRows, true);
                }
            }
        }
        return 0L;
    }

    public static void analyzeTable(SessionLocal session, Table table, int sample, boolean manual) {
        if (table.getTableType() != TableType.TABLE || table.isHidden() || session == null || !manual && (session.getDatabase().isSysTableLocked() || table.hasSelectTrigger()) || table.isTemporary() && !table.isGlobalTemporary() && session.findLocalTempTable(table.getName()) == null || table.isLockedExclusively() && !table.isLockedExclusivelyBy(session) || !session.getUser().hasTableRight(table, 1) || session.getCancel() != 0L) {
            return;
        }
        table.lock(session, 0);
        Column[] columns = table.getColumns();
        int columnCount = columns.length;
        if (columnCount == 0) {
            return;
        }
        Cursor cursor = table.getScanIndex(session).find(session, null, null);
        if (cursor.next()) {
            SelectivityData[] array = new SelectivityData[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                Column col = columns[i];
                if (DataType.isLargeObject(col.getType().getValueType())) continue;
                array[i] = new SelectivityData();
            }
            long rowNumber = 0L;
            do {
                Row row = cursor.get();
                for (int i = 0; i < columnCount; ++i) {
                    SelectivityData selectivity = array[i];
                    if (selectivity == null) continue;
                    selectivity.add(row.getValue(i));
                }
            } while ((sample <= 0 || ++rowNumber < (long)sample) && cursor.next());
            for (int i = 0; i < columnCount; ++i) {
                SelectivityData selectivity = array[i];
                if (selectivity == null) continue;
                columns[i].setSelectivity(selectivity.getSelectivity(rowNumber));
            }
        } else {
            for (int i = 0; i < columnCount; ++i) {
                columns[i].setSelectivity(0);
            }
        }
        session.getDatabase().updateMeta(session, table);
    }

    public void setTop(int top) {
        this.sampleRows = top;
    }

    @Override
    public int getType() {
        return 21;
    }

    private static final class SelectivityData {
        private long distinctCount;
        private int size;
        private int[] elements = new int[8];
        private boolean zeroElement;
        private int maxSize = 7;

        SelectivityData() {
        }

        void add(Value v) {
            int hash;
            int currentSize = this.currentSize();
            if (currentSize >= 10000) {
                this.size = 0;
                Arrays.fill(this.elements, 0);
                this.zeroElement = false;
                this.distinctCount += (long)currentSize;
            }
            if ((hash = v.hashCode()) == 0) {
                this.zeroElement = true;
            } else {
                if (this.size >= this.maxSize) {
                    this.rehash();
                }
                this.add(hash);
            }
        }

        int getSelectivity(long count) {
            int s;
            if (count == 0L) {
                s = 0;
            } else {
                s = (int)(100L * (this.distinctCount + (long)this.currentSize()) / count);
                if (s <= 0) {
                    s = 1;
                }
            }
            return s;
        }

        private int currentSize() {
            int size = this.size;
            if (this.zeroElement) {
                ++size;
            }
            return size;
        }

        private void add(int element) {
            int len = this.elements.length;
            int mask = len - 1;
            int index = element & mask;
            int plus = 1;
            do {
                int k;
                if ((k = this.elements[index]) == 0) {
                    ++this.size;
                    this.elements[index] = element;
                    return;
                }
                if (k == element) {
                    return;
                }
                index = index + plus++ & mask;
            } while (plus <= len);
        }

        private void rehash() {
            this.size = 0;
            int[] oldElements = this.elements;
            int len = oldElements.length << 1;
            this.elements = new int[len];
            this.maxSize = (int)((long)len * 90L / 100L);
            for (int k : oldElements) {
                if (k == 0) continue;
                this.add(k);
            }
        }
    }
}

