/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.CreateUser;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.engine.User;
import org.h2.expression.Expression;
import org.h2.message.DbException;

public class AlterUser
extends DefineCommand {
    private int type;
    private User user;
    private String newName;
    private Expression password;
    private Expression salt;
    private Expression hash;
    private boolean admin;

    public AlterUser(SessionLocal session) {
        super(session);
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public void setSalt(Expression e) {
        this.salt = e;
    }

    public void setHash(Expression e) {
        this.hash = e;
    }

    public void setPassword(Expression password) {
        this.password = password;
    }

    @Override
    public long update() {
        Database db = this.session.getDatabase();
        switch (this.type) {
            case 19: {
                if (this.user != this.session.getUser()) {
                    this.session.getUser().checkAdmin();
                }
                if (this.hash != null && this.salt != null) {
                    CreateUser.setSaltAndHash(this.user, this.session, this.salt, this.hash);
                    break;
                }
                CreateUser.setPassword(this.user, this.session, this.password);
                break;
            }
            case 18: {
                this.session.getUser().checkAdmin();
                if (db.findUser(this.newName) != null || this.newName.equals(this.user.getName())) {
                    throw DbException.get(90033, this.newName);
                }
                db.renameDatabaseObject(this.session, this.user, this.newName);
                break;
            }
            case 17: {
                this.session.getUser().checkAdmin();
                this.user.setAdmin(this.admin);
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.type);
            }
        }
        db.updateMeta(this.session, this.user);
        return 0L;
    }

    @Override
    public int getType() {
        return this.type;
    }
}

