/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.schema.Schema;

public class AlterIndexRename
extends DefineCommand {
    private boolean ifExists;
    private Schema oldSchema;
    private String oldIndexName;
    private String newIndexName;

    public AlterIndexRename(SessionLocal session) {
        super(session);
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setOldSchema(Schema old) {
        this.oldSchema = old;
    }

    public void setOldName(String name) {
        this.oldIndexName = name;
    }

    public void setNewName(String name) {
        this.newIndexName = name;
    }

    @Override
    public long update() {
        Database db = this.session.getDatabase();
        Index oldIndex = this.oldSchema.findIndex(this.session, this.oldIndexName);
        if (oldIndex == null) {
            if (!this.ifExists) {
                throw DbException.get(42112, this.newIndexName);
            }
            return 0L;
        }
        if (this.oldSchema.findIndex(this.session, this.newIndexName) != null || this.newIndexName.equals(this.oldIndexName)) {
            throw DbException.get(42111, this.newIndexName);
        }
        this.session.getUser().checkTableRight(oldIndex.getTable(), 32);
        db.renameSchemaObject(this.session, oldIndex, this.newIndexName);
        return 0L;
    }

    @Override
    public int getType() {
        return 1;
    }
}

