/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.h2.command.Command;
import org.h2.command.Token;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.ResultInterface;
import org.h2.table.TableView;

public abstract class Prepared {
    protected SessionLocal session;
    protected String sqlStatement;
    protected ArrayList<Token> sqlTokens;
    protected boolean create = true;
    protected ArrayList<Parameter> parameters;
    private boolean withParamValues;
    protected boolean prepareAlways;
    private long modificationMetaId;
    private Command command;
    private int persistedObjectId;
    private long currentRowNumber;
    private int rowScanCount;
    private List<TableView> cteCleanups;

    public Prepared(SessionLocal session) {
        this.session = session;
        this.modificationMetaId = session.getDatabase().getModificationMetaId();
    }

    public abstract boolean isTransactional();

    public abstract ResultInterface queryMeta();

    public abstract int getType();

    public boolean isReadOnly() {
        return false;
    }

    public boolean needRecompile() {
        Database db = this.session.getDatabase();
        if (db == null) {
            throw DbException.get(90067, "database closed");
        }
        return this.prepareAlways || this.modificationMetaId < db.getModificationMetaId() || db.getSettings().recompileAlways;
    }

    long getModificationMetaId() {
        return this.modificationMetaId;
    }

    void setModificationMetaId(long id) {
        this.modificationMetaId = id;
    }

    public void setParameterList(ArrayList<Parameter> parameters) {
        this.parameters = parameters;
    }

    public ArrayList<Parameter> getParameters() {
        return this.parameters;
    }

    public boolean isWithParamValues() {
        return this.withParamValues;
    }

    public void setWithParamValues(boolean withParamValues) {
        this.withParamValues = withParamValues;
    }

    protected void checkParameters() {
        if (this.persistedObjectId < 0) {
            this.persistedObjectId ^= 0xFFFFFFFF;
        }
        if (this.parameters != null) {
            for (Parameter param : this.parameters) {
                param.checkSet();
            }
        }
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public boolean isQuery() {
        return false;
    }

    public void prepare() {
    }

    public long update() {
        throw DbException.get(90001);
    }

    public ResultInterface query(long maxrows) {
        throw DbException.get(90002);
    }

    public final void setSQL(String sql, ArrayList<Token> sqlTokens) {
        this.sqlStatement = sql;
        this.sqlTokens = sqlTokens;
    }

    public final String getSQL() {
        return this.sqlStatement;
    }

    public final ArrayList<Token> getSQLTokens() {
        return this.sqlTokens;
    }

    public int getPersistedObjectId() {
        int id = this.persistedObjectId;
        return id >= 0 ? id : 0;
    }

    protected int getObjectId() {
        int id = this.persistedObjectId;
        if (id == 0) {
            id = this.session.getDatabase().allocateObjectId();
        } else if (id < 0) {
            throw DbException.getInternalError("Prepared.getObjectId() was called before");
        }
        this.persistedObjectId ^= 0xFFFFFFFF;
        return id;
    }

    public String getPlanSQL(int sqlFlags) {
        return null;
    }

    public void checkCanceled() {
        Command c;
        this.session.checkCanceled();
        Command command = c = this.command != null ? this.command : this.session.getCurrentCommand();
        if (c != null) {
            c.checkCanceled();
        }
    }

    public void setPersistedObjectId(int i) {
        this.persistedObjectId = i;
        this.create = false;
    }

    public void setSession(SessionLocal currentSession) {
        this.session = currentSession;
    }

    void trace(long startTimeNanos, long rowCount) {
        long deltaTimeNanos;
        if (this.session.getTrace().isInfoEnabled() && startTimeNanos > 0L) {
            deltaTimeNanos = System.nanoTime() - startTimeNanos;
            String params = Trace.formatParams(this.parameters);
            this.session.getTrace().infoSQL(this.sqlStatement, params, rowCount, deltaTimeNanos / 1000000L);
        }
        if (this.session.getDatabase().getQueryStatistics() && startTimeNanos != 0L) {
            deltaTimeNanos = System.nanoTime() - startTimeNanos;
            this.session.getDatabase().getQueryStatisticsData().update(this.toString(), deltaTimeNanos, rowCount);
        }
    }

    public void setPrepareAlways(boolean prepareAlways) {
        this.prepareAlways = prepareAlways;
    }

    public void setCurrentRowNumber(long rowNumber) {
        if ((++this.rowScanCount & 0x7F) == 0) {
            this.checkCanceled();
        }
        this.currentRowNumber = rowNumber;
        this.setProgress();
    }

    public long getCurrentRowNumber() {
        return this.currentRowNumber;
    }

    private void setProgress() {
        if ((this.currentRowNumber & 0x7FL) == 0L) {
            this.session.getDatabase().setProgress(7, this.sqlStatement, this.currentRowNumber, 0L);
        }
    }

    public String toString() {
        return this.sqlStatement;
    }

    public static String getSimpleSQL(Expression[] list) {
        return Expression.writeExpressions(new StringBuilder(), list, 3).toString();
    }

    protected DbException setRow(DbException e, long rowId, String values) {
        StringBuilder buff = new StringBuilder();
        if (this.sqlStatement != null) {
            buff.append(this.sqlStatement);
        }
        buff.append(" -- ");
        if (rowId > 0L) {
            buff.append("row #").append(rowId + 1L).append(' ');
        }
        buff.append('(').append(values).append(')');
        return e.addSQL(buff.toString());
    }

    public boolean isCacheable() {
        return false;
    }

    public List<TableView> getCteCleanups() {
        return this.cteCleanups;
    }

    public void setCteCleanups(List<TableView> cteCleanups) {
        this.cteCleanups = cteCleanups;
    }

    public final SessionLocal getSession() {
        return this.session;
    }

    public void collectDependencies(HashSet<DbObject> dependencies) {
    }
}

