/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Set;
import org.h2.command.CommandInterface;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.engine.SessionLocal;
import org.h2.expression.ParameterInterface;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.ResultInterface;
import org.h2.result.ResultWithGeneratedKeys;
import org.h2.result.ResultWithPaddedStrings;
import org.h2.util.Utils;

public abstract class Command
implements CommandInterface {
    protected final SessionLocal session;
    protected long startTimeNanos;
    private final Trace trace;
    private volatile boolean cancel;
    private final String sql;
    private boolean canReuse;

    Command(SessionLocal session, String sql) {
        this.session = session;
        this.sql = sql;
        this.trace = session.getDatabase().getTrace(0);
    }

    public abstract boolean isTransactional();

    @Override
    public abstract boolean isQuery();

    @Override
    public abstract ArrayList<? extends ParameterInterface> getParameters();

    public abstract boolean isReadOnly();

    public abstract ResultInterface queryMeta();

    public abstract ResultWithGeneratedKeys update(Object var1);

    public abstract ResultInterface query(long var1);

    @Override
    public final ResultInterface getMetaData() {
        return this.queryMeta();
    }

    void start() {
        if (this.trace.isInfoEnabled() || this.session.getDatabase().getQueryStatistics()) {
            this.startTimeNanos = Utils.currentNanoTime();
        }
    }

    void setProgress(int state) {
        this.session.getDatabase().setProgress(state, this.sql, 0L, 0L);
    }

    protected void checkCanceled() {
        if (this.cancel) {
            this.cancel = false;
            throw DbException.get(57014);
        }
    }

    @Override
    public void stop() {
        long timeMillis;
        this.commitIfNonTransactional();
        if (this.isTransactional() && this.session.getAutoCommit()) {
            this.session.commit(false);
        }
        if (this.trace.isInfoEnabled() && this.startTimeNanos != 0L && (timeMillis = (System.nanoTime() - this.startTimeNanos) / 1000000L) > 100L) {
            this.trace.info("slow query: {0} ms", timeMillis);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultInterface executeQuery(long maxrows, boolean scrollable) {
        this.startTimeNanos = 0L;
        long start = 0L;
        Database database = this.session.getDatabase();
        this.session.waitIfExclusiveModeEnabled();
        boolean callStop = true;
        SessionLocal sessionLocal = this.session;
        synchronized (sessionLocal) {
            this.session.startStatementWithinTransaction(this);
            Session oldSession = this.session.setThreadLocalSession();
            while (true) {
                ResultInterface result;
                block18: {
                    database.checkPowerOff();
                    result = this.query(maxrows);
                    boolean bl = callStop = !result.isLazy();
                    if (database.getMode().charPadding != Mode.CharPadding.IN_RESULT_SETS) break block18;
                    ResultInterface resultInterface = ResultWithPaddedStrings.get(result);
                    return resultInterface;
                }
                ResultInterface resultInterface = result;
                return resultInterface;
                {
                    catch (DbException e) {
                        if (this.isCurrentCommandADefineCommand()) {
                            throw e;
                        }
                        start = this.filterConcurrentUpdate(e, start);
                        continue;
                    }
                    catch (OutOfMemoryError e) {
                        callStop = false;
                        database.shutdownImmediately();
                        throw DbException.convert(e);
                    }
                    catch (Throwable e) {
                        throw DbException.convert(e);
                    }
                    {
                        catch (DbException e) {
                            e = e.addSQL(this.sql);
                            SQLException s = e.getSQLException();
                            database.exceptionThrown(s, this.sql);
                            if (s.getErrorCode() == 90108) {
                                callStop = false;
                                database.shutdownImmediately();
                                throw e;
                            }
                            database.checkPowerOff();
                            throw e;
                        }
                    }
                }
                break;
            }
            finally {
                this.session.resetThreadLocalSession(oldSession);
                this.session.endStatement();
                if (callStop) {
                    this.stop();
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultWithGeneratedKeys executeUpdate(Object generatedKeysRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void commitIfNonTransactional() {
        if (!this.isTransactional()) {
            boolean autoCommit = this.session.getAutoCommit();
            this.session.commit(true);
            if (!autoCommit && this.session.getAutoCommit()) {
                this.session.begin();
            }
        }
    }

    private long filterConcurrentUpdate(DbException e, long start) {
        int errorCode = e.getErrorCode();
        if (errorCode != 90131 && errorCode != 90143 && errorCode != 90112) {
            throw e;
        }
        long now = Utils.currentNanoTime();
        if (start != 0L && now - start > (long)this.session.getLockTimeout() * 1000000L) {
            throw DbException.get(50200, e, new String[0]);
        }
        return start == 0L ? now : start;
    }

    @Override
    public void close() {
        this.canReuse = true;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    public String toString() {
        return this.sql + Trace.formatParams(this.getParameters());
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean canReuse() {
        return this.canReuse;
    }

    public void reuse() {
        this.canReuse = false;
        ArrayList<? extends ParameterInterface> parameters = this.getParameters();
        for (ParameterInterface parameterInterface : parameters) {
            parameterInterface.setValue(null, true);
        }
    }

    public void setCanReuse(boolean canReuse) {
        this.canReuse = canReuse;
    }

    public abstract Set<DbObject> getDependencies();

    protected abstract boolean isCurrentCommandADefineCommand();
}

