/*
 * Decompiled with CFR 0.152.
 */
package org.h2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import org.h2.JdbcDriverBackwardsCompat;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;

public class Driver
implements java.sql.Driver,
JdbcDriverBackwardsCompat {
    private static final Driver INSTANCE = new Driver();
    private static final String DEFAULT_URL = "jdbc:default:connection";
    private static final ThreadLocal<Connection> DEFAULT_CONNECTION = new ThreadLocal();
    private static boolean registered;

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null) {
            throw DbException.getJdbcSQLException(90046, null, "jdbc:h2:{ {.|mem:}[name] | [file:]fileName | {tcp|ssl}:[//]server[:port][,server2[:port]]/name }[;key=value...]", null);
        }
        if (url.startsWith("jdbc:h2:")) {
            return new JdbcConnection(url, info, null, null, false);
        }
        if (url.equals(DEFAULT_URL)) {
            return DEFAULT_CONNECTION.get();
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw DbException.getJdbcSQLException(90046, null, "jdbc:h2:{ {.|mem:}[name] | [file:]fileName | {tcp|ssl}:[//]server[:port][,server2[:port]]/name }[;key=value...]", null);
        }
        if (url.startsWith("jdbc:h2:")) {
            return true;
        }
        if (url.equals(DEFAULT_URL)) {
            return DEFAULT_CONNECTION.get() != null;
        }
        return false;
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 2;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    public static synchronized Driver load() {
        try {
            if (!registered) {
                registered = true;
                DriverManager.registerDriver(INSTANCE);
            }
        }
        catch (SQLException e) {
            DbException.traceThrowable(e);
        }
        return INSTANCE;
    }

    public static synchronized void unload() {
        try {
            if (registered) {
                registered = false;
                DriverManager.deregisterDriver(INSTANCE);
            }
        }
        catch (SQLException e) {
            DbException.traceThrowable(e);
        }
    }

    public static void setDefaultConnection(Connection c) {
        if (c == null) {
            DEFAULT_CONNECTION.remove();
        } else {
            DEFAULT_CONNECTION.set(c);
        }
    }

    public static void setThreadContextClassLoader(Thread thread) {
        try {
            thread.setContextClassLoader(Driver.class.getClassLoader());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        Driver.load();
    }
}

