/*
 * Decompiled with CFR 0.152.
 */
package net.worcade.client.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.Duration;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import net.worcade.client.Result;
import net.worcade.client.Worcade;
import net.worcade.client.api.ApplicationApi;
import net.worcade.client.api.AssetApi;
import net.worcade.client.api.AttachmentApi;
import net.worcade.client.api.ChecklistApi;
import net.worcade.client.api.CompanyApi;
import net.worcade.client.api.ContactsApi;
import net.worcade.client.api.ConversationApi;
import net.worcade.client.api.GroupApi;
import net.worcade.client.api.LabelApi;
import net.worcade.client.api.ReclaimApi;
import net.worcade.client.api.RoomApi;
import net.worcade.client.api.SearchApi;
import net.worcade.client.api.SiteApi;
import net.worcade.client.api.UserApi;
import net.worcade.client.api.WebhookApi;
import net.worcade.client.api.WorkOrderApi;
import net.worcade.client.exception.IncompatibleVersionException;
import net.worcade.client.exception.InvalidIdException;
import net.worcade.client.get.Authentication;
import net.worcade.client.get.BinaryData;
import net.worcade.client.get.ExternalNumber;
import net.worcade.client.get.Notification;
import net.worcade.client.get.OptionalField;
import net.worcade.client.get.Reference;
import net.worcade.client.get.ReferenceWithName;
import net.worcade.client.get.RemoteId;
import net.worcade.client.get.Webhook;
import net.worcade.client.get.WorkOrder;
import net.worcade.client.internal.Header;
import net.worcade.client.internal.IncomingDto;
import net.worcade.client.internal.Modification;
import net.worcade.client.internal.Util;
import net.worcade.client.internal.WorcadeApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WorcadeClient
implements Worcade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorcadeClient.class);
    protected static String PUBLIC_API = "api/v" + Worcade.VERSION.getMajor() + "/";
    protected static final Function<Object, IncomingDto> DTO_FUNCTION = o -> {
        Map data = (Map)o;
        return IncomingDto.of(data);
    };
    private final String baseUrl;
    private String userHeader;
    private String applicationHeader;
    private final ApplicationApi applicationApi = new WorcadeApi(this, PUBLIC_API + "application");
    private final AssetApi assetApi = new WorcadeApi(this, PUBLIC_API + "asset");
    private final AttachmentApi attachmentApi = new WorcadeApi(this, PUBLIC_API + "attachment");
    private final ChecklistApi checklistApi = new WorcadeApi(this, PUBLIC_API + "checklist");
    private final CompanyApi companyApi = new WorcadeApi(this, PUBLIC_API + "company");
    private final ContactsApi contactsApi = new WorcadeApi(this, PUBLIC_API + "contacts");
    private final ConversationApi conversationApi = new WorcadeApi(this, PUBLIC_API + "conversation");
    private final GroupApi groupApi = new WorcadeApi(this, PUBLIC_API + "group");
    private final LabelApi labelApi = new WorcadeApi(this, PUBLIC_API + "label");
    private final ReclaimApi reclaimApi = new WorcadeApi(this, PUBLIC_API + "reclaim");
    private final RoomApi roomApi = new WorcadeApi(this, PUBLIC_API + "room");
    private final SearchApi searchApi = new WorcadeApi(this, PUBLIC_API + "search");
    private final SiteApi siteApi = new WorcadeApi(this, PUBLIC_API + "site");
    private final UserApi userApi = new WorcadeApi(this, PUBLIC_API + "user");
    private final WebhookApi webhookApi = new WorcadeApi(this, PUBLIC_API + "webhook");
    private final WorkOrderApi workOrderApi = new WorcadeApi(this, PUBLIC_API + "workorder");

    protected WorcadeClient(String baseUrl) {
        Preconditions.checkArgument((boolean)baseUrl.startsWith("http"), (Object)"Base URL must include protocol https:// or http://");
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
    }

    protected Result<? extends Worcade> checkServerVersion() {
        Result<IncomingDto> result = this.get(PUBLIC_API + "about/version", new Header[0]);
        if (result.isOk()) {
            IncomingDto serverVersion = result.getResult();
            if (serverVersion.getInt("major") != Worcade.VERSION.getMajor()) {
                throw new IncompatibleVersionException(serverVersion.getString("version"));
            }
            if (serverVersion.getInt("minor") < Worcade.VERSION.getMinor()) {
                throw new IncompatibleVersionException(serverVersion.getString("version"));
            }
            if (serverVersion.getInt("minor") == Worcade.VERSION.getMinor() && serverVersion.getInt("patch") < Worcade.VERSION.getPatch()) {
                throw new IncompatibleVersionException(serverVersion.getString("version"));
            }
            log.info("Worcade {} initialized on {}, running version {}", new Object[]{this.getClass().getSimpleName(), this.baseUrl, serverVersion.getString("version")});
        } else {
            log.warn("Version check failed with {}; not throwing to allow reconnect", result.getMessages());
        }
        return result.map(v -> this);
    }

    @Override
    public Result<ReferenceWithName> loginUserByEmail(String email, String password) {
        return this.loginUser(email + ":" + password, "/email");
    }

    @Override
    public Result<ReferenceWithName> loginUserById(String userId, String password) {
        WorcadeClient.checkId(userId);
        return this.loginUser(userId + ":" + password, "");
    }

    private Result<ReferenceWithName> loginUser(String authHeaderValue, String urlSuffix) {
        this.userHeader = null;
        this.applicationHeader = null;
        Result<IncomingDto> result = this.get(PUBLIC_API + "authentication/user" + urlSuffix, new Header("Authorization", "BASIC " + Util.encodeBase64(authHeaderValue)));
        if (result.isOk()) {
            this.setUserToken(result.getResult().getString("token"));
        }
        return result.map(d -> d.getDto("authenticated"));
    }

    @Override
    public Result<ReferenceWithName> setUserApiKey(String apiKey) {
        this.userHeader = "APIKEY " + apiKey;
        this.applicationHeader = null;
        Result<ReferenceWithName> result = this.getAuthentication().map(Authentication::getUser);
        if (!result.isOk()) {
            this.userHeader = null;
        }
        return result;
    }

    @Override
    public Result<?> logoutUser() {
        if (this.userHeader == null || !this.userHeader.startsWith("DIGEST ")) {
            this.userHeader = null;
            return Result.ok(null);
        }
        Result<IncomingDto> result = this.delete(PUBLIC_API + "authentication/user", new Header[0]);
        this.userHeader = null;
        return result;
    }

    @Override
    public Result<ReferenceWithName> loginApplication(String applicationId, PrivateKey applicationPrivateKey, PublicKey worcadePublicKey) {
        this.userHeader = null;
        this.applicationHeader = null;
        WorcadeClient.checkId(applicationId);
        Result<ReferenceWithName> result = this.get(PUBLIC_API + "authentication/application/" + applicationId + "/handshake", new Header[0]).flatMap(d -> Util.decodeAndDecrypt(d.getString("digest"), applicationPrivateKey)).flatMap(d -> Util.encryptAndEncode(d, worcadePublicKey)).flatMap(d -> this.post(PUBLIC_API + "authentication/application/" + applicationId + "/session", ImmutableMap.of((Object)"digest", (Object)d), new Header[0]));
        if (result.isOk()) {
            this.setApplicationToken(((IncomingDto)result.getResult()).getString("token"));
        }
        return result.map(d -> d.getDto("authenticated"));
    }

    @Override
    public Result<ReferenceWithName> setApplicationSourceAuth(String id) {
        this.userHeader = null;
        this.applicationHeader = id;
        return id == null ? Result.ok(null) : this.getAuthentication().map(Authentication::getApplication);
    }

    @Override
    public Result<ReferenceWithName> setApplicationApiKey(String apiKey) {
        this.userHeader = null;
        this.applicationHeader = "APIKEY " + apiKey;
        Result<ReferenceWithName> result = this.getAuthentication().map(Authentication::getApplication);
        if (!result.isOk()) {
            this.applicationHeader = null;
        }
        return result;
    }

    @Override
    public Result<? extends Authentication> setTrustedUser(Reference user) {
        Preconditions.checkState((this.applicationHeader != null ? 1 : 0) != 0, (Object)"No authenticated application");
        if (user == null) {
            this.userHeader = null;
            return Result.ok(null);
        }
        Result<IncomingDto> result = this.get(PUBLIC_API + "authentication", new Header("Worcade-User", WorcadeClient.checkId(user.getId())));
        if (result.isOk()) {
            log.trace("Authentication with trusted user: {}", (Object)result.getResult());
            this.userHeader = user.getId();
        }
        return result;
    }

    @Override
    public Result<?> logoutApplication() {
        if (this.applicationHeader == null || !this.applicationHeader.startsWith("DIGEST")) {
            this.applicationHeader = null;
            this.userHeader = null;
            return Result.ok(null);
        }
        Result<IncomingDto> result = this.delete(PUBLIC_API + "authentication/application", new Header[0]);
        this.applicationHeader = null;
        this.userHeader = null;
        return result;
    }

    @Override
    public Result<?> invalidateCurrentApiKey() {
        if (this.applicationHeader != null && this.applicationHeader.startsWith("APIKEY")) {
            Result result = this.getAuthentication().flatMap(auth -> this.delete(PUBLIC_API + "application/" + auth.getApplication().getId() + "/apikey", new Header[0]));
            this.applicationHeader = null;
            this.userHeader = null;
            return result;
        }
        if (this.userHeader != null && this.userHeader.startsWith("APIKEY")) {
            Result result = this.getAuthentication().flatMap(auth -> this.delete(PUBLIC_API + "user/" + auth.getUser().getId() + "/apikey", new Header[0]));
            this.applicationHeader = null;
            this.userHeader = null;
            return result;
        }
        return Result.failed((List<Result.Message>)ImmutableList.of((Object)new Result.Message(null, "No active API key")));
    }

    @VisibleForTesting
    public Result<? extends Authentication> getSecretAuthentication(String userId, String secret) {
        return this.get(PUBLIC_API + "authentication", new Header("Worcade-User", userId), new Header("Worcade-Secret", secret));
    }

    @Override
    public Result<? extends Authentication> getAuthentication() {
        return this.get(PUBLIC_API + "authentication", new Header[0]);
    }

    @Override
    public Result<Boolean> probeUserTrust(String userId, String applicationId) {
        return this.get(PUBLIC_API + "authentication/user/" + WorcadeClient.checkId(userId) + "/trusted/" + WorcadeClient.checkId(applicationId), new Header[0]).map(d -> d.getBoolean("trusted"));
    }

    @Override
    public Result<? extends Collection<? extends Notification>> getNotifications() {
        return this.getList(PUBLIC_API + "notification", new Header[0]);
    }

    @Override
    public RemoteId createRemoteId(String remoteIdType, String remoteId) {
        return IncomingDto.of((Map<String, Object>)ImmutableMap.of((Object)"remoteIdType", (Object)remoteIdType, (Object)"remoteId", (Object)remoteId));
    }

    @Override
    public OptionalField createOptionalField(String name, String value, Reference owner) {
        if (owner == null) {
            return IncomingDto.of((Map<String, Object>)ImmutableMap.of((Object)"name", (Object)name, (Object)"value", (Object)value));
        }
        return IncomingDto.of((Map<String, Object>)ImmutableMap.of((Object)"name", (Object)name, (Object)"value", (Object)value, (Object)"owner", Modification.cleanReference(owner)));
    }

    @Override
    public ExternalNumber createExternalNumber(String number, String description) {
        return IncomingDto.of((Map<String, Object>)ImmutableMap.of((Object)"number", (Object)number, (Object)"description", (Object)description));
    }

    @Override
    public Webhook.Header createWebhookHeader(String name, String value) {
        return IncomingDto.of((Map<String, Object>)ImmutableMap.of((Object)"name", (Object)name, (Object)"value", (Object)value));
    }

    @Override
    public WorkOrder.Row createWorkOrderRow(String description, Duration duration, Double cost, Currency currency) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (duration != null) {
            builder.put((Object)"duration", (Object)duration.getSeconds());
        }
        if (cost != null) {
            builder.put((Object)"costAmount", (Object)cost).put((Object)"costCurrency", (Object)currency.getCurrencyCode());
        }
        return IncomingDto.of((Map<String, Object>)builder.put((Object)"description", (Object)description).build());
    }

    @CanIgnoreReturnValue
    static String checkId(String id) {
        try {
            UUID.fromString(id);
            return id;
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new InvalidIdException(id);
        }
    }

    private void setUserToken(String token) {
        this.applicationHeader = null;
        this.userHeader = "DIGEST " + token;
    }

    private void setApplicationToken(String token) {
        this.userHeader = null;
        this.applicationHeader = "DIGEST " + token;
    }

    @Override
    public WorcadeClient copyWithSameAuth() {
        WorcadeClient client = this.copy();
        client.applicationHeader = this.applicationHeader;
        client.userHeader = this.userHeader;
        return client;
    }

    protected abstract WorcadeClient copy();

    protected abstract Result<IncomingDto> get(String var1, Header ... var2);

    protected abstract Result<List<IncomingDto>> getList(String var1, Header ... var2);

    protected abstract Result<BinaryData> getBinary(String var1, Header ... var2);

    protected abstract Result<IncomingDto> post(String var1, Object var2, Header ... var3);

    protected abstract Result<IncomingDto> postBinary(String var1, InputStream var2, String var3, Header ... var4);

    protected abstract Result<IncomingDto> put(String var1, Object var2, Header ... var3);

    protected abstract Result<IncomingDto> delete(String var1, Header ... var2);

    protected abstract Result<IncomingDto> delete(String var1, Object var2, Header ... var3);

    @Generated
    protected String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    protected String getUserHeader() {
        return this.userHeader;
    }

    @Generated
    protected void setUserHeader(String userHeader) {
        this.userHeader = userHeader;
    }

    @Generated
    protected String getApplicationHeader() {
        return this.applicationHeader;
    }

    @Generated
    protected void setApplicationHeader(String applicationHeader) {
        this.applicationHeader = applicationHeader;
    }

    @Override
    @Generated
    public ApplicationApi getApplicationApi() {
        return this.applicationApi;
    }

    @Override
    @Generated
    public AssetApi getAssetApi() {
        return this.assetApi;
    }

    @Override
    @Generated
    public AttachmentApi getAttachmentApi() {
        return this.attachmentApi;
    }

    @Override
    @Generated
    public ChecklistApi getChecklistApi() {
        return this.checklistApi;
    }

    @Override
    @Generated
    public CompanyApi getCompanyApi() {
        return this.companyApi;
    }

    @Override
    @Generated
    public ContactsApi getContactsApi() {
        return this.contactsApi;
    }

    @Override
    @Generated
    public ConversationApi getConversationApi() {
        return this.conversationApi;
    }

    @Override
    @Generated
    public GroupApi getGroupApi() {
        return this.groupApi;
    }

    @Override
    @Generated
    public LabelApi getLabelApi() {
        return this.labelApi;
    }

    @Override
    @Generated
    public ReclaimApi getReclaimApi() {
        return this.reclaimApi;
    }

    @Override
    @Generated
    public RoomApi getRoomApi() {
        return this.roomApi;
    }

    @Override
    @Generated
    public SearchApi getSearchApi() {
        return this.searchApi;
    }

    @Override
    @Generated
    public SiteApi getSiteApi() {
        return this.siteApi;
    }

    @Override
    @Generated
    public UserApi getUserApi() {
        return this.userApi;
    }

    @Override
    @Generated
    public WebhookApi getWebhookApi() {
        return this.webhookApi;
    }

    @Override
    @Generated
    public WorkOrderApi getWorkOrderApi() {
        return this.workOrderApi;
    }
}

