// Copyright (c) 2017, Worcade. Please see the AUTHORS file for details.
// All rights reserved. Use of this source code is governed by a MIT-style
// license that can be found in the LICENSE file.

package net.worcade.client;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.Getter;

@Getter @EqualsAndHashCode
@AllArgsConstructor(access = AccessLevel.PACKAGE)
public class Version {
    private final int major;
    private final int minor;
    private final int patch;

    @Override
    public String toString() {
        return major + "." + minor + "." + patch;
    }
}
