/*
 * Decompiled with CFR 0.152.
 */
package net.worcade.client.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import net.worcade.client.create.ApplicationCreate;
import net.worcade.client.create.AssetCreate;
import net.worcade.client.create.CompanyCreate;
import net.worcade.client.create.ConversationCreate;
import net.worcade.client.create.GroupCreate;
import net.worcade.client.create.LabelCreate;
import net.worcade.client.create.RoomCreate;
import net.worcade.client.create.SiteCreate;
import net.worcade.client.create.UserCreate;
import net.worcade.client.create.WebhookCreate;
import net.worcade.client.create.WorkOrderCreate;
import net.worcade.client.get.ExternalNumber;
import net.worcade.client.get.OptionalField;
import net.worcade.client.get.Reference;
import net.worcade.client.get.RemoteId;
import net.worcade.client.get.Webhook;
import net.worcade.client.get.WorkOrder;
import net.worcade.client.internal.IncomingDto;
import net.worcade.client.internal.Util;
import net.worcade.client.internal.WorcadeClient;
import net.worcade.client.modify.WorkOrderModification;
import net.worcade.client.modify.WorkOrderRowModification;

class Modification
implements ApplicationCreate,
AssetCreate,
CompanyCreate,
ConversationCreate,
GroupCreate,
LabelCreate,
RoomCreate,
SiteCreate,
UserCreate,
WebhookCreate,
WorkOrderCreate,
WorkOrderModification,
WorkOrderRowModification {
    private final Map<String, Object> data;

    static Modification update(Map<String, Object> data) {
        return new Modification(data);
    }

    static Modification create() {
        return new Modification();
    }

    Modification() {
        this.data = Maps.newHashMap();
    }

    Modification(Map<String, Object> data) {
        this.data = Maps.newHashMap(data);
    }

    Modification putReference(String key, Reference reference) {
        return this.put(key, Modification.cleanReference(reference));
    }

    Modification putReferenceList(String key, Reference ... references) {
        return this.put(key, Modification.cleanReferences(references));
    }

    Modification putReferenceList(String key, Collection<? extends Reference> references) {
        return this.put(key, Modification.cleanReferences(references));
    }

    Modification put(String key, Object value) {
        this.data.put(key, value);
        return this;
    }

    static Map<String, String> cleanReference(String id) {
        return id == null ? null : ImmutableMap.of((Object)"id", (Object)WorcadeClient.checkId(id));
    }

    static Map<String, String> cleanReference(Reference reference) {
        return reference == null ? null : ImmutableMap.of((Object)"id", (Object)WorcadeClient.checkId(reference.getId()));
    }

    static List<Map<String, String>> cleanReferences(Reference ... references) {
        return (List)Stream.of(references).map(Modification::cleanReference).collect(ImmutableList.toImmutableList());
    }

    static List<Map<String, String>> cleanReferences(Collection<? extends Reference> references) {
        return (List)references.stream().map(Modification::cleanReference).collect(ImmutableList.toImmutableList());
    }

    static List<Map<String, String>> cleanRemoteIds(RemoteId ... remoteIds) {
        return (List)Stream.of(remoteIds).map(r -> ImmutableMap.of((Object)"remoteIdType", (Object)r.getRemoteIdType(), (Object)"remoteId", (Object)r.getRemoteId())).collect(ImmutableList.toImmutableList());
    }

    static List<Map<String, Object>> cleanOptionalFields(OptionalField ... optionalFields) {
        return (List)Stream.of(optionalFields).map(r -> r.getOwner() == null ? ImmutableMap.of((Object)"name", (Object)r.getName(), (Object)"value", (Object)r.getValue()) : ImmutableMap.of((Object)"name", (Object)r.getName(), (Object)"value", (Object)r.getValue(), (Object)"owner", Modification.cleanReference(r.getOwner()))).collect(ImmutableList.toImmutableList());
    }

    static List<Map<String, String>> cleanExternalNumbers(ExternalNumber ... numbers) {
        return (List)Stream.of(numbers).map(r -> ImmutableMap.of((Object)"number", (Object)r.getNumber(), (Object)"description", (Object)r.getDescription())).collect(ImmutableList.toImmutableList());
    }

    static List<Map<String, Object>> cleanHeaders(Webhook.Header ... headers) {
        return (List)Stream.of(headers).map(r -> ((IncomingDto)r).getData()).collect(ImmutableList.toImmutableList());
    }

    static List<ImmutableMap<String, Object>> cleanRows(WorkOrder.Row ... rows) {
        return (List)Stream.of(rows).map(r -> ((IncomingDto)r).getData()).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Modification name(String name) {
        return this.put("name", name);
    }

    @Override
    public Modification email(String name) {
        return this.put("email", name);
    }

    @Override
    public Modification password(String password) {
        return this.put("password", Util.encodeBase64(password));
    }

    @Override
    public Modification type(String type) {
        return this.put("assetType", type);
    }

    @Override
    public Modification make(String make) {
        return this.put("assetMake", make);
    }

    @Override
    public Modification model(String model) {
        return this.put("assetModel", model);
    }

    @Override
    public Modification specification(String specification) {
        return this.put("specification", specification);
    }

    @Override
    public Modification serial(String serial) {
        return this.put("serial", serial);
    }

    @Override
    public Modification addressLineOne(String addressLineOne) {
        return this.put("addressLineOne", addressLineOne);
    }

    @Override
    public Modification addressLineTwo(String addressLineTwo) {
        return this.put("addressLineTwo", addressLineTwo);
    }

    @Override
    public Modification postalCode(String postalCode) {
        return this.put("postalCode", postalCode);
    }

    @Override
    public Modification city(String city) {
        return this.put("city", city);
    }

    @Override
    public Modification region(String region) {
        return this.put("region", region);
    }

    @Override
    public Modification country(String country) {
        return this.put("country", country);
    }

    @Override
    public Modification telephone(String telephone) {
        return this.put("telephone", telephone);
    }

    @Override
    public Modification coordinates(float latitude, float longitude) {
        return this.put("coordinates", ImmutableMap.of((Object)"latitude", (Object)Float.valueOf(latitude), (Object)"longitude", (Object)Float.valueOf(longitude)));
    }

    @Override
    public Modification versions(String ... versions) {
        return this.put("versions", ImmutableList.copyOf((Object[])versions));
    }

    @Override
    public Modification locale(Locale locale) {
        return this.put("locale", ImmutableMap.of((Object)"language", (Object)locale.getLanguage(), (Object)"country", (Object)locale.getCountry()));
    }

    @Override
    public Modification mailImportAddress(String mailImportAddress) {
        return this.put("mailImportAddress", mailImportAddress);
    }

    @Override
    public Modification location(Reference location) {
        return this.putReference("location", location);
    }

    @Override
    public Modification autoShareTarget(Reference target) {
        return this.putReference("autoShareTarget", target);
    }

    @Override
    public Modification picture(Reference picture) {
        return this.putReference("picture", picture);
    }

    @Override
    public Modification suppressUpdateNotifications(boolean suppress) {
        return this.put("suppressUpdateNotifications", suppress);
    }

    @Override
    public Modification subscribeGettingStarted(boolean subscribe) {
        return this.put("subscribeGettingStarted", subscribe);
    }

    @Override
    public Modification subscribeNewsletter(boolean subscribe) {
        return this.put("subscribeNewsletter", subscribe);
    }

    @Override
    public Modification trustedApplications(Reference ... applications) {
        return this.putReferenceList("trustedApplications", applications);
    }

    @Override
    public Modification remoteIds(RemoteId ... remoteIds) {
        return this.put("remoteIds", Modification.cleanRemoteIds(remoteIds));
    }

    @Override
    public Modification domains(String ... domains) {
        return this.put("domains", ImmutableList.copyOf((Object[])domains));
    }

    @Override
    public Modification members(Reference ... members) {
        return this.putReferenceList("members", members);
    }

    @Override
    public Modification company(Reference company) {
        return this.putReference("company", company);
    }

    @Override
    public Modification visible(boolean visible) {
        return this.put("visible", visible);
    }

    @Override
    public Modification reporter(Reference reporter) {
        return this.putReference("reporter", reporter);
    }

    @Override
    public Modification assignee(Reference assignee) {
        return this.putReference("assignee", assignee);
    }

    @Override
    public Modification testMode(boolean testMode) {
        return this.put("testMode", testMode);
    }

    @Override
    public Modification externalNumbers(ExternalNumber ... numbers) {
        return this.put("externalNumbers", Modification.cleanExternalNumbers(numbers));
    }

    @Override
    public Modification watchers(Reference ... watchers) {
        return this.putReferenceList("watchers", watchers);
    }

    @Override
    public ConversationCreate watchers(Collection<? extends Reference> watchers) {
        return this.putReferenceList("watchers", watchers);
    }

    @Override
    public Modification close() {
        return this.put("closed", true);
    }

    @Override
    public Modification reopen() {
        return this.put("closed", false);
    }

    @Override
    public Modification archive() {
        return this.put("archived", true);
    }

    @Override
    public Modification unarchive() {
        return this.put("archived", false);
    }

    @Override
    public Modification floor(String floor) {
        return this.put("floor", floor);
    }

    @Override
    public Modification roomNumber(String roomNumber) {
        return this.put("roomNumber", roomNumber);
    }

    @Override
    public Modification labels(Reference ... labels) {
        return this.putReferenceList("labels", labels);
    }

    @Override
    public Modification sharedWith(Reference ... targets) {
        return this.putReferenceList("sharedWith", targets);
    }

    @Override
    public Modification url(String url) {
        return this.put("url", url);
    }

    @Override
    public Modification event(Webhook.Event event) {
        return this.put("event", event.getEvent());
    }

    @Override
    public Modification suppressOwn(boolean suppress) {
        return this.put("suppressOwn", suppress);
    }

    @Override
    public Modification headers(Webhook.Header ... headers) {
        return this.put("headers", Modification.cleanHeaders(headers));
    }

    @Override
    public Modification description(String description) {
        return this.put("description", description);
    }

    @Override
    public Modification backgroundColor(String color) {
        return this.put("backgroundColor", color);
    }

    @Override
    public Modification foregroundColor(String color) {
        return this.put("foregroundColor", color);
    }

    @Override
    public Modification forGroup(Reference group) {
        return this.putReference("forGroup", group);
    }

    @Override
    public Modification rows(WorkOrder.Row ... rows) {
        return this.put("rows", Modification.cleanRows(rows));
    }

    @Override
    public Modification approve() {
        return this.put("approved", true);
    }

    @Override
    public Modification reject() {
        return this.put("approved", false);
    }

    @Override
    public Modification duration(Duration duration) {
        return this.put("duration", duration.getSeconds());
    }

    @Override
    public Modification cost(double amount, Currency currency) {
        return this.put("costAmount", amount).put("costCurrency", currency.getCurrencyCode());
    }

    @Override
    public Modification mainGroup(Reference group) {
        return this.putReference("mainGroup", group);
    }

    @Override
    public Modification notes(String notes) {
        return this.put("notes", notes);
    }

    @Override
    public Modification samlNameId(String nameId) {
        return this.put("samlNameId", nameId);
    }

    @Override
    public Modification fingerprint(String fingerprint) {
        return this.put("fingerprint", fingerprint);
    }

    @Generated
    public String toString() {
        return "Modification(data=" + this.getData() + ")";
    }

    @Generated
    Map<String, Object> getData() {
        return this.data;
    }
}

