/*
 * Decompiled with CFR 0.152.
 */
package net.worcade.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import net.worcade.client.Code;

public class Result<T> {
    private final boolean ok;
    private final List<Message> messages;
    private final T result;

    public static <T> Result<T> ok(T result, List<Message> messages) {
        return new Result<T>(true, (List<Message>)ImmutableList.copyOf(messages), result);
    }

    public static <T> Result<T> ok(T result) {
        return new Result<T>(true, (List<Message>)ImmutableList.of(), result);
    }

    public static <T> Result<T> failed(List<Message> messages) {
        return new Result<Object>(false, (List<Message>)ImmutableList.copyOf(messages), null);
    }

    @CanIgnoreReturnValue
    public T getResult() {
        Preconditions.checkState((boolean)this.ok, (String)"Action failed with %s, cannot get result", this.messages);
        return this.result;
    }

    public <M> Result<M> map(Function<T, M> mapper) {
        if (!this.isOk()) {
            return this.cast();
        }
        return Result.ok(mapper.apply(this.result), this.messages);
    }

    public <M> Result<M> flatMap(Function<T, Result<M>> mapper) {
        if (!this.isOk()) {
            return this.cast();
        }
        Result<M> secondResult = mapper.apply(this.result);
        if (this.messages.isEmpty()) {
            return secondResult;
        }
        ImmutableList combined = ImmutableList.builder().addAll(this.messages).addAll(secondResult.getMessages()).build();
        return new Result<T>(secondResult.ok, (List<Message>)combined, secondResult.result);
    }

    public <V> Result<V> cast() {
        if (this.result == null) {
            Result castResult = this;
            return castResult;
        }
        return new Result<Object>(this.ok, this.messages, null);
    }

    @ConstructorProperties(value={"ok", "messages", "result"})
    @Generated
    private Result(boolean ok, List<Message> messages, T result) {
        this.ok = ok;
        this.messages = messages;
        this.result = result;
    }

    @Generated
    public String toString() {
        return "Result(ok=" + this.ok + ", messages=" + this.messages + ", result=" + this.result + ")";
    }

    @Generated
    public boolean isOk() {
        return this.ok;
    }

    @Generated
    public List<Message> getMessages() {
        return this.messages;
    }

    public static class Message {
        private final Code code;
        private final String message;

        public boolean hasCode() {
            return this.code != null;
        }

        public boolean isCode(Code code) {
            return this.code == Preconditions.checkNotNull((Object)((Object)code));
        }

        public Code getCode() {
            Preconditions.checkState((boolean)this.hasCode(), (Object)"This message does not have a code");
            return this.code;
        }

        public String toString() {
            return this.hasCode() ? (Object)((Object)this.code) + ": " + this.message : this.message;
        }

        @ConstructorProperties(value={"code", "message"})
        @Generated
        public Message(Code code, String message) {
            this.code = code;
            this.message = message;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }
    }
}

