/*
 * Decompiled with CFR 0.152.
 */
package net.worcade.client.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.worcade.client.internal.Util;
import net.worcade.client.query.EntityField;
import net.worcade.client.query.Query;

public class WorcadeQuery<T extends EntityField>
implements Query<T> {
    private final Set<EntityField> fields;
    private final Multimap<EntityField, String> filter;
    private final List<Order> order;
    private final int limit;

    String toQueryString() {
        StringBuilder sb = new StringBuilder("?limit=" + this.limit);
        for (EntityField field : this.fields) {
            sb.append("&field=").append(field.name());
        }
        for (Map.Entry filter : this.filter.entries()) {
            sb.append("&").append(((EntityField)filter.getKey()).name()).append("=").append(Util.escapeUrlQueryParameter((String)filter.getValue()));
        }
        for (Order o : this.order) {
            sb.append("&order=").append(o.ascending ? "" : "-").append(o.field.name());
        }
        return sb.toString();
    }

    public static <T extends Enum<T>> Query.Builder<T> builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"fields", "filter", "order", "limit"})
    @Generated
    WorcadeQuery(Set<EntityField> fields, Multimap<EntityField, String> filter, List<Order> order, int limit) {
        this.fields = fields;
        this.filter = filter;
        this.order = order;
        this.limit = limit;
    }

    @Generated
    public String toString() {
        return "WorcadeQuery(fields=" + this.fields + ", filter=" + this.filter + ", order=" + this.order + ", limit=" + this.limit + ")";
    }

    static class Order {
        private final EntityField field;
        private final boolean ascending;

        @ConstructorProperties(value={"field", "ascending"})
        @Generated
        private Order(EntityField field, boolean ascending) {
            this.field = field;
            this.ascending = ascending;
        }

        @Generated
        public String toString() {
            return "WorcadeQuery.Order(field=" + this.field + ", ascending=" + this.ascending + ")";
        }
    }

    static class Builder<T extends Enum<T>>
    implements Query.Builder<T> {
        final Set<EntityField> fields = Sets.newHashSet();
        final ImmutableMultimap.Builder<EntityField, String> filter = ImmutableMultimap.builder();
        final ImmutableList.Builder<Order> order = ImmutableList.builder();
        int limit = 10;

        Builder() {
        }

        @Override
        @SafeVarargs
        public final Builder<T> fields(T ... fields) {
            Collections.addAll(this.fields, fields);
            return this;
        }

        @Override
        public Builder<T> fields(Collection<T> fields) {
            this.fields.addAll(fields);
            return this;
        }

        @Override
        public Builder<T> filter(T field, String value) {
            this.filter.put((Object)((EntityField)field), (Object)value);
            return this;
        }

        @Override
        public Builder<T> order(T field, boolean ascending) {
            this.order.add((Object)new Order((EntityField)field, ascending));
            return this;
        }

        @Override
        public Builder<T> limit(int limit) {
            this.limit = Math.min(Math.max(1, limit), 100);
            return this;
        }

        @Override
        public WorcadeQuery<T> build() {
            return new WorcadeQuery((Set<EntityField>)ImmutableSet.copyOf(this.fields), (Multimap<EntityField, String>)this.filter.build(), (List<Order>)this.order.build(), this.limit);
        }
    }
}

