/*
 * Decompiled with CFR 0.152.
 */
package net.worcade.client.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;
import net.worcade.client.Code;
import net.worcade.client.Result;
import net.worcade.client.api.ApplicationApi;
import net.worcade.client.api.AssetApi;
import net.worcade.client.api.AttachmentApi;
import net.worcade.client.api.ChecklistApi;
import net.worcade.client.api.CompanyApi;
import net.worcade.client.api.ContactsApi;
import net.worcade.client.api.ConversationApi;
import net.worcade.client.api.GroupApi;
import net.worcade.client.api.LabelApi;
import net.worcade.client.api.ReclaimApi;
import net.worcade.client.api.RoomApi;
import net.worcade.client.api.SearchApi;
import net.worcade.client.api.SiteApi;
import net.worcade.client.api.UserApi;
import net.worcade.client.api.WebhookApi;
import net.worcade.client.api.WorkOrderApi;
import net.worcade.client.create.WebhookCreate;
import net.worcade.client.create.WorkOrderCreate;
import net.worcade.client.get.ApiKey;
import net.worcade.client.get.Asset;
import net.worcade.client.get.BinaryData;
import net.worcade.client.get.Contact;
import net.worcade.client.get.Conversation;
import net.worcade.client.get.CreateWithApiKey;
import net.worcade.client.get.ExternalNumber;
import net.worcade.client.get.Group;
import net.worcade.client.get.Reference;
import net.worcade.client.get.ReferenceWithName;
import net.worcade.client.get.ReferenceWithNumber;
import net.worcade.client.get.RemoteId;
import net.worcade.client.get.RemoteIdSearchResult;
import net.worcade.client.get.Room;
import net.worcade.client.get.Site;
import net.worcade.client.get.Webhook;
import net.worcade.client.get.WebhookTestResult;
import net.worcade.client.get.WorkOrder;
import net.worcade.client.internal.Header;
import net.worcade.client.internal.IncomingDto;
import net.worcade.client.internal.Modification;
import net.worcade.client.internal.Util;
import net.worcade.client.internal.WorcadeClient;
import net.worcade.client.internal.WorcadeQuery;
import net.worcade.client.modify.ApplicationModification;
import net.worcade.client.modify.AssetModification;
import net.worcade.client.modify.CompanyModification;
import net.worcade.client.modify.ConversationModification;
import net.worcade.client.modify.EntityModification;
import net.worcade.client.modify.GroupModification;
import net.worcade.client.modify.LabelModification;
import net.worcade.client.modify.RoomModification;
import net.worcade.client.modify.SiteModification;
import net.worcade.client.modify.UserModification;
import net.worcade.client.modify.WorkOrderModification;
import net.worcade.client.modify.WorkOrderRowModification;
import net.worcade.client.query.AssetField;
import net.worcade.client.query.ContactField;
import net.worcade.client.query.ConversationField;
import net.worcade.client.query.GroupField;
import net.worcade.client.query.LabelField;
import net.worcade.client.query.Query;
import net.worcade.client.query.RoomField;
import net.worcade.client.query.SiteField;
import net.worcade.client.query.WebhookField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorcadeApi
implements ApplicationApi,
AssetApi,
AttachmentApi,
ChecklistApi,
CompanyApi,
ContactsApi,
ConversationApi,
GroupApi,
LabelApi,
ReclaimApi,
RoomApi,
SearchApi,
SiteApi,
UserApi,
WebhookApi,
WorkOrderApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorcadeApi.class);
    private final WorcadeClient worcadeClient;
    private final String entityUrl;

    WorcadeApi(WorcadeClient worcadeClient, String entityUrl) {
        this.worcadeClient = worcadeClient;
        this.entityUrl = entityUrl;
    }

    @Override
    public Modification createBuilder() {
        return Modification.create();
    }

    public Result<IncomingDto> get(String id) {
        return this.worcadeClient.get(this.entityUrl + "/" + WorcadeClient.checkId(id), new Header[0]);
    }

    @Override
    public Result<? extends Conversation> getWithHtmlMessages(String id) {
        return this.worcadeClient.get(this.entityUrl + "/" + WorcadeClient.checkId(id) + "?html=true", new Header[0]);
    }

    public Result<IncomingDto> getProfile(String id) {
        return this.worcadeClient.get(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/profile", new Header[0]);
    }

    @Override
    public Result<? extends Reference> create(ApplicationModification subject) {
        return this.createInternal(subject);
    }

    @Override
    public Result<? extends Reference> create(AssetModification subject) {
        return this.createInternal(subject);
    }

    @Override
    public Result<? extends Reference> create(CompanyModification subject) {
        return this.createInternal(subject);
    }

    @Override
    public Result<? extends ReferenceWithNumber> create(ConversationModification subject) {
        return this.createInternal(subject);
    }

    @Override
    public Result<? extends Reference> create(GroupModification subject) {
        return this.createInternal(subject);
    }

    @Override
    public Result<? extends Reference> create(LabelModification subject) {
        return this.createInternal(subject);
    }

    @Override
    public Result<? extends Reference> create(RoomModification subject) {
        return this.createInternal(subject);
    }

    @Override
    public Result<? extends Reference> create(SiteModification subject) {
        return this.createInternal(subject);
    }

    @Override
    public Result<? extends Reference> create(UserModification subject) {
        return this.createInternal(subject);
    }

    @Override
    public Result<? extends Reference> create(String ownerId, WebhookCreate subject) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(ownerId), ((Modification)subject).getData(), new Header[0]);
    }

    @Override
    public Result<? extends Reference> create(String conversationId, WorkOrderCreate subject) {
        return this.worcadeClient.post("conversation/" + WorcadeClient.checkId(conversationId) + "/content/workorder", ((Modification)subject).getData(), new Header[0]);
    }

    @Override
    public Result<?> update(AssetModification subject) {
        return this.updateInternal(subject, "", true);
    }

    @Override
    public Result<?> update(ConversationModification subject) {
        return this.updateInternal(subject, "", false);
    }

    @Override
    public Result<?> update(LabelModification subject) {
        return this.updateInternal(subject, "", true);
    }

    @Override
    public Result<?> update(RoomModification subject) {
        return this.updateInternal(subject, "", true);
    }

    @Override
    public Result<?> update(SiteModification subject) {
        return this.updateInternal(subject, "", true);
    }

    @Override
    public Result<?> update(WorkOrderModification subject) {
        return this.updateInternal(subject, "", true);
    }

    @Override
    public Result<?> updateProfile(ApplicationModification subject) {
        return this.updateInternal(subject, "/profile", true);
    }

    @Override
    public Result<?> updateProfile(CompanyModification subject) {
        return this.updateInternal(subject, "/profile", true);
    }

    @Override
    public Result<?> updateProfile(GroupModification subject) {
        return this.updateInternal(subject, "/profile", true);
    }

    @Override
    public Result<?> updateProfile(UserModification subject) {
        return this.updateInternal(subject, "/profile", true);
    }

    @Override
    public Result<?> delete(String id) {
        return this.worcadeClient.delete(this.entityUrl + "/" + WorcadeClient.checkId(id), new Header[0]);
    }

    @Override
    public Result<CreateWithApiKey> createWithApiKey(ApplicationModification subject, String apiKeyDescription) {
        Result<IncomingDto> result = this.worcadeClient.post(this.entityUrl + "?apiKeyDescription=" + Util.escapeUrlQueryParameter(apiKeyDescription), ((Modification)subject).getData(), new Header[0]);
        return result.map(d -> {
            Iterable messages = Iterables.filter(result.getMessages(), m -> m.isCode(Code.GENERATED_API_KEY));
            return new CreateWithApiKey((Reference)d, ((Result.Message)Iterables.getOnlyElement((Iterable)messages)).getMessage());
        });
    }

    @Override
    public Result<? extends Collection<? extends Asset>> getAssetList(Query<AssetField> query) {
        return this.getList(query);
    }

    @Override
    public Result<? extends Collection<? extends Conversation>> getConversationList(Query<ConversationField> query) {
        return this.getList(query);
    }

    @Override
    public Result<? extends Collection<? extends Group>> getGroupList(Query<GroupField> query) {
        return this.getList(query);
    }

    @Override
    public Result<? extends Collection<? extends Room>> getLabelList(Query<LabelField> query) {
        return this.getList(query);
    }

    @Override
    public Result<? extends Collection<? extends Room>> getRoomList(Query<RoomField> query) {
        return this.getList(query);
    }

    @Override
    public Result<? extends Collection<? extends Site>> getSiteList(Query<SiteField> query) {
        return this.getList(query);
    }

    @Override
    public Result<?> addLabels(String id, Reference ... labels) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/labels", Modification.cleanReferences(labels), new Header[0]);
    }

    @Override
    public Result<?> removeLabels(String id, Reference ... labels) {
        return this.worcadeClient.delete(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/labels", Modification.cleanReferences(labels), new Header[0]);
    }

    @Override
    public Result<?> addRemoteIds(String id, RemoteId ... remoteIds) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/remoteIds", Modification.cleanRemoteIds(remoteIds), new Header[0]);
    }

    @Override
    public Result<?> removeRemoteIds(String id, RemoteId ... remoteIds) {
        return this.worcadeClient.delete(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/remoteIds", Modification.cleanRemoteIds(remoteIds), new Header[0]);
    }

    @Override
    public Result<? extends Collection<? extends ReferenceWithName>> searchByEmail(String email) {
        return this.worcadeClient.getList(this.entityUrl + "/email?email=" + Util.escapeUrlQueryParameter(email), new Header[0]);
    }

    @Override
    public Result<? extends Collection<? extends RemoteIdSearchResult>> searchByRemoteId(String remoteIdType, String remoteId) {
        if (Strings.isNullOrEmpty((String)remoteIdType)) {
            return this.worcadeClient.getList(this.entityUrl + "/remoteId", new Header[0]);
        }
        if (Strings.isNullOrEmpty((String)remoteId)) {
            return this.worcadeClient.getList(this.entityUrl + "/remoteId?remoteIdType=" + Util.escapeUrlQueryParameter(remoteIdType), new Header[0]);
        }
        return this.worcadeClient.getList(this.entityUrl + "/remoteId?remoteIdType=" + Util.escapeUrlQueryParameter(remoteIdType) + "&remoteId=" + Util.escapeUrlQueryParameter(remoteId), new Header[0]);
    }

    @Override
    public Result<PublicKey> setupKeyExchange(String id, PublicKey applicationKey) {
        return Util.getPublicKeySpec(applicationKey).flatMap(s -> this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/authentication", ImmutableMap.of((Object)"modulus", (Object)s.getModulus(), (Object)"exponent", (Object)s.getPublicExponent()), new Header[0])).flatMap(d -> Util.createPublicKey(new BigInteger(d.getString("modulus")), new BigInteger(d.getString("exponent"))));
    }

    @Override
    public Result<?> cancelAccount(String id, String password) {
        Result<IncomingDto> result = this.worcadeClient.delete(this.entityUrl + "/" + WorcadeClient.checkId(id), new Header("Worcade-ConfirmPassword", Util.encodeBase64(password)));
        if (result.isOk()) {
            this.worcadeClient.logoutUser();
        }
        return result;
    }

    @Override
    public Result<?> view(String id) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/view", null, new Header[0]);
    }

    @Override
    public Result<?> addContent(String id, Reference ... content) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/content", Modification.cleanReferences(content), new Header[0]);
    }

    @Override
    public Result<?> addMessage(String id, String message) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/content/message", ImmutableMap.of((Object)"text", (Object)message), new Header[0]);
    }

    @Override
    public Result<?> addHtmlMessage(String id, String message) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/content/message/html", ImmutableMap.of((Object)"text", (Object)message), new Header[0]);
    }

    @Override
    public Result<?> addEvaluation(String id, int rating) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/content/evaluation", ImmutableMap.of((Object)"rating", (Object)rating), new Header[0]);
    }

    @Override
    public Result<?> addExternalNumbers(String id, ExternalNumber ... numbers) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/externalNumbers", Modification.cleanExternalNumbers(numbers), new Header[0]);
    }

    @Override
    public Result<?> addWatchers(String id, Reference ... watchers) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/watchers", Modification.cleanReferences(watchers), new Header[0]);
    }

    @Override
    public Result<?> removeWatchers(String id, Reference ... watchers) {
        return this.worcadeClient.delete(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/watchers", Modification.cleanReferences(watchers), new Header[0]);
    }

    @Override
    public Result<?> addOwners(String id, Reference ... owners) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/owners", Modification.cleanReferences(owners), new Header[0]);
    }

    @Override
    public Result<?> removeOwners(String id, Reference ... owners) {
        return this.worcadeClient.delete(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/owners", Modification.cleanReferences(owners), new Header[0]);
    }

    @Override
    public Result<?> addShares(String id, Reference ... shares) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/sharedWith", Modification.cleanReferences(shares), new Header[0]);
    }

    @Override
    public Result<?> removeShares(String id, Reference ... shares) {
        return this.worcadeClient.delete(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/sharedWith", Modification.cleanReferences(shares), new Header[0]);
    }

    @Override
    public Result<? extends Collection<? extends Contact>> getContacts(Query<ContactField> query) {
        return this.worcadeClient.getList(this.entityUrl, new Header[0]);
    }

    @Override
    public Result<? extends Collection<? extends Webhook>> getWebhookList(Query<WebhookField> query) {
        return this.getList(query);
    }

    @Override
    public Result<? extends Collection<? extends Webhook.Log>> getLogs(String id, boolean includeDeleted) {
        return this.worcadeClient.getList(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/logs?deleted=" + includeDeleted, new Header[0]);
    }

    @Override
    public Result<? extends WebhookTestResult> requestTest(String id) {
        String url = this.entityUrl + "/test/" + WorcadeClient.checkId(id);
        return this.worcadeClient.post(url, null, new Header[0]);
    }

    @Override
    public Result<? extends ReferenceWithName> searchByNumber(String conversationNumber) {
        return this.worcadeClient.get(this.entityUrl + "/number/" + Util.escapeUrlPathSegment(conversationNumber), new Header[0]);
    }

    @Override
    public Result<? extends Collection<? extends ReferenceWithName>> searchByContent(String contentId) {
        return this.worcadeClient.getList(this.entityUrl + "/content/" + WorcadeClient.checkId(contentId), new Header[0]);
    }

    @Override
    public Result<?> linkConversations(String firstId, String secondId) {
        return this.worcadeClient.post(this.entityUrl + "/linked/" + WorcadeClient.checkId(firstId) + "/" + WorcadeClient.checkId(secondId), null, new Header[0]);
    }

    @Override
    public Result<?> addVersions(String id, String ... versions) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/versions", ImmutableList.copyOf((Object[])versions), new Header[0]);
    }

    @Override
    public Result<BinaryData> getData(String id) {
        return this.worcadeClient.getBinary(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/data", new Header[0]);
    }

    @Override
    public Result<? extends Reference> create(String name, InputStream data, String contentType) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Name is mandatory");
        String url = this.entityUrl + "?name=" + Util.escapeUrlQueryParameter(name);
        return this.worcadeClient.postBinary(url, data, contentType, new Header[0]);
    }

    @Override
    public Result<?> addEmailAddress(String id, String ... emails) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/email", Stream.of(emails).map(e -> ImmutableMap.of((Object)"email", (Object)e)).collect(ImmutableList.toImmutableList()), new Header[0]);
    }

    @Override
    public Result<?> removeEmailAddress(String id, String ... emails) {
        return this.worcadeClient.delete(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/email", Stream.of(emails).map(e -> ImmutableMap.of((Object)"email", (Object)e)).collect(ImmutableList.toImmutableList()), new Header[0]);
    }

    @Override
    public Result<?> confirmEmailAddress(String id, String secret) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/confirmEmail", null, new Header("Worcade-Secret", secret));
    }

    @Override
    public Result<?> requestEmailConfirm(String id, String email) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/requestEmailConfirm", ImmutableMap.of((Object)"email", (Object)email), new Header[0]);
    }

    @Override
    public Result<?> addMembers(String id, Reference ... members) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/members", Modification.cleanReferences(members), new Header[0]);
    }

    @Override
    public Result<?> addMembers(String id, Collection<? extends Reference> members) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/members", Modification.cleanReferences(members), new Header[0]);
    }

    @Override
    public Result<?> removeMembers(String id, Reference ... members) {
        return this.worcadeClient.delete(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/members", Modification.cleanReferences(members), new Header[0]);
    }

    @Override
    public Result<? extends ReferenceWithName> searchByDomain(String domain) {
        return this.worcadeClient.get(this.entityUrl + "/domain?domain=" + Util.escapeUrlQueryParameter(domain), new Header[0]);
    }

    @Override
    public Result<?> addDomains(String id, String ... domains) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/domains", ImmutableList.copyOf((Object[])domains), new Header[0]);
    }

    @Override
    public Result<?> removeDomains(String id, String ... domains) {
        return this.worcadeClient.delete(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/domains", ImmutableList.copyOf((Object[])domains), new Header[0]);
    }

    @Override
    public Result<?> requestEmailReclaim(String email) {
        return this.worcadeClient.post(this.entityUrl + "/email?email=" + Util.escapeUrlQueryParameter(email), null, new Header[0]);
    }

    @Override
    public Result<?> confirmEmailReclaim(String id, String secret) {
        return this.worcadeClient.delete(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/email", new Header("Worcade-Secret", secret));
    }

    @Override
    public Result<?> changePassword(String id, String currentPassword, String newPassword) {
        return this.worcadeClient.put(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/password", ImmutableMap.of((Object)"password", (Object)Util.encodeBase64(newPassword)), new Header("Worcade-ConfirmPassword", Util.encodeBase64(currentPassword)));
    }

    @Override
    public Result<?> requestPasswordReset(String id) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/password", null, new Header[0]);
    }

    @Override
    public Result<?> requestPasswordResetByEmail(String email) {
        return this.worcadeClient.post(this.entityUrl + "/password/email?email=" + Util.escapeUrlQueryParameter(email), null, new Header[0]);
    }

    @Override
    public Result<?> confirmPasswordReset(String id, String newPassword, String secret) {
        return this.worcadeClient.put(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/password", ImmutableMap.of((Object)"password", (Object)Util.encodeBase64(newPassword)), new Header("Worcade-Secret", secret));
    }

    @Override
    public Result<?> requestApplicationTrust(String userId, String applicationId) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(userId) + "/trust/" + WorcadeClient.checkId(applicationId), null, new Header[0]);
    }

    @Override
    public Result<?> confirmApplicationTrust(String userId, String secret) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(userId) + "/trustedApplication", null, new Header("Worcade-Secret", secret));
    }

    @Override
    public Result<?> unlinkApplication(String userId, String applicationId) {
        return this.worcadeClient.delete(this.entityUrl + "/" + WorcadeClient.checkId(userId) + "/trustedApplication", ImmutableMap.of((Object)"id", (Object)WorcadeClient.checkId(applicationId)), new Header[0]);
    }

    @Override
    public Result<?> requestSubscription(String id) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/mailinglist", null, new Header[0]);
    }

    @Override
    public Result<?> addRows(String id, WorkOrder.Row ... rows) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/row", Modification.cleanRows(rows), new Header[0]);
    }

    @Override
    public Result<?> updateRow(String workOrderId, WorkOrderRowModification subject) {
        Modification modification = (Modification)subject;
        String id = (String)modification.getData().get("id");
        return this.worcadeClient.put(this.entityUrl + "/" + WorcadeClient.checkId(workOrderId) + "/row/" + WorcadeClient.checkId(id), ((Modification)subject).getData(), new Header[0]);
    }

    @Override
    public Result<?> removeRows(String id, String ... rowIdsToRemove) {
        return this.removeRows(id, Arrays.asList(rowIdsToRemove));
    }

    @Override
    public Result<?> removeRows(String id, Collection<String> rowIdsToRemove) {
        return this.worcadeClient.delete(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/row", rowIdsToRemove.stream().map(Modification::cleanReference).collect(ImmutableList.toImmutableList()), new Header[0]);
    }

    @Override
    public Result<?> updateMemberProfile(UserModification modification) {
        String userId = WorcadeClient.checkId((String)((Modification)modification).getData().get("id"));
        return this.worcadeClient.put(this.entityUrl + "/member/" + userId + "/profile", ((Modification)modification).getData(), new Header[0]);
    }

    @Override
    public Result<?> deleteMember(String userId) {
        return this.worcadeClient.delete(this.entityUrl + "/member/" + WorcadeClient.checkId(userId), new Header[0]);
    }

    public Result<IncomingDto> getSamlSettings(String companyId) {
        return this.worcadeClient.get(this.entityUrl + "/" + WorcadeClient.checkId(companyId) + "/saml", new Header[0]);
    }

    @Override
    public Result<?> setSamlSettings(String companyId, String entityId, String ssoServiceUrl, String certificate, @Nullable String attributeName, boolean allowCreate) {
        ImmutableMap values = attributeName == null ? ImmutableMap.of((Object)"entityId", (Object)entityId, (Object)"ssoServiceUrl", (Object)ssoServiceUrl, (Object)"certificate", (Object)certificate, (Object)"allowCreateNewUsers", (Object)allowCreate) : ImmutableMap.of((Object)"entityId", (Object)entityId, (Object)"ssoServiceUrl", (Object)ssoServiceUrl, (Object)"certificate", (Object)certificate, (Object)"attribute", (Object)attributeName, (Object)"allowCreateNewUsers", (Object)allowCreate);
        return this.worcadeClient.put(this.entityUrl + "/" + WorcadeClient.checkId(companyId) + "/saml", values, new Header[0]);
    }

    @Override
    public Result<?> setSamlSettings(String companyId, String entityId, String metadataUrl, @Nullable String attributeName, boolean allowCreate) {
        ImmutableMap values = attributeName == null ? ImmutableMap.of((Object)"entityId", (Object)entityId, (Object)"metadataUrl", (Object)metadataUrl, (Object)"allowCreateNewUsers", (Object)allowCreate) : ImmutableMap.of((Object)"entityId", (Object)entityId, (Object)"metadataUrl", (Object)metadataUrl, (Object)"attribute", (Object)attributeName, (Object)"allowCreateNewUsers", (Object)allowCreate);
        return this.worcadeClient.put(this.entityUrl + "/" + WorcadeClient.checkId(companyId) + "/saml", values, new Header[0]);
    }

    @Override
    public Result<? extends Collection<? extends Reference>> getByFingerprint(String fingerprint) {
        return this.worcadeClient.getList(this.entityUrl + "/fingerprint/" + Util.escapeUrlPathSegment(fingerprint), new Header[0]);
    }

    @Override
    public Result<? extends Collection<? extends ApiKey>> getApiKeys(String id) {
        return this.worcadeClient.getList(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/apikey/", new Header[0]);
    }

    @Override
    public Result<String> createApiKey(String id, String description) {
        Result<IncomingDto> result = this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/apikey?apiKeyDescription=" + Util.escapeUrlQueryParameter(description), null, new Header[0]);
        if (!result.isOk()) {
            return result.cast();
        }
        return Result.ok(((Result.Message)Iterables.find(result.getMessages(), m -> m.isCode(Code.GENERATED_API_KEY))).getMessage());
    }

    @Override
    public Result<?> removeApiKey(String id, String keyId) {
        return this.worcadeClient.delete(this.entityUrl + "/" + WorcadeClient.checkId(id) + "/apikey/" + WorcadeClient.checkId(keyId), new Header[0]);
    }

    @Override
    public Result<?> inviteUser(String companyId, String userId) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(companyId) + "/invite/" + WorcadeClient.checkId(userId), null, new Header[0]);
    }

    @Override
    public Result<?> addUser(String companyId, String userId) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(companyId) + "/addUser/" + WorcadeClient.checkId(userId), null, new Header[0]);
    }

    @Override
    public Result<?> addApplication(String companyId, String applicationId) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(companyId) + "/addApplication/" + WorcadeClient.checkId(applicationId), null, new Header[0]);
    }

    @Override
    public Result<?> confirmJoinCompany(String userId, String secret) {
        return this.worcadeClient.post(this.entityUrl + "/" + WorcadeClient.checkId(userId) + "/acceptInvite", null, new Header("Worcade-Secret", secret));
    }

    @Override
    public Result<?> editMessage(String conversationId, String messageId, String message) {
        return this.worcadeClient.put(this.entityUrl + "/" + WorcadeClient.checkId(conversationId) + "/message/" + WorcadeClient.checkId(messageId), ImmutableMap.of((Object)"text", (Object)message), new Header[0]);
    }

    private Result<IncomingDto> createInternal(EntityModification subject) {
        return this.worcadeClient.post(this.entityUrl, ((Modification)subject).getData(), new Header[0]);
    }

    private Result<?> updateInternal(EntityModification subject, String urlSuffix, boolean withVersionCheck) {
        Modification modification = (Modification)subject;
        String url = this.entityUrl + "/" + WorcadeClient.checkId((String)modification.getData().get("id")) + urlSuffix;
        if (withVersionCheck) {
            int version = (Integer)modification.getData().get("version");
            return this.worcadeClient.put(url + "?version=" + version, modification.getData(), new Header[0]);
        }
        return this.worcadeClient.put(url, modification.getData(), new Header[0]);
    }

    private Result<List<IncomingDto>> getList(Query<?> query) {
        return this.worcadeClient.getList(this.entityUrl + "/" + ((WorcadeQuery)query).toQueryString(), new Header[0]);
    }
}

