/*
 * Decompiled with CFR 0.152.
 */
package net.worcade.client.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import net.worcade.client.exception.InvalidValueTypeException;
import net.worcade.client.get.ApiKey;
import net.worcade.client.get.ApplicationProfile;
import net.worcade.client.get.Asset;
import net.worcade.client.get.Attachment;
import net.worcade.client.get.Authentication;
import net.worcade.client.get.Checklist;
import net.worcade.client.get.CompanyProfile;
import net.worcade.client.get.Contact;
import net.worcade.client.get.Conversation;
import net.worcade.client.get.ConversationContent;
import net.worcade.client.get.ConversationEvent;
import net.worcade.client.get.Email;
import net.worcade.client.get.ExternalNumber;
import net.worcade.client.get.GroupProfile;
import net.worcade.client.get.Label;
import net.worcade.client.get.Markup;
import net.worcade.client.get.Notification;
import net.worcade.client.get.Reference;
import net.worcade.client.get.ReferenceWithName;
import net.worcade.client.get.ReferenceWithNumber;
import net.worcade.client.get.RemoteId;
import net.worcade.client.get.RemoteIdSearchResult;
import net.worcade.client.get.Room;
import net.worcade.client.get.SamlSettings;
import net.worcade.client.get.Site;
import net.worcade.client.get.UserProfile;
import net.worcade.client.get.View;
import net.worcade.client.get.Webhook;
import net.worcade.client.get.WebhookTestResult;
import net.worcade.client.get.WorkOrder;
import net.worcade.client.internal.Modification;

public class IncomingDto
implements ApplicationProfile,
Asset,
Attachment,
Checklist,
CompanyProfile,
Contact,
Conversation,
GroupProfile,
Label,
Room,
Site,
UserProfile,
Webhook,
WorkOrder,
ApiKey,
Site.Coordinates,
RemoteId,
RemoteIdSearchResult,
ExternalNumber,
ConversationContent,
ConversationEvent,
Markup,
View,
Webhook.Header,
Webhook.Log,
WebhookTestResult,
ReferenceWithNumber,
Notification,
Notification.Tracking,
WorkOrder.Row,
Checklist.Row,
Email,
SamlSettings,
Authentication {
    private final ImmutableMap<String, Object> data;

    static IncomingDto of(Map<String, Object> data) {
        return data == null ? null : new IncomingDto(data);
    }

    private IncomingDto(Map<String, Object> data) {
        this.data = ImmutableMap.copyOf((Map)Maps.filterValues(data, Objects::nonNull));
    }

    String getString(String key) {
        return this.get(key, String.class, true);
    }

    int getInt(String key) {
        return this.get(key, Integer.class, false);
    }

    private Integer getInteger(String key) {
        return this.get(key, Integer.class, true);
    }

    private Long getLong(String key) {
        return this.get(key, Long.class, true);
    }

    private Instant getTimestamp(String key) {
        Integer timestamp = this.getInteger(key);
        return timestamp == null ? null : Instant.ofEpochSecond(timestamp.intValue());
    }

    private Float getFloat(String key) {
        return Float.valueOf(this.get(key, Double.class, false).floatValue());
    }

    IncomingDto getDto(String key) {
        Map data = this.get(key, Map.class, true);
        return IncomingDto.of(data);
    }

    private List<IncomingDto> getListOfDtos(String key) {
        List data = this.get(key, List.class, true);
        return data == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)Lists.transform((List)data, IncomingDto::of));
    }

    private <T> List<T> getList(String key) {
        List data = this.get(key, List.class, true);
        return data == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)data);
    }

    boolean getBoolean(String key) {
        return this.get(key, Boolean.class, false);
    }

    private Boolean getNullableBoolean(String key) {
        return this.get(key, Boolean.class, true);
    }

    @Override
    public Modification modify() {
        return Modification.update(this.data);
    }

    @Override
    public String getId() {
        return this.getString("id");
    }

    @Override
    public int getVersion() {
        return this.getInt("version");
    }

    @Override
    public String getType() {
        return this.getString("type");
    }

    @Override
    public int getStart() {
        return this.getInt("start");
    }

    @Override
    public int getEnd() {
        return this.getInt("end");
    }

    @Override
    public boolean isDeleted() {
        return this.getBoolean("deleted");
    }

    @Override
    public Instant created() {
        return this.getTimestamp("created");
    }

    @Override
    public ReferenceWithName createdBy() {
        return this.getDto("creator");
    }

    @Override
    public Instant getModified() {
        return this.getTimestamp("modified");
    }

    @Override
    public ReferenceWithName modifier() {
        return this.getDto("modifier");
    }

    @Override
    public String getName() {
        return this.getString("name");
    }

    @Override
    public String getNumber() {
        return this.getString("number");
    }

    @Override
    public String getDescription() {
        return this.getString("description");
    }

    @Override
    public String getEmail() {
        return this.getString("email");
    }

    @Override
    public String getFloor() {
        return this.getString("floor");
    }

    @Override
    public String getRoomNumber() {
        return this.getString("roomNumber");
    }

    @Override
    public String getAddressLineOne() {
        return this.getString("addressLineOne");
    }

    @Override
    public String getAddressLineTwo() {
        return this.getString("addressLineTwo");
    }

    @Override
    public String getPostalCode() {
        return this.getString("postalCode");
    }

    @Override
    public String getCity() {
        return this.getString("city");
    }

    @Override
    public String getRegion() {
        return this.getString("region");
    }

    @Override
    public String getCountry() {
        return this.getString("country");
    }

    @Override
    public String getTelephone() {
        return this.getString("telephone");
    }

    @Override
    public String getAssetType() {
        return this.getString("assetType");
    }

    @Override
    public String getAssetMake() {
        return this.getString("assetMake");
    }

    @Override
    public String getAssetModel() {
        return this.getString("assetModel");
    }

    @Override
    public String getSerial() {
        return this.getString("serial");
    }

    @Override
    public String getSpecification() {
        return this.getString("specification");
    }

    @Override
    public String getRemoteIdType() {
        return this.getString("remoteIdType");
    }

    @Override
    public String getRemoteId() {
        return this.getString("remoteId");
    }

    @Override
    public Site.Coordinates getCoordinates() {
        return this.getDto("coordinates");
    }

    @Override
    public float getLatitude() {
        return this.getFloat("latitude").floatValue();
    }

    @Override
    public float getLongitude() {
        return this.getFloat("longitude").floatValue();
    }

    @Override
    public Collection<? extends ReferenceWithName> getLabels() {
        return this.getListOfDtos("labels");
    }

    @Override
    public Collection<? extends ReferenceWithName> getOwners() {
        return this.getListOfDtos("owners");
    }

    @Override
    public Collection<? extends RemoteId> getRemoteIds() {
        return this.getListOfDtos("remoteIds");
    }

    @Override
    public boolean hasPassword() {
        return this.getBoolean("hasPassword");
    }

    @Override
    public Locale getLocale() {
        IncomingDto locale = this.getDto("locale");
        return locale == null ? null : new Locale(locale.getString("language"), locale.getString("country"));
    }

    @Override
    public ReferenceWithName getLocation() {
        return this.getDto("location");
    }

    @Override
    public ReferenceWithName getPicture() {
        return this.getDto("picture");
    }

    @Override
    public Collection<? extends ReferenceWithName> getProGroups() {
        return this.getListOfDtos("proGroups");
    }

    @Override
    public String getMailImportAddress() {
        return this.getString("mailImportAddress");
    }

    @Override
    public ReferenceWithName getAutoShareTarget() {
        return this.getDto("autoShareTarget");
    }

    @Override
    public boolean isSuppressUpdateNotifications() {
        return this.getBoolean("suppressUpdateNotifications");
    }

    @Override
    public boolean isSubscribedToGettingStarted() {
        return this.getBoolean("subscribeGettingStarted");
    }

    @Override
    public boolean isSubscribedToNewsletter() {
        return this.getBoolean("subscribeNewsletter");
    }

    @Override
    public Collection<? extends ReferenceWithName> getTrustedApplications() {
        return this.getListOfDtos("trustedApplications");
    }

    @Override
    public Collection<? extends ExternalNumber> getExternalNumbers() {
        return this.getListOfDtos("externalNumbers");
    }

    @Override
    public ReferenceWithName getAssignee() {
        return this.getDto("assignee");
    }

    @Override
    public ReferenceWithName getReporter() {
        return this.getDto("reporter");
    }

    @Override
    public Instant getLastContentTimestamp() {
        return this.getTimestamp("lastContent");
    }

    @Override
    public Collection<? extends ConversationContent> getConversationContent() {
        return this.getListOfDtos("content");
    }

    @Override
    public Collection<? extends ConversationEvent> getEvents() {
        return this.getListOfDtos("events");
    }

    @Override
    public Reference getContent() {
        return this.getDto("content");
    }

    @Override
    public Instant getTimestamp() {
        return this.getTimestamp("timestamp");
    }

    @Override
    public ReferenceWithName getSource() {
        return this.getDto("source");
    }

    @Override
    public String getMessage() {
        return this.getString("message");
    }

    @Override
    public int getRating() {
        return this.getInt("rating");
    }

    @Override
    public Collection<? extends Markup> getMarkup() {
        return this.getListOfDtos("markups");
    }

    @Override
    public boolean isPro() {
        return this.getBoolean("pro");
    }

    @Override
    public boolean isVisible() {
        return this.getBoolean("visible");
    }

    @Override
    public Collection<String> getDomains() {
        return this.getList("domains");
    }

    @Override
    public Collection<? extends ReferenceWithName> getMembers() {
        return this.getListOfDtos("members");
    }

    @Override
    public ReferenceWithName getCompany() {
        return this.getDto("company");
    }

    @Override
    public String getUrl() {
        return this.getString("url");
    }

    @Override
    public String getEvent() {
        return this.getString("event");
    }

    @Override
    public boolean isSuppressOwn() {
        return this.getBoolean("suppressOwn");
    }

    @Override
    public Collection<? extends Webhook.Header> getHeaders() {
        return this.getListOfDtos("headers");
    }

    @Override
    public Integer getStatus() {
        return this.getInteger("status");
    }

    @Override
    public String getResponseBody() {
        return this.getString("response");
    }

    @Override
    public String getValue() {
        return this.getString("value");
    }

    @Override
    public String getBackgroundColor() {
        return this.getString("backgroundColor");
    }

    @Override
    public String getForegroundColor() {
        return this.getString("foregroundColor");
    }

    @Override
    public Reference forGroup() {
        return this.getDto("forGroup");
    }

    @Override
    public String getMimeType() {
        return this.getString("mimeType");
    }

    @Override
    public int getSize() {
        return this.getInt("size");
    }

    @Override
    public Integer getHeight() {
        return this.getInteger("height");
    }

    @Override
    public Integer getWidth() {
        return this.getInteger("width");
    }

    @Override
    public Reference getTarget() {
        return this.getDto("target");
    }

    @Override
    public ReferenceWithName getSubject() {
        return this.getDto("subject");
    }

    @Override
    public String getContext() {
        return this.getString("context");
    }

    @Override
    public Collection<? extends Notification.Tracking> getTrackings() {
        return this.getListOfDtos("trackings");
    }

    public Collection<IncomingDto> getRows() {
        return this.getListOfDtos("rows");
    }

    @Override
    public boolean isApproved() {
        return Objects.equals(true, this.getNullableBoolean("approved"));
    }

    @Override
    public boolean isRejected() {
        return Objects.equals(false, this.getNullableBoolean("approved"));
    }

    @Override
    public Duration getDuration() {
        Long duration = this.getLong("duration");
        return duration == null ? null : Duration.of(duration, ChronoUnit.SECONDS);
    }

    @Override
    public Double getCostAmount() {
        return this.get("costAmount", Double.class, true);
    }

    @Override
    public Currency getCostCurrency() {
        return Currency.getInstance(this.getString("costCurrency"));
    }

    @Override
    public String getBody() {
        return this.getString("body");
    }

    @Override
    public boolean confirmed() {
        return this.getBoolean("confirmed");
    }

    @Override
    public boolean hasSaml() {
        return this.getBoolean("hasSaml");
    }

    @Override
    public Collection<? extends Email> getSecondaryEmails() {
        return this.getListOfDtos("secondaryEmails");
    }

    @Override
    public Reference getMainGroup() {
        return this.getDto("mainGroup");
    }

    @Override
    public String getEntityId() {
        return this.getString("entityId");
    }

    @Override
    public String getSsoServiceUrl() {
        return this.getString("ssoServiceUrl");
    }

    @Override
    public String getCertificate() {
        return this.getString("certificate");
    }

    @Override
    public String getFingerprint() {
        return this.getString("fingerprint");
    }

    @Override
    public Collection<? extends Reference> getLinkedConversations() {
        return this.getListOfDtos("linkedConversations");
    }

    @Override
    public Collection<? extends View> getViews() {
        return this.getListOfDtos("views");
    }

    @Override
    public ReferenceWithName getUser() {
        return this.getDto("user");
    }

    @Override
    public ReferenceWithName getApplication() {
        return this.getDto("application");
    }

    @Override
    public ReferenceWithName getAdminUser() {
        return this.getDto("adminUser");
    }

    @Override
    public Collection<? extends ReferenceWithName> getWatchers() {
        return this.getListOfDtos("watchers");
    }

    @Override
    public boolean isChecked() {
        return this.getBoolean("check");
    }

    @Override
    public Instant getLastView() {
        return this.getTimestamp("lastView");
    }

    @Override
    public Boolean isInfected() {
        return this.getNullableBoolean("infected");
    }

    @Override
    public Collection<? extends ReferenceWithName> getInvolvedCompanies() {
        return this.getListOfDtos("involvedCompanies");
    }

    @Override
    public String getNotes() {
        return this.getString("notes");
    }

    @Override
    public Collection<? extends ReferenceWithName> getSharedWith() {
        return this.getListOfDtos("sharedWith");
    }

    @Override
    public boolean isClosed() {
        return this.getBoolean("closed");
    }

    @Override
    public String getMetadataUrl() {
        return this.getString("metadataUrl");
    }

    @Override
    public String getAttribute() {
        return this.getString("attribute");
    }

    @Override
    public Collection<String> getVersions() {
        return this.getList("versions");
    }

    private <T> T get(String key, Class<T> type, boolean allowNull) {
        Object value = this.data.get((Object)key);
        if (type.isInstance(value)) {
            Object typedValue = value;
            return (T)typedValue;
        }
        if (allowNull && value == null) {
            return null;
        }
        throw new InvalidValueTypeException(type, key, value);
    }

    @Generated
    public String toString() {
        return "IncomingDto(data=" + this.getData() + ")";
    }

    @Generated
    ImmutableMap<String, Object> getData() {
        return this.data;
    }
}

