/*
 * Decompiled with CFR 0.152.
 */
package net.worcade.client;

import com.google.common.collect.Iterables;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.Duration;
import java.util.Collection;
import java.util.Currency;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import net.worcade.client.Code;
import net.worcade.client.Result;
import net.worcade.client.Version;
import net.worcade.client.WorcadeBuilder;
import net.worcade.client.api.ApplicationApi;
import net.worcade.client.api.AssetApi;
import net.worcade.client.api.AttachmentApi;
import net.worcade.client.api.ChecklistApi;
import net.worcade.client.api.CompanyApi;
import net.worcade.client.api.ContactsApi;
import net.worcade.client.api.ConversationApi;
import net.worcade.client.api.GroupApi;
import net.worcade.client.api.LabelApi;
import net.worcade.client.api.ReclaimApi;
import net.worcade.client.api.RoomApi;
import net.worcade.client.api.SearchApi;
import net.worcade.client.api.SiteApi;
import net.worcade.client.api.UserApi;
import net.worcade.client.api.WebhookApi;
import net.worcade.client.api.WorkOrderApi;
import net.worcade.client.get.Authentication;
import net.worcade.client.get.ExternalNumber;
import net.worcade.client.get.Notification;
import net.worcade.client.get.Reference;
import net.worcade.client.get.ReferenceWithName;
import net.worcade.client.get.RemoteId;
import net.worcade.client.get.Webhook;
import net.worcade.client.get.WorkOrder;

@CheckReturnValue
public interface Worcade {
    public static final Version VERSION = new Version(2, 13, 0);

    public static WorcadeBuilder builder() {
        return ServiceLoader.load(WorcadeBuilder.class).iterator().next();
    }

    public Result<ReferenceWithName> loginUserByEmail(String var1, String var2);

    public Result<ReferenceWithName> loginUserById(String var1, String var2);

    public Result<ReferenceWithName> setUserApiKey(String var1);

    public Result<?> logoutUser();

    public Result<ReferenceWithName> loginApplication(String var1, PrivateKey var2, PublicKey var3);

    public Result<ReferenceWithName> setApplicationApiKey(String var1);

    public Result<?> logoutApplication();

    public Result<ReferenceWithName> setApplicationSourceAuth(String var1);

    public Result<? extends Authentication> setTrustedUser(Reference var1);

    public Result<Boolean> probeUserTrust(String var1, String var2);

    public Result<? extends Authentication> getAuthentication();

    public Result<? extends Authentication> loginAdmin(String var1, String var2, String var3);

    public Result<? extends Authentication> upgradeToAdmin(String var1, String var2);

    public Result<?> logoutAdmin();

    public Result<? extends Collection<? extends Notification>> getNotifications();

    public RemoteId createRemoteId(String var1, String var2);

    public ExternalNumber createExternalNumber(String var1, String var2);

    public Webhook.Header createWebhookHeader(String var1, String var2);

    public WorkOrder.Row createWorkOrderRow(String var1, Duration var2, Double var3, Currency var4);

    public ApplicationApi getApplicationApi();

    public AssetApi getAssetApi();

    public AttachmentApi getAttachmentApi();

    public ChecklistApi getChecklistApi();

    public CompanyApi getCompanyApi();

    public ContactsApi getContactsApi();

    public ConversationApi getConversationApi();

    public GroupApi getGroupApi();

    public LabelApi getLabelApi();

    public ReclaimApi getReclaimApi();

    public RoomApi getRoomApi();

    public SearchApi getSearchApi();

    public SiteApi getSiteApi();

    public UserApi getUserApi();

    public WebhookApi getWebhookApi();

    public WorkOrderApi getWorkOrderApi();

    public Result<?> log(String var1);

    public Worcade copyWithSameAuth();

    public void close();

    public static <T> Result<T> withRetry(Supplier<Result<T>> method) {
        Result<T> result = method.get();
        if (!result.isOk() && Iterables.all(result.getMessages(), m -> m.isCode(Code.CONFLICT_ALLOW_RETRY))) {
            return Worcade.withRetry(method);
        }
        return result;
    }
}

