/*
 * Decompiled with CFR 0.152.
 */
package net.worcade.client.internal;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.SyncInvoker;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import lombok.Generated;
import net.worcade.client.Code;
import net.worcade.client.Result;
import net.worcade.client.Worcade;
import net.worcade.client.WorcadeBuilder;
import net.worcade.client.get.BinaryData;
import net.worcade.client.internal.Envelope;
import net.worcade.client.internal.EtagFilter;
import net.worcade.client.internal.Header;
import net.worcade.client.internal.IncomingDto;
import net.worcade.client.internal.WorcadeClient;
import org.glassfish.jersey.logging.LoggingFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyClient
extends WorcadeClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JerseyClient.class);
    private static final GenericType<Envelope> ENVELOPE_TYPE = new GenericType<Envelope>(){};
    private final Client client;

    private JerseyClient(String baseUrl, Client client) {
        super(baseUrl);
        this.client = client;
    }

    protected WorcadeClient copy() {
        return new JerseyClient(this.getBaseUrl(), this.client);
    }

    protected Result<IncomingDto> get(String url, Header ... additionalHeader) {
        Invocation.Builder request = this.target(this.getBaseUrl() + url, additionalHeader);
        return this.handle("GET", url, request, SyncInvoker::get).map(DTO_FUNCTION);
    }

    protected Result<List<IncomingDto>> getList(String url, Header ... additionalHeader) {
        Invocation.Builder request = this.target(this.getBaseUrl() + url, additionalHeader);
        return this.handle("GET", url, request, SyncInvoker::get).map(l -> {
            List list = (List)l;
            return ImmutableList.copyOf((Collection)Lists.transform((List)list, DTO_FUNCTION::apply));
        });
    }

    protected Result<BinaryData> getBinary(String url, Header ... additionalHeader) {
        Response response = this.target(this.getBaseUrl() + url, additionalHeader).get();
        log.debug("GET request to {} returned with status {}", (Object)(this.getBaseUrl() + url), (Object)response.getStatus());
        if (response.getStatus() == 429) {
            return Result.failed((List)ImmutableList.of((Object)new Result.Message(null, "Too many requests")));
        }
        return Result.ok((Object)new BinaryData(response.getHeaderString("Content-Disposition"), (InputStream)response.getEntity(), response.getMediaType().toString()));
    }

    protected Result<IncomingDto> post(String url, Object data, Header ... additionalHeader) {
        Invocation.Builder request = this.target(this.getBaseUrl() + url, additionalHeader);
        return this.handle("POST", url, request, b -> b.post(this.toEntity(data))).map(DTO_FUNCTION);
    }

    private Entity<?> toEntity(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Entity) {
            return (Entity)data;
        }
        return Entity.entity((Object)data, (MediaType)MediaType.APPLICATION_JSON_TYPE);
    }

    protected Result<IncomingDto> postBinary(String url, InputStream data, String contentType, Header ... additionalHeader) {
        Invocation.Builder request = this.target(this.getBaseUrl() + url, additionalHeader);
        return this.handle("POST", url, request, b -> b.post(Entity.entity((Object)data, (String)contentType))).map(DTO_FUNCTION);
    }

    protected Result<IncomingDto> put(String url, Object data, Header ... additionalHeader) {
        Invocation.Builder request = this.target(this.getBaseUrl() + url, additionalHeader);
        return this.handle("PUT", url, request, b -> b.put(Entity.entity((Object)data, (MediaType)MediaType.APPLICATION_JSON_TYPE))).map(DTO_FUNCTION);
    }

    protected Result<IncomingDto> delete(String url, Header ... additionalHeader) {
        Invocation.Builder request = this.target(this.getBaseUrl() + url, additionalHeader);
        return this.handle("DELETE", url, request, SyncInvoker::delete).map(DTO_FUNCTION);
    }

    protected Result<IncomingDto> delete(String url, Object data, Header ... additionalHeader) {
        Invocation.Builder request = this.target(this.getBaseUrl() + url, additionalHeader);
        return this.handle("DELETE", url, request, b -> b.property("jersey.config.client.suppressHttpComplianceValidation", (Object)true).method("DELETE", Entity.entity((Object)data, (MediaType)MediaType.APPLICATION_JSON_TYPE))).map(DTO_FUNCTION);
    }

    protected <V> Result<V> custom(String method, String url, Class<V> responseType, Header ... allHeaders) {
        Invocation.Builder request = this.client.target(this.getBaseUrl() + url).request();
        return this.custom(method, url, responseType, request, allHeaders);
    }

    protected <V> Result<V> customWithAuth(String method, String url, Class<V> responseType, Header ... additionalHeaders) {
        Invocation.Builder request = this.target(this.getBaseUrl() + url, additionalHeaders);
        return this.custom(method, url, responseType, request, additionalHeaders);
    }

    private <V> Result<V> custom(String method, String url, Class<V> responseType, Invocation.Builder request, Header[] allHeaders) {
        for (Header header : allHeaders) {
            request.header(header.getName(), (Object)header.getValue());
        }
        Response response = request.method(method);
        return this.handle(method, url, response, new GenericType(responseType), v -> v);
    }

    public void close() {
        this.client.close();
    }

    private Result<Object> handle(String method, String url, Invocation.Builder request, Function<Invocation.Builder, Response> handler) {
        Response response;
        try {
            response = handler.apply(request);
        }
        catch (ProcessingException e) {
            return Result.failed((List)ImmutableList.of((Object)new Result.Message(Code.NO_CONNECTION, "Couldn't connect to Worcade")));
        }
        return this.handle(method, url, response, ENVELOPE_TYPE, Envelope::getData);
    }

    private <T, V> Result<V> handle(String method, String url, Response response, GenericType<T> responseType, Function<T, V> mapper) {
        Object responseEntity;
        if (response.getStatus() == 429) {
            return Result.failed((List)ImmutableList.of((Object)new Result.Message(null, "Too many requests")));
        }
        ImmutableList.Builder messages = ImmutableList.builder();
        if (response.getStatus() == 502 || response.getStatus() == 503 || response.getStatus() == 504) {
            messages.add((Object)new Result.Message(Code.NO_CONNECTION, "Couldn't connect to Worcade"));
        }
        try {
            responseEntity = response.readEntity(responseType);
            if (responseEntity instanceof Envelope && ((Envelope)responseEntity).getMessages() != null) {
                for (Envelope.Message message : ((Envelope)responseEntity).getMessages()) {
                    messages.add((Object)new Result.Message(Code.forCode((Integer)message.getCode()), message.getMessage()));
                }
            }
        }
        catch (NullPointerException | ProcessingException e) {
            log.debug("Error parsing response to {} {}{} with status {}", new Object[]{method, this.getBaseUrl(), url, response.getStatus(), e});
            messages.add((Object)new Result.Message(null, "Exception while parsing response to " + method + " " + this.getBaseUrl() + url + ", with status " + response.getStatus()));
            return Result.failed((List)messages.build());
        }
        ImmutableList messageList = messages.build();
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            if (!messageList.isEmpty()) {
                log.debug("{} request to {} succeeded with status {} and messages {}", new Object[]{method, this.getBaseUrl() + url, response.getStatus(), messageList});
            } else {
                log.trace("{} request to {} succeeded with status {}", new Object[]{method, this.getBaseUrl() + url, response.getStatus()});
            }
            return Result.ok(mapper.apply(responseEntity), (List)messageList);
        }
        log.debug("{} request to {} failed with status {} and messages {}", new Object[]{method, this.getBaseUrl() + url, response.getStatus(), messageList});
        return Result.failed((List)messageList);
    }

    private Invocation.Builder target(String url, Header ... additionalHeaders) {
        Invocation.Builder builder = this.client.target(url).request().header("Worcade-Admin", (Object)this.getAdminHeader()).header("Worcade-User", (Object)this.getUserHeader()).header("Worcade-Application", (Object)this.getApplicationHeader());
        for (Header header : additionalHeaders) {
            builder.header(header.getName(), (Object)header.getValue());
        }
        return builder;
    }

    @Generated
    public String toString() {
        return "JerseyClient(client=" + this.client + ")";
    }

    public static class JerseyClientBuilder
    implements WorcadeBuilder {
        private String baseUrl = "https://worcade.net";
        private boolean enableETagCache = true;

        public WorcadeBuilder disableETagCache() {
            this.enableETagCache = false;
            return this;
        }

        public WorcadeClient buildWithoutVersionCheck() {
            ClientBuilder builder = (ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JacksonJsonProvider.class)).register((Object)new LoggingFeature());
            if (this.enableETagCache) {
                builder.register((Object)new EtagFilter());
            }
            return new JerseyClient(this.baseUrl, builder.build());
        }

        public Result<? extends Worcade> build() {
            try {
                return this.buildWithoutVersionCheck().checkServerVersion();
            }
            catch (ProcessingException e) {
                return Result.failed((List)ImmutableList.of((Object)new Result.Message(Code.NO_CONNECTION, "Couldn't connect to Worcade")));
            }
        }

        @Generated
        public JerseyClientBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }
    }
}

