/*
 * Decompiled with CFR 0.152.
 */
package net.worcade.client.internal;

import com.google.common.base.Ascii;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EtagFilter
implements ClientRequestFilter,
ClientResponseFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EtagFilter.class);
    private final Cache<String, CachedRequest> cache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).build();

    EtagFilter() {
    }

    public void filter(ClientRequestContext requestContext) {
        CachedRequest request = (CachedRequest)this.cache.getIfPresent((Object)requestContext.getUri().toString());
        if (request != null) {
            requestContext.getHeaders().putSingle((Object)"If-None-Match", (Object)request.getTag());
            log.trace("Adding {} header to request to {}", (Object)"If-None-Match", (Object)Ascii.truncate((CharSequence)requestContext.getUri().toString(), (int)50, (String)"..."));
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        String tag = responseContext.getHeaderString("ETag");
        String uri = requestContext.getUri().toString();
        if (responseContext.getStatus() == Response.Status.NOT_MODIFIED.getStatusCode()) {
            CachedRequest cachedRequest = (CachedRequest)this.cache.getIfPresent((Object)uri);
            byte[] body = cachedRequest.getBody();
            responseContext.setEntityStream((InputStream)new ByteArrayInputStream(body));
            responseContext.setStatusInfo(cachedRequest.getStatusInfo());
            this.replaceHeaders((MultivaluedMap<String, String>)responseContext.getHeaders(), cachedRequest.getHeaders());
            log.trace("Got response for {} from ETag cache", (Object)Ascii.truncate((CharSequence)uri, (int)50, (String)"..."));
        } else if (tag != null) {
            byte[] body = ByteStreams.toByteArray((InputStream)responseContext.getEntityStream());
            Closeables.closeQuietly((InputStream)responseContext.getEntityStream());
            this.cache.put((Object)uri, (Object)new CachedRequest(tag, responseContext.getStatusInfo(), body, this.save((MultivaluedMap<String, String>)responseContext.getHeaders())));
            responseContext.setEntityStream((InputStream)new ByteArrayInputStream(body));
            log.trace("Added response for {} to ETag cache", (Object)Ascii.truncate((CharSequence)uri, (int)50, (String)"..."));
        }
    }

    private Multimap<String, String> save(MultivaluedMap<String, String> headers) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (String header : headers.keySet()) {
            builder.putAll((Object)header, (Iterable)headers.get((Object)header));
        }
        return builder.build();
    }

    private void replaceHeaders(MultivaluedMap<String, String> target, Multimap<String, String> cached) {
        target.clear();
        for (String header : cached.keySet()) {
            target.put((Object)header, (Object)Lists.newArrayList((Iterable)cached.get((Object)header)));
        }
    }

    private static final class CachedRequest {
        private final String tag;
        private final Response.StatusType statusInfo;
        private final byte[] body;
        private final Multimap<String, String> headers;

        @ConstructorProperties(value={"tag", "statusInfo", "body", "headers"})
        @Generated
        public CachedRequest(String tag, Response.StatusType statusInfo, byte[] body, Multimap<String, String> headers) {
            this.tag = tag;
            this.statusInfo = statusInfo;
            this.body = body;
            this.headers = headers;
        }

        @Generated
        public String getTag() {
            return this.tag;
        }

        @Generated
        public Response.StatusType getStatusInfo() {
            return this.statusInfo;
        }

        @Generated
        public byte[] getBody() {
            return this.body;
        }

        @Generated
        public Multimap<String, String> getHeaders() {
            return this.headers;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CachedRequest)) {
                return false;
            }
            CachedRequest other = (CachedRequest)o;
            String this$tag = this.getTag();
            String other$tag = other.getTag();
            if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
                return false;
            }
            Response.StatusType this$statusInfo = this.getStatusInfo();
            Response.StatusType other$statusInfo = other.getStatusInfo();
            if (this$statusInfo == null ? other$statusInfo != null : !this$statusInfo.equals(other$statusInfo)) {
                return false;
            }
            if (!Arrays.equals(this.getBody(), other.getBody())) {
                return false;
            }
            Multimap<String, String> this$headers = this.getHeaders();
            Multimap<String, String> other$headers = other.getHeaders();
            return !(this$headers == null ? other$headers != null : !this$headers.equals(other$headers));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tag = this.getTag();
            result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
            Response.StatusType $statusInfo = this.getStatusInfo();
            result = result * 59 + ($statusInfo == null ? 43 : $statusInfo.hashCode());
            result = result * 59 + Arrays.hashCode(this.getBody());
            Multimap<String, String> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EtagFilter.CachedRequest(tag=" + this.getTag() + ", statusInfo=" + this.getStatusInfo() + ", body=" + Arrays.toString(this.getBody()) + ", headers=" + this.getHeaders() + ")";
        }
    }
}

