/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map.utils;

import java.io.IOException;
import java.net.URI;

public class UrlUtils {
    public static String urlToStringPath(String url) throws IOException {
        URI uri = URI.create(url);
        StringBuilder sb = new StringBuilder();
        String host = uri.getHost();
        String query = uri.getQuery();
        String path = uri.getPath();
        if (query != null) {
            query = query.replaceAll("\\b([^&=?]+)=", "");
            query = query.replace("/", ":");
        }
        if (host != null) {
            sb.append(host);
        }
        if (path != null) {
            sb.append(path);
        }
        if (query != null) {
            sb.append('?');
            sb.append(query);
        }
        int maxLen = 250;
        if (sb.length() >= 250) {
            throw new IOException("Cache key too long!");
        }
        String name = sb.toString();
        name = UrlUtils.normalizeUrl(name);
        return name;
    }

    private static String normalizeUrl(String name) {
        name = name.replaceAll("[?|&]", "/");
        name = name.replace(".", "_");
        return name;
    }

    private UrlUtils() {
    }
}

