/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static byte[] imageToBytes(BufferedImage image) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", byteStream);
        return byteStream.toByteArray();
    }

    public static BufferedImage imageFromBytes(byte[] imageData) throws IOException {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(imageData);
        return ImageIO.read(byteStream);
    }

    public static boolean imagesEqual(BufferedImage image1, BufferedImage image2) {
        if (image1.getWidth() != image2.getWidth() || image1.getHeight() != image2.getHeight()) {
            return false;
        }
        for (int x = 1; x < image2.getWidth(); ++x) {
            for (int y = 1; y < image2.getHeight(); ++y) {
                if (image1.getRGB(x, y) == image2.getRGB(x, y)) continue;
                return false;
            }
        }
        return true;
    }

    private ImageUtils() {
    }
}

