/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map.readers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.opengis.wmts.x10.CapabilitiesDocument;
import net.wirelabs.jmaps.map.Defaults;
import net.wirelabs.jmaps.map.exceptions.CriticalMapException;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMTSCapReader {
    private static final Logger log = LoggerFactory.getLogger(WMTSCapReader.class);
    private static Path descriptorCacheDir = Defaults.DEFAULT_WMTS_DESCRIPTOR_CACHE;

    public static CapabilitiesDocument.Capabilities loadCapabilities(String getCapabilitiesUrl) {
        try {
            URI uri = URI.create(getCapabilitiesUrl);
            File cachedFile = Paths.get(descriptorCacheDir.toString(), uri.getHost(), uri.getPath(), "capabilities.xml").toFile();
            if (!cachedFile.exists()) {
                log.info("Loading WMTS capabilities from {}", (Object)getCapabilitiesUrl);
                return WMTSCapReader.parseCapabilitiesFromNetwork(getCapabilitiesUrl, cachedFile);
            }
            log.info("Loading WMTS capabilities from cached file {}", (Object)cachedFile);
            return WMTSCapReader.parseCapabilitiesFromFile(cachedFile);
        }
        catch (Exception e) {
            String message = "Could not parse WMTS capabilities from " + getCapabilitiesUrl;
            log.warn(message);
            throw new CriticalMapException(message);
        }
    }

    private static CapabilitiesDocument.Capabilities parseCapabilitiesFromNetwork(String url, File cachedFile) throws IOException, XmlException {
        URL request = new URL(url);
        InputStream networkInputStream = request.openConnection().getInputStream();
        File tempFile = WMTSCapReader.createTempFile(networkInputStream);
        CapabilitiesDocument.Capabilities caps = WMTSCapReader.parseCapabilitiesFromFile(tempFile);
        WMTSCapReader.cacheFile(cachedFile, tempFile);
        return caps;
    }

    private static void cacheFile(File cachedFile, File tempFile) throws IOException {
        Files.createDirectories(cachedFile.toPath().getParent(), new FileAttribute[0]);
        Files.move(tempFile.toPath(), cachedFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private static File createTempFile(InputStream is) throws IOException {
        File tempFile = File.createTempFile("capabilities", ".xml");
        Files.copy(is, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return tempFile;
    }

    private static CapabilitiesDocument.Capabilities parseCapabilitiesFromFile(File capabilitiesFile) throws XmlException, IOException {
        CapabilitiesDocument c = (CapabilitiesDocument)CapabilitiesDocument.Factory.parse(capabilitiesFile);
        return c.getCapabilities();
    }

    public static void setCacheDir(Path cacheDir) {
        descriptorCacheDir = cacheDir;
    }

    private WMTSCapReader() {
    }
}

