/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map.layer;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import net.wirelabs.jmaps.map.geo.Coordinate;
import net.wirelabs.jmaps.map.geo.ProjectionEngine;
import net.wirelabs.jmaps.map.layer.LayerType;
import net.wirelabs.jmaps.model.map.LayerDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Layer {
    private static final Logger log = LoggerFactory.getLogger(Layer.class);
    protected final String name;
    protected final String url;
    protected LayerType type;
    protected String crs;
    protected int tileSize;
    protected int maxZoom;
    protected int minZoom;
    protected float opacity;
    protected int zoomOffset;
    protected boolean swapAxis;
    protected boolean enabled = true;
    private final ProjectionEngine projectionEngine = new ProjectionEngine();

    protected Layer(LayerDocument.Layer layerDefinition) {
        this.name = layerDefinition.getName();
        this.url = layerDefinition.getUrl();
        this.type = LayerType.valueOf(layerDefinition.getType());
        this.crs = layerDefinition.getCrs();
        this.tileSize = layerDefinition.getTileSize() == 0 ? 256 : layerDefinition.getTileSize();
        this.maxZoom = layerDefinition.getMaxZoom() == 0 ? 18 : layerDefinition.getMaxZoom();
        this.minZoom = layerDefinition.getMinZoom() == 0 ? 0 : layerDefinition.getMinZoom();
        this.opacity = layerDefinition.getOpacity() == 0.0f ? 1.0f : layerDefinition.getOpacity();
        this.zoomOffset = layerDefinition.getZoomOffset() == 0 ? 0 : layerDefinition.getZoomOffset();
        this.swapAxis = !layerDefinition.getSwapAxis() ? false : layerDefinition.getSwapAxis();
        this.setProjection(this.crs);
    }

    protected void setProjection(String crs) {
        try {
            this.projectionEngine.setCrs(crs);
        }
        catch (Exception e) {
            this.projectionEngine.setCrs("EPSG:3857");
            this.crs = "EPSG:3857";
        }
    }

    public Point2D latLonToPixel(Coordinate latLon, int zoom) {
        Coordinate coordinate = this.getProjectionEngine().project(latLon);
        Point2D tlc = this.getTopLeftCornerInMeters();
        double longitude = (coordinate.getLongitude() - tlc.getX()) / this.getMetersPerPixelAtZoom(zoom);
        double latitude = (tlc.getY() - coordinate.getLatitude()) / this.getMetersPerPixelAtZoom(zoom);
        return new Point2D.Double(longitude, latitude);
    }

    public Coordinate pixelToLatLon(Point2D pixel, int zoom) {
        Point2D tlc = this.getTopLeftCornerInMeters();
        Coordinate coordinate = new Coordinate(tlc.getX() + pixel.getX() * this.getMetersPerPixelAtZoom(zoom), tlc.getY() - pixel.getY() * this.getMetersPerPixelAtZoom(zoom));
        return this.getProjectionEngine().unproject(coordinate);
    }

    public Point2D getTopLeftCornerInMeters() {
        double pl = this.getProjectionEngine().getPolarLength() / 2.0;
        double eq = -this.getProjectionEngine().getEquatorLength() / 2.0;
        Coordinate c = new Coordinate(eq, pl);
        return new Point2D.Double(c.getLongitude(), c.getLatitude());
    }

    public abstract double getMetersPerPixelAtZoom(int var1);

    public abstract String createTileUrl(int var1, int var2, int var3);

    public abstract Dimension getSizeInTiles(int var1);

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public LayerType getType() {
        return this.type;
    }

    public String getCrs() {
        return this.crs;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public int getZoomOffset() {
        return this.zoomOffset;
    }

    public boolean isSwapAxis() {
        return this.swapAxis;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ProjectionEngine getProjectionEngine() {
        return this.projectionEngine;
    }

    public void setType(LayerType type) {
        this.type = type;
    }

    public void setCrs(String crs) {
        this.crs = crs;
    }

    public void setTileSize(int tileSize) {
        this.tileSize = tileSize;
    }

    public void setMaxZoom(int maxZoom) {
        this.maxZoom = maxZoom;
    }

    public void setMinZoom(int minZoom) {
        this.minZoom = minZoom;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public void setZoomOffset(int zoomOffset) {
        this.zoomOffset = zoomOffset;
    }

    public void setSwapAxis(boolean swapAxis) {
        this.swapAxis = swapAxis;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

