/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map.geo;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import net.wirelabs.jmaps.map.geo.Coordinate;

public class GeoUtils {
    public static final double MPI = Math.PI;
    public static final double TWO_PI = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double ONE_DEG_IN_RAD = Math.PI / 180;
    public static final double ONE_RAD_IN_DEG = 57.29577951308232;

    public static String parseCrsUrn(String urn) {
        return urn.replace("urn:ogc:def:crs:", "").replaceAll(":.*:", ":");
    }

    public static double rad2deg(double rad) {
        return rad * 57.29577951308232;
    }

    public static double deg2rad(double deg) {
        return deg * (Math.PI / 180);
    }

    public static Rectangle2D calculateEnclosingRectangle(List<Coordinate> coordinates) {
        Point2D.Double firstPoint = new Point2D.Double(coordinates.get(0).getLongitude(), coordinates.get(0).getLatitude());
        Rectangle2D.Double r2 = new Rectangle2D.Double(((Point2D)firstPoint).getX(), ((Point2D)firstPoint).getY(), 0.0, 0.0);
        for (Coordinate c : coordinates) {
            Point2D.Double p = new Point2D.Double(c.getLongitude(), c.getLatitude());
            r2.add(p);
        }
        return r2;
    }

    public static Coordinate calculateCenterOfCoordinateSet(List<Coordinate> coordinates) {
        Rectangle2D r2 = GeoUtils.calculateEnclosingRectangle(coordinates);
        return new Coordinate(r2.getCenterX(), r2.getCenterY());
    }

    private GeoUtils() {
    }
}

